/*
 *  Copyright (C) 2008 Daniel Žalar (danizmax@gmail.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * HelpFrame.java
 *
 * Created on July 10, 2008, 8:48 AM
 */

package org.danizmax.jsymphonic.gui;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

/**
 *
 * @author  danizmax
 */
public class HelpFrame extends javax.swing.JFrame implements HyperlinkListener{

    private String documentURL = "";
    /** Creates new form HelpFrame */
    public HelpFrame() {
        initComponents();
        helpBrowserPane.addHyperlinkListener(this);

    }

    /**
     * Create new HelpFrame wth root page
     * @param urlString path to root page. Make sure you add protocol prefix (ie. http://)
     */
     public HelpFrame(String urlString) {
        initComponents();
        documentURL = urlString;
        helpBrowserPane.addHyperlinkListener(this);
        refresh();
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        helpBrowserPane = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/language"); // NOI18N
        setTitle(bundle.getString("HelpFram.JSyphonic_help")); // NOI18N
        setMinimumSize(new java.awt.Dimension(640, 480));

        helpBrowserPane.setEditable(false);
        jScrollPane1.setViewportView(helpBrowserPane);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 454, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new HelpFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane helpBrowserPane;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    /**
     * Get current URL
     * @return current URL
     */
    public String getDocumentURL() {
        return documentURL;
    }
    
    /**
     * Refresh the content to new URL
     */
    public void refresh(){
        try {
            helpBrowserPane.setPage(documentURL);
        } catch (IOException ex) {
            Logger.getLogger(HelpFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /**
     * Set path to new root URL
     * @param documentURL path to new root URL
     */
    public void setDocumentURL(String documentURL) {
        this.documentURL = documentURL;
    }

    /**
     * This method is called when a link is clicked
     * @param arg0
     */
    public void hyperlinkUpdate(HyperlinkEvent arg0) {
        HyperlinkEvent.EventType eventType = arg0.getEventType();
        if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            if (arg0 instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument document = (HTMLDocument) helpBrowserPane.getDocument();
                HTMLFrameHyperlinkEvent linkEvent = (HTMLFrameHyperlinkEvent) arg0;
                document.processHTMLFrameHyperlinkEvent(linkEvent);
            } else {
                documentURL += arg0.getURL().getPath();
                refresh();
            }
        }
    }

}
