/*
 *  Copyright (C) 2008 Daniel Žalar (danizmax@gmail.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Created on June 7, 2008, 9:57 PM
 */

package org.danizmax.jsymphonic.gui.local;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.danizmax.jsymphonic.toolkit.DynamicDeviceTreePopUp;
import org.naurd.media.jsymphonic.toolBox.FFMpegToolBox;



/**
 * This class is a JPanel component that shows the state of local filesystem
 * @author  danizmax - Daniel Žalar (danizmax@gmail.com)
 */
public class LocalPanel extends javax.swing.JPanel implements FileLoadingListener{

    private String localPath = null;
    private localManager manager = new localManager();
    private DynamicDeviceTreePopUp treePopUp;
    private TreeMap fileExtentionMap = new TreeMap();

    private static Logger logger = Logger.getLogger("org.danizmax.gui.DevicePanel");
    private Thread reloadTreeThread;

    /** Creates new form LocalPanel */
    public LocalPanel() {
        treePopUp = new DynamicDeviceTreePopUp(this, localTree);
        try {
            initComponents();
       }
        catch(Exception e){
            logger.severe("Error while initializaing local panel");
            e.printStackTrace();
        }
        
        // Set files extension available
        fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.All_Files"), "");
        fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.Mp3_Files"), "mp3");
        fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.Oma_Files"), "oma");
        
        if(FFMpegToolBox.isFFMpegPresent()) {
            // Set files extension available when FFMPEG is present
            fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.Wma_Files"), "wma");
            fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.Ogg_Files"), "ogg");
            fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.Flac_Files"), "flac");
            fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.Mpc_Files"), "mpc");
            fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.All_Music_Files"), "mp3,oma,wma,ogg,mpc,flac");
        }
        else {
            // Set files extension available when FFMPEG is not present
            fileExtentionMap.put(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.All_Music_Files"), "mp3,oma");
        }
        
        // Load file extentions into the combobox
        Set eS = fileExtentionMap.keySet();
        Iterator eit = eS.iterator();
        while(eit.hasNext()){
            extentionComboBox.addItem(eit.next());
        }
        
        // Select the default format to be display in the local tree
        extentionComboBox.setSelectedItem(java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.All_Music_Files")); //set the default selection

        treePopUp.setTree(localTree);
        manager.setLocalTree(localTree);
        manager.addLoadingEventListener(this);
        setControlsvisible(true);
        localTree.setComponentPopupMenu(treePopUp);
    }
    
    /**
     * Creates new form LocalPanel with designated local path
     * @param localPath
     */
  /*  public LocalPanel(String localPath) {
        initComponents();
        this.localPath = localPath;
        manager.setLocalTree(localTree);
        manager.setLocalPath(localPath);
    }*/

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        clearButton = new javax.swing.JButton();
        filterTextField = new javax.swing.JTextField();
        filterButton = new javax.swing.JButton();
        viewComboBox = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        localTree = new javax.swing.JTree();
        extentionComboBox = new javax.swing.JComboBox();
        loadingLabel = new javax.swing.JLabel();
        cancelLoadingButton = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setName("Form"); // NOI18N

        clearButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/clear_right.png"))); // NOI18N
        clearButton.setName("clearButton"); // NOI18N
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });

        filterTextField.setMinimumSize(new java.awt.Dimension(4, 28));
        filterTextField.setName("filterTextField"); // NOI18N
        filterTextField.setPreferredSize(new java.awt.Dimension(4, 20));
        filterTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                filterTextFieldKeyPressed(evt);
            }
        });

        filterButton.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        filterButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/filter.png"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/language"); // NOI18N
        filterButton.setText(bundle.getString("global.Filter")); // NOI18N
        filterButton.setMinimumSize(new java.awt.Dimension(81, 28));
        filterButton.setName("filterButton"); // NOI18N
        filterButton.setPreferredSize(new java.awt.Dimension(81, 28));
        filterButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterButtonActionPerformed(evt);
            }
        });

        viewComboBox.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        viewComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Artist/Album/Title", "Artists/Titles", "Albums/Titles", "Genres/Artists/Albums/Titles" }));
        viewComboBox.setEnabled(false);
        viewComboBox.setName("viewComboBox"); // NOI18N
        viewComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewComboBoxActionPerformed(evt);
            }
        });

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        localTree.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        localTree.setName("localTree"); // NOI18N
        localTree.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                localTreeMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                localTreeMouseReleased(evt);
            }
        });
        localTree.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                localTreeComponentShown(evt);
            }
        });
        localTree.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                localTreeMouseDragged(evt);
            }
        });
        jScrollPane1.setViewportView(localTree);

        extentionComboBox.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        extentionComboBox.setMaximumSize(new java.awt.Dimension(32767, 20));
        extentionComboBox.setMinimumSize(new java.awt.Dimension(68, 20));
        extentionComboBox.setName("extentionComboBox"); // NOI18N
        extentionComboBox.setPreferredSize(new java.awt.Dimension(68, 20));
        extentionComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                extentionComboBoxActionPerformed(evt);
            }
        });

        loadingLabel.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        loadingLabel.setText(bundle.getString("LocalPanel.loadingLabel.text")); // NOI18N
        loadingLabel.setName("loadingLabel"); // NOI18N

        cancelLoadingButton.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        cancelLoadingButton.setText(bundle.getString("LocalPanel.cancelLoadingButton.text")); // NOI18N
        cancelLoadingButton.setName("cancelLoadingButton"); // NOI18N
        cancelLoadingButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelLoadingButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 316, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(loadingLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 232, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelLoadingButton))
                    .addComponent(extentionComboBox, javax.swing.GroupLayout.Alignment.LEADING, 0, 316, Short.MAX_VALUE)
                    .addComponent(viewComboBox, 0, 316, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(clearButton, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(filterTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 196, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(filterButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelLoadingButton)
                    .addComponent(loadingLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(filterButton, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(filterTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(clearButton, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(viewComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 262, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(extentionComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
    filterTextField.setText("");
    //getSelectedTracks();
    reloadTree();
}//GEN-LAST:event_clearButtonActionPerformed

private void filterTextFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_filterTextFieldKeyPressed
    if(evt.getKeyCode() == 10){
           filterButton.doClick();
    }
}//GEN-LAST:event_filterTextFieldKeyPressed

private void filterButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterButtonActionPerformed
    reloadTree();
}//GEN-LAST:event_filterButtonActionPerformed

/*public void reloadTree() {
    reloadTreeThread = new Thread(){
        boolean cont = true;
        @Override
        public void run(){
            try{
                reloadTreeInThread();
            } catch(Exception e){}
        }
    };
    reloadTreeThread.setPriority(Thread.NORM_PRIORITY);
    reloadTreeThread.start();
    reloadTreeThread = null;
}*/

public void setControlsvisible(boolean enabled){
    cancelLoadingButton.setVisible(!enabled);
    loadingLabel.setVisible(!enabled);
    localTree.setVisible(enabled);
    clearButton.setVisible(enabled);
    filterButton.setVisible(enabled);
    filterTextField.setVisible(enabled);
    extentionComboBox.setVisible(enabled);
    viewComboBox.setVisible(enabled);
    jScrollPane1.setVisible(enabled);
    localTree.setVisible(enabled);

}

public void reloadTree() {
    if((new File(localPath)).exists()) {
        manager.setFilterString(filterTextField.getText());
        manager.setFileExtention((String) fileExtentionMap.get(extentionComboBox.getSelectedItem()));

// TESTPOINT        manager.refreshTree();

        Thread refreshTreeThread = new Thread(){
            @Override
            public void run(){
                try{
                    manager.refreshTree();
                } catch(Exception e){}
            }
        };
        refreshTreeThread.setPriority(Thread.NORM_PRIORITY);
        refreshTreeThread.start();
        refreshTreeThread = null;
    }
    else {
        JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.invalid_path"), java.util.ResourceBundle.getBundle("localization/language").getString("LocalPanel.path_error"), JOptionPane.INFORMATION_MESSAGE);
    }
}


private void viewComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_viewComboBoxActionPerformed
//getManager().refreshTreeDevice(viewComboBox.getSelectedIndex(), filterTextField.getText());
}//GEN-LAST:event_viewComboBoxActionPerformed

private void localTreeMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_localTreeMousePressed

}//GEN-LAST:event_localTreeMousePressed

private void localTreeMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_localTreeMouseReleased

}//GEN-LAST:event_localTreeMouseReleased

private void localTreeComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_localTreeComponentShown

}//GEN-LAST:event_localTreeComponentShown

private void localTreeMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_localTreeMouseDragged
// TODO add your handling code here:
}//GEN-LAST:event_localTreeMouseDragged

private void extentionComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_extentionComboBoxActionPerformed
    if(manager != null && localPath != null) //this prevents exceptions at loading!
        reloadTree();
}//GEN-LAST:event_extentionComboBoxActionPerformed

private void cancelLoadingButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelLoadingButtonActionPerformed
    manager.stopLoading();
}//GEN-LAST:event_cancelLoadingButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelLoadingButton;
    private javax.swing.JButton clearButton;
    private javax.swing.JComboBox extentionComboBox;
    private javax.swing.JButton filterButton;
    private javax.swing.JTextField filterTextField;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel loadingLabel;
    private javax.swing.JTree localTree;
    private javax.swing.JComboBox viewComboBox;
    // End of variables declaration//GEN-END:variables

    public String getLocalPath() {
        return localPath;
    }

    public File[] getSelectedTracks() {
        return manager.getSelectedFiles();
    }
    
    public void setLocalPath(String localPath) {
        this.localPath = localPath;
        manager.setLocalPath(localPath);
    }

    public void fileLoadingChanged(boolean loading) {
        setControlsvisible(!loading);
    }

}
