/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com)
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * JSymphonicAbout.java
 *
 * Created on May 18, 2008, 9:02 PM
 * 
 */

package org.danizmax.jsymphonic.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This JFrame is used to show information about the application
 * @author  danizmax - Daniel Žalar (danizmax@gmail.com)
 */
public class JSymphonicAbout extends javax.swing.JFrame {

    /** Creates new form JSymphonicAbout */
    public JSymphonicAbout(String title, String nameAndVersion, String comment, String credits) {
        initComponents();
        this.setTitle(title);
        AplicationNameAndVersionLabel.setText(nameAndVersion);
        commentLabel.setText(comment);
        creditsTextArea.setText(credits);
        loadLicenseTextArea();
        creditsTextArea.moveCaretPosition(0);
        licenseTextArea.moveCaretPosition(0);
        printSysInfo();
    }
    
    void printSysInfo(){
        Properties p = System.getProperties();
        Enumeration keys = p.keys();
        sysInfoTextArea.removeAll();
        while (keys.hasMoreElements()) {
          String key = (String)keys.nextElement();
          String value = (String)p.get(key);
          sysInfoTextArea.append(key + ": " + value + "\n");
        }
        sysInfoTextArea.moveCaretPosition(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        AplicationNameAndVersionLabel = new javax.swing.JLabel();
        commentLabel = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        creditsPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        creditsTextArea = new javax.swing.JTextArea();
        licensePanel = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        licenseTextArea = new javax.swing.JTextArea();
        sysPanel = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        sysInfoTextArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(java.util.ResourceBundle.getBundle("localization/jsymphonicwindow").getString("JSymphonicWindow.About_JSymphonic")); // NOI18N
        setName("Form"); // NOI18N

        AplicationNameAndVersionLabel.setFont(new java.awt.Font("Bitstream Vera Sans", 1, 18));
        AplicationNameAndVersionLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        AplicationNameAndVersionLabel.setText(java.util.ResourceBundle.getBundle("localization/misc").getString("global.version")); // NOI18N
        AplicationNameAndVersionLabel.setName("AplicationNameAndVersionLabel"); // NOI18N

        commentLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        commentLabel.setText(java.util.ResourceBundle.getBundle("localization/misc").getString("JSymphonicAbout.commentLabel.text")); // NOI18N
        commentLabel.setName("commentLabel"); // NOI18N

        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        creditsPanel.setName("creditsPanel"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        creditsTextArea.setColumns(20);
        creditsTextArea.setEditable(false);
        creditsTextArea.setLineWrap(true);
        creditsTextArea.setRows(5);
        creditsTextArea.setWrapStyleWord(true);
        creditsTextArea.setAutoscrolls(false);
        creditsTextArea.setName("creditsTextArea"); // NOI18N
        jScrollPane1.setViewportView(creditsTextArea);

        org.jdesktop.layout.GroupLayout creditsPanelLayout = new org.jdesktop.layout.GroupLayout(creditsPanel);
        creditsPanel.setLayout(creditsPanelLayout);
        creditsPanelLayout.setHorizontalGroup(
            creditsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(creditsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 434, Short.MAX_VALUE)
                .addContainerGap())
        );
        creditsPanelLayout.setVerticalGroup(
            creditsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(creditsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(java.util.ResourceBundle.getBundle("localization/misc").getString("JSymphonicAbout.creditsPanel.TabConstraints.tabTitle"), creditsPanel); // NOI18N

        licensePanel.setName("licensePanel"); // NOI18N

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        licenseTextArea.setColumns(20);
        licenseTextArea.setEditable(false);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setRows(5);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setAutoscrolls(false);
        licenseTextArea.setName("licenseTextArea"); // NOI18N
        jScrollPane2.setViewportView(licenseTextArea);

        org.jdesktop.layout.GroupLayout licensePanelLayout = new org.jdesktop.layout.GroupLayout(licensePanel);
        licensePanel.setLayout(licensePanelLayout);
        licensePanelLayout.setHorizontalGroup(
            licensePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(licensePanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 434, Short.MAX_VALUE)
                .addContainerGap())
        );
        licensePanelLayout.setVerticalGroup(
            licensePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(licensePanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(java.util.ResourceBundle.getBundle("localization/misc").getString("JSymphonicAbout.licensePanel.TabConstraints.tabTitle"), licensePanel); // NOI18N

        sysPanel.setName("sysPanel"); // NOI18N

        jScrollPane3.setName("jScrollPane3"); // NOI18N

        sysInfoTextArea.setColumns(20);
        sysInfoTextArea.setEditable(false);
        sysInfoTextArea.setRows(5);
        sysInfoTextArea.setName("sysInfoTextArea"); // NOI18N
        jScrollPane3.setViewportView(sysInfoTextArea);

        org.jdesktop.layout.GroupLayout sysPanelLayout = new org.jdesktop.layout.GroupLayout(sysPanel);
        sysPanel.setLayout(sysPanelLayout);
        sysPanelLayout.setHorizontalGroup(
            sysPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(sysPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 434, Short.MAX_VALUE)
                .addContainerGap())
        );
        sysPanelLayout.setVerticalGroup(
            sysPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(sysPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(java.util.ResourceBundle.getBundle("localization/misc").getString("JSymphonicAbout.sysPanel.TabConstraints.tabTitle"), sysPanel); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 463, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, commentLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 463, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, AplicationNameAndVersionLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 463, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(AplicationNameAndVersionLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(commentLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel AplicationNameAndVersionLabel;
    private javax.swing.JLabel commentLabel;
    private javax.swing.JPanel creditsPanel;
    private javax.swing.JTextArea creditsTextArea;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JPanel licensePanel;
    private javax.swing.JTextArea licenseTextArea;
    private javax.swing.JTextArea sysInfoTextArea;
    private javax.swing.JPanel sysPanel;
    // End of variables declaration//GEN-END:variables

    /**
     * Load the license file into the license text area.
     * The license file is stored in "org/danizmax/jsymphonic/resources". It is named "COPYING-xx_XX" where xx_XX is the language code. If the license is not translated into the current language (the file doesn't exist), load the english version named "COPYING.txt".
     */
    private void loadLicenseTextArea() {
        BufferedReader licenseReader = null;
    
        // Try to load the license file corresponding to the current language code
        try {
            licenseReader = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream("/org/danizmax/jsymphonic/resources/COPYING_"+Locale.getDefault().toString()+".txt")));
        }
        catch(Exception e){
            try {
                // If an exception was thrown, load the english version
                licenseReader = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream("/org/danizmax/jsymphonic/resources/COPYING.txt")));
            } catch (Exception ex) {
                ex.printStackTrace();
                Logger.getLogger(JSymphonicAbout.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        // Load the text from the file to the text area
        try {
            String str;
            while ((str = licenseReader.readLine()) != null) {
                licenseTextArea.append(str + "\n"); // Add each read line to the text area
            }
            licenseReader.close();
        } 
        catch (Exception e) {}
    }

}
