=begin
  config.rb -- KAGEMAI configuration file.
  $Id: config.rb,v 1.2.2.2 2005/01/15 06:56:06 fukuoka Exp $
=end

require 'rbconfig'
require 'kagemai/error'

$RUBY_BINARY = "#{Config::CONFIG['bindir']}/#{Config::CONFIG['ruby_install_name']}"

module Kagemai
  CONFIG_VAR_NAMES = %w(
    maintenance_mode
    language charset
    home_url
    base_url
    action_dir 
    project_dir resource_dir
    mailer
    smtp_server smtp_port
    mail_command
    default_template_dir
    message_bundle_name
    default_store
    default_template
    subject_id_figure
    fold_column
    css_url
    max_attachment_size
    use_html_cache
    guest_mode_cgi user_mode_cgi admin_mode_cgi
    use_javascript
    allow_mail_body_command
    search_form_method
    pretty_html
    enable_postgres postgres_host postgres_port postgres_user
    postgres_pass postgres_opts
    enable_mssql mssql_dsn mssql_user mssql_pass
    enable_mysql mysql_host mysql_port mysql_user mysql_pass mysql_dbname
    enable_gdchart
    gd_font
    gd_charset
    rss_feed_title
  )
  
  DEFAULT_CONFIG = {
    :maintenance_mode => false,

    :language => 'ja',       # default language.
    :charset  => 'EUC-JP',   # default charset.
    
    :home_url => 'http://www.daifukuya.com/kagemai/', # setup
    :base_url => 'http://localhost/kagemai/',         # setup
    
    # mailer
    :mailer => 'Kagemai::SmtpMailer',
    
    # SMTP server address
    :smtp_server => 'localhost' , # setup
    :smtp_port   => 25,           # setup
    
    # default mail command for MailCommandMailer
    :mail_command => '/usr/bin/mail', # setup
    
    # default template dir
    :default_template_dir => '_default',
    
    # default message bundle file
    :message_bundle_name => 'messages',
    
    # ǥեȤ¸
    :default_store => 'Kagemai::XMLFileStore',
    
    # ǥեȤΥƥץ졼
    :default_template => 'simple',
    
    # ᡼Υ֥Ȥ ID η
    :subject_id_figure => 4,
    
    # ƥȤޤ֤
    :fold_column => 64,
    
    # źեե¥ [KBytes]0 ʲʤ¤ʤ
    :max_attachment_size => 0,

    # HTML åȤɤ
    :use_html_cache => true,
    
    # *.cgi ̾
    :guest_mode_cgi => 'guest.cgi',
    :user_mode_cgi  => 'user.cgi',
    :admin_mode_cgi => 'admin.cgi',
        
    # 륷Ȥ URL
    :css_url => 'kagemai.css',
    
    # Javascript 
    :use_javascript => true,
    
    # ᡼ǤΥåǤͤѹβ
    :allow_mail_body_command => true,
    
    # ե METHOD 
    :search_form_method => "GET",

    # HTML Ԥɤ
    :pretty_html => false,
    
    # PostgreSQL
    :enable_postgres => false,     # setup
    :postgres_host => '/tmp',      # setup
    :postgres_port => '',          # setup
    :postgres_user => 'kagemai',   # setup
    :postgres_pass => '',          # setup
    :postgres_opts => '',          # setup

    # MS SQL Server
    :enable_mssql => false,
    :mssql_dsn    => 'kagemai',
    :mssql_user   => '',
    :mssql_pass   => '',
    
    # MySQL
    :enable_mysql => false,
    :mysql_host   => 'localhost',
    :mysql_port   => '3306',
    :mysql_user   => 'kagemai',
    :mysql_pass   => '',
    :mysql_dbname => 'kagemai',
    
    # GDChart for summary
    :enable_gdchart => false,
    :gd_font => '/usr/X11R6/lib/X11/fonts/TrueType/kochi-gothic.ttf',
    :gd_charset  => 'EUC-JP',
 
    # title for RSS-all
    :rss_feed_title => 'Bug Tracking System Kagemai',
  }

  module Config
    def self.initialize(root, config_file)
      @@root = root
      @@config_file = config_file
      
      hash = {
        :action_dir   => "#{root}/lib/kagemai/cgi/action",
        :project_dir  => "#{root}/project",
        :resource_dir => "#{root}/resource",
        
        # mode of dir and file
        :dir_mode  => 02775,
        :file_mode => 0664,
      }
      hash.update(DEFAULT_CONFIG)
      
      Thread.current[:Config] = hash
      
      if !config_file.to_s.empty? && File.exists?(config_file) then
        load config_file
      end
    end
    
    def self.root() @@root; end
    def self.config_file() @@config_file; end
    
    def self.[](key)
      hash = Thread.current[:Config]
      raise ConfigError, "key not found: #{key}" unless hash.has_key?(key)
      hash[key]
    end
    
    def self.[]=(key, value)
      Thread.current[:Config][key] = value
    end
  end
  
  # MIME_TYPES
  MIME_TYPES = [
    'text/plain',
    'text/html',
    'image/jpeg',
    'image/png'
  ]

  TOP_PAGE_OPTIONS = {
    'count'               => true,
    'list'                => true,
    'id_form'             => true,
    'keyword_search_form' => true,
    'search_form'         => false
  }

end
