//
// C++ Interface: copyfieldcontent
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef COPYFIELDCONTENT_H
#define COPYFIELDCONTENT_H

#include <kdialogbase.h>
#include <kcombobox.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h> 
#include <qcheckbox.h>
#include <qradiobutton.h>


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class CopyFieldContentDlg : public KDialogBase
{
Q_OBJECT
public:
    CopyFieldContentDlg(bool selected, QWidget *parent = 0, const char *name = 0);
	QString sourceFieldName() { return (m_sourceField->currentText()).simplifyWhiteSpace().lower(); }
	QString destinationFieldName() { return (m_destinationField->currentText()).stripWhiteSpace().lower() ; }
	bool isAllReferences() { return m_allEntrySelect->isChecked(); }
	bool clearSourceContent() { return m_clearSourceContent->isChecked(); }

    ~CopyFieldContentDlg();

private:
	KComboBox *m_sourceField;
	KComboBox *m_destinationField;
	QCheckBox *m_clearSourceContent;
	QVGroupBox *m_optionGroup;
	QButtonGroup *m_buttonGroup;
	QRadioButton *m_allEntrySelect;
	QRadioButton *m_selectedEntrySelect;
		
};

#endif
