//
// C++ Interface: grs1importer
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GRS1IMPORTER_H
#define GRS1IMPORTER_H

#include <qobject.h>
#include <qvariant.h>
#include <qstring.h>

#include "bibentry.h"

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class GRS1Importer : public QObject
{
Q_OBJECT
public:
    GRS1Importer(const QString& text);

    ~GRS1Importer();
	BibEntry* import();
	private:
		static void initTagMap();

		class TagPair : public QPair<int, QVariant> {
			public:
				TagPair() : QPair<int, QVariant>(-1, QVariant()) {}
				TagPair(int n, const QVariant& v) : QPair<int, QVariant>(n, v) {}
				QString toString() const { return QString::number(first) + second.toString(); }
				bool operator< (const TagPair& p) const {
					return toString() < p.toString();
				}
		};

		typedef QMap<TagPair, QString> TagMap;
		static TagMap* s_tagMap;
		QString m_text;
};



#endif
