//
// C++ Interface: id2entry
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ID2ENTRY_H
#define ID2ENTRY_H

#include <qobject.h>
#include <kurl.h>
#include <kprogress.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qtimer.h>
#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>

#include "bibentry.h"

enum IDType {
			DOI,
   			arXiv,
	  		PMID
		};

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class ID2Entry : public QObject
{
Q_OBJECT
public:
    ID2Entry(QObject *parent = 0, const char *name = 0, BibEntry *entry = 0);

    ~ID2Entry();
	void setIDType(IDType type) { m_type = type; }
	void setID(QString id) { m_ID = id; }
	void setEntry(BibEntry *entry) { if (entry) m_entry = new BibEntry(*entry); else m_entry = 0; }
	void search(); 
	void stop();
	
	private slots:
		void slotData(KIO::Job* job, const QByteArray& data);
		void slotComplete(KIO::Job* job);	
		void check();
	
	signals:
		void signalResultFound(BibEntry* e);
		
	private:
		void parseCrossRef();
		void parseCiteBase();
		void parsePubmed();
		
		enum Step {
			Begin,
			Search,
			Wait,
			Fetch
		};

		KURL m_url;
		QString m_ID;
		IDType m_type;
		BibEntry *m_entry;
		QGuardedPtr<KIO::Job> m_job;
		Step m_step;
		bool m_started;
		QByteArray m_data;
		
		KProgressDialog *progressDlg;
		QTimer *m_timer;
};

#endif
