//
// C++ Implementation: kbibgroupviewgroup
//
// Description:
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kbibgroupviewgroup.h"
#include <qpainter.h>
#include <qpixmap.h>
#include <kstringhandler.h>
KBibGroupViewGroup::KBibGroupViewGroup ( QString m_value, QListView *parent )
		: QListViewItem ( parent )
{
	m_list.setAutoDelete ( false );
	value = m_value;
	this->setText ( 0, value );
	this->setSelectable ( false );
}


KBibGroupViewGroup::~KBibGroupViewGroup()
{
	m_list.clear();

}


void KBibGroupViewGroup::addEntry ( BibEntry *entry )
{
	KBibGroupViewItem *item = new KBibGroupViewItem ( entry, this );
	m_list.append ( item );
	QString st;
	st = st.setNum ( m_list.count() );
	QString stcnt = value;
	stcnt.append ( " (" );
	stcnt.append ( st );
	stcnt.append ( ")" );
	this->setText ( 0, stcnt );
}

void KBibGroupViewGroup::paintCell ( QPainter* p_, const QColorGroup& cg_,
                                     int column_, int width_, int align_ )
{
	if ( !p_ )
	{
		return;
	}

	
	int marg = listView()->itemMargin();
	int r = marg;
	QRect br ( 0, height(), r, 0 );
	if (value == QString::fromLatin1("<Empty>")){
		QFont font = p_->font();
		font.setBold(true);
		p_->setFont(font);
	}
	else
		p_->setPen ( cg_.text() );
	p_->eraseRect(0,0, width_, height());
	p_->drawText ( r, 0, width_-marg-r, height(), align_ | AlignVCenter, value, -1, &br );

	QString numText = QString::fromLatin1 ( "   (%1)" ).arg ( m_list.count() );

	QColor hl = cg_.highlight();
	//p_->setPen( cg_.highlight()  );
	p_->setPen ( QColor ( 255,0,0 ) );
	QFont font = p_->font();
	font.setBold(false);
	p_->setFont(font);
	p_->drawText ( br.right(), 0, width_-marg-br.right(), height(), align_ | Qt::AlignVCenter, numText );
}

#include "kbibgroupviewgroup.moc"
