/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/


#ifndef KBLOGGER_BLOG_H
#define KBLOGGER_BLOG_H

#include <qvariant.h>
#include <kurl.h>

#include "backend/backend.h"

class KIcon;

namespace KWallet
{
class Wallet;
}

namespace KBlogger
{

/**
 * @brief
 * This class represents a BlogServer (or simply a Blog) and not only an API. 
 * We need this to add more stuff like the icons and the blog name and map it
 * to a type (which then maps to an API (KBlog::Blog)).
 *
 *  Usage:
 *  Every kblogger class can access to blogServer information using backend.
 *  So for example if a kblogger class need to know the url
 *  you need something simple like this:
 *  
 *  KUrl mUrl;
 *  mUrl=backend::self()->blogServer( blogname_or_profilename )->url();
 */


class BlogServer
{

public:
    BlogServer();

    ~BlogServer();

    //It's the profile name of this blogserver settings.
    void setBlogname( const QString& blogname );
    QString blogname();

    //BlogServer Url
    void setUrl( const QString& url );
    KUrl url();

    //Account username
    void setUsername( const QString& username );
    QString username();
    
    //Account password
    //void setPassword( const QString& password );
    QString password();
    
    /*
    void setFullName( const QString& fullname );
    QString fullName();
    */

    //blog type. watch 
    void setType( int type );
    int type();

    //Blog ID
    void setBlogId( const QString& id );
    QString blogId();

    KIcon icon();

    //get a BlogServer parameter
    QVariant getBlogServerValue( QString parameter );

private:
    QString mBlogname;
    KUrl    mUrl;
    QString mUsername;
    QString mFullName;
    QString mBlogId;
    int mType;
    KWallet::Wallet* mWallet;
};

}
 // namespace

#endif

