/***************************************************************************

   Copyright (C) 2005-2007 by Christian Weilbach <christian_weilbach@web.de>
   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef COMPOSER_H
#define COMPOSER_H

#include <QDir>

#include <ktextedit.h>

#include "ui_composerbase.h"


namespace KBlogger
{
class Backend;
class Post;
class ComposerEditor;
class ItemsManager;

class Composer : public QDialog, public Ui::ComposerBase
{
    Q_OBJECT

public:
    explicit Composer( Post* post = 0, QWidget* parent = 0 );
    explicit Composer( const QString& blogname , QWidget* parent = 0);
    ~Composer();
    QString blogname();

public Q_SLOTS:
    virtual void enqueueSlot();
    void slotCategoryInfoRetrieved( const QList< QMap<QString, QString> >& categories);

private Q_SLOTS:
    void updateBlogOptions(const QString& blogname);
    void slotRefreshCateroriesFromServer();
    void hideFirstCategory( const QString& categoryToHide );

private:
    //Functions
    void initialize ();
    void loadPostSlot ( Post* post ); //Load a post to edit

    void getCategories (const QString& blogname); //get categories from server
    bool loadCategories(const QString& blogname); //load categories from a file
    void saveCategories(const QString& blogname,
                        const QList< QMap<QString, QString> >* categories);
    void fillCategoriesWidgets(const QList< QMap<QString, QString> >* categories);
    void setBlogname( const QString& blogname = QString() );
    // added for convenience in updateBlogOptions()
    void showCategoryOptions( bool );
    //setChecked(true) the categories of the categoriesList (QListViewWidget).
    void checkOtherCategories( QStringList& categories ); 

    //Vars
    Backend* mBackend;
    ItemsManager *mItemsManager;
    QString mEditCategory,mBlogname;
    Post *mPostToModify;
    ComposerEditor *mEditor;


};
} //namespace
#endif

