//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  Displays a round or rectangular light emitting diode.
	///  It is configurable to arbitrary colors, the two on/off states and three
	///  styles (or "looks");
	///  It may display itself in a performant flat view, a round view with
	///  light spot or a round view sunken in the screen.
	///  \image html kled.png "KDE LED Widget"
	/// </remarks>		<author> Joerg Habenicht, Richard J. Moore (rich@kde.org) 1998, 1999
	///  </author>
	/// 		<short> An LED widget. </short>

	[SmokeClass("KLed")]
	public class KLed : QWidget, IDisposable {
 		protected KLed(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KLed), this);
		}
		/// <remarks>
		///  Status of the light is on/off.
		/// </remarks>		<short> LED on/off.      </short>
		public enum State {
			Off = 0,
			On = 1,
		}
		/// <remarks>
		///  Shades of the lamp.
		/// </remarks>		<short> LED shape.</short>
		public enum Shape {
			Rectangular = 0,
			Circular = 1,
		}
		/// <remarks>
		///  Displays a flat, round or sunken LED.
		///  Displaying the LED flat is less time and color consuming,
		///  but not so nice to see.
		///  The sunken LED itself is (certainly) smaller than the round LED
		///  because of the 3 shading circles and is
		///  most time consuming. Makes sense for LED > 15x15 pixels.
		///  <b></b>imings: \n
		///  ( AMD K5/133, Diamond Stealth 64 PCI Graphics, widgetsize 29x29 )
		/// 
		/// <li>
		/// flat Approximately 0.7 msec per paint
		/// </li>
		/// 
		/// <li>
		/// round Approximately 2.9 msec per paint
		/// </li>
		/// 
		/// <li>
		/// sunken Approximately 3.3 msec per paint
		/// </li>
		///  The widget will be updated on the next repaining event.
		/// </remarks>		<short> LED look.      </short>
		public enum Look {
			Flat = 0,
			Raised = 1,
			Sunken = 2,
		}
		[Q_PROPERTY("KLed::State", "state")]
		public KLed.State state {
			get { return (KLed.State) interceptor.Invoke("state", "state()", typeof(KLed.State)); }
			set { interceptor.Invoke("setState$", "setState(KLed::State)", typeof(void), typeof(KLed.State), value); }
		}
		[Q_PROPERTY("KLed::Shape", "shape")]
		public KLed.Shape shape {
			get { return (KLed.Shape) interceptor.Invoke("shape", "shape()", typeof(KLed.Shape)); }
			set { interceptor.Invoke("setShape$", "setShape(KLed::Shape)", typeof(void), typeof(KLed.Shape), value); }
		}
		[Q_PROPERTY("KLed::Look", "look")]
		public KLed.Look look {
			get { return (KLed.Look) interceptor.Invoke("look", "look()", typeof(KLed.Look)); }
			set { interceptor.Invoke("setLook$", "setLook(KLed::Look)", typeof(void), typeof(KLed.Look), value); }
		}
		[Q_PROPERTY("QColor", "color")]
		public QColor Color {
			get { return (QColor) interceptor.Invoke("color", "color()", typeof(QColor)); }
			set { interceptor.Invoke("setColor#", "setColor(QColor)", typeof(void), typeof(QColor), value); }
		}
		[Q_PROPERTY("int", "darkFactor")]
		public int DarkFactor {
			get { return (int) interceptor.Invoke("darkFactor", "darkFactor()", typeof(int)); }
			set { interceptor.Invoke("setDarkFactor$", "setDarkFactor(int)", typeof(void), typeof(int), value); }
		}
		/// <remarks>
		///  Constructs a green, round LED widget which will initially
		///  be turned on.
		/// <param> name="parent" The parent widget.
		///      </param></remarks>		<short>    Constructs a green, round LED widget which will initially  be turned on.</short>
		public KLed(QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KLed#", "KLed(QWidget*)", typeof(void), typeof(QWidget), parent);
		}
		public KLed() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KLed", "KLed()", typeof(void));
		}
		/// <remarks>
		///  Constructs a round LED widget with the supplied color which will
		///  initially be turned on.
		/// <param> name="color" Initial color of the LED.
		/// </param><param> name="parent" The parent widget.
		/// </param></remarks>		<short> Constructor.</short>
		public KLed(QColor color, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KLed##", "KLed(const QColor&, QWidget*)", typeof(void), typeof(QColor), color, typeof(QWidget), parent);
		}
		public KLed(QColor color) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KLed#", "KLed(const QColor&)", typeof(void), typeof(QColor), color);
		}
		/// <remarks>
		///  Constructor with the color, state and look.
		///  Differs from above only in the parameters, which configure all settings.
		/// <param> name="color" Initial color of the LED.
		/// </param><param> name="state" Sets the State.
		/// </param><param> name="look" Sets the Look.
		/// </param><param> name="shape" Sets the Shape (rectangular or circular).
		/// </param><param> name="parent" The parent widget.
		/// </param></remarks>		<short> Constructor.</short>
		public KLed(QColor color, KLed.State state, KLed.Look look, KLed.Shape shape, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KLed#$$$#", "KLed(const QColor&, KLed::State, KLed::Look, KLed::Shape, QWidget*)", typeof(void), typeof(QColor), color, typeof(KLed.State), state, typeof(KLed.Look), look, typeof(KLed.Shape), shape, typeof(QWidget), parent);
		}
		public KLed(QColor color, KLed.State state, KLed.Look look, KLed.Shape shape) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KLed#$$$", "KLed(const QColor&, KLed::State, KLed::Look, KLed::Shape)", typeof(void), typeof(QColor), color, typeof(KLed.State), state, typeof(KLed.Look), look, typeof(KLed.Shape), shape);
		}
		[SmokeMethod("sizeHint() const")]
		public override QSize SizeHint() {
			return (QSize) interceptor.Invoke("sizeHint", "sizeHint() const", typeof(QSize));
		}
		[SmokeMethod("minimumSizeHint() const")]
		public override QSize MinimumSizeHint() {
			return (QSize) interceptor.Invoke("minimumSizeHint", "minimumSizeHint() const", typeof(QSize));
		}
		/// <remarks>
		///  Toggles the state of the led from Off to On or vice versa.
		///  The widget repaints itself immediately.
		///      </remarks>		<short>    Toggles the state of the led from Off to On or vice versa.</short>
		[Q_SLOT("void toggle()")]
		public void Toggle() {
			interceptor.Invoke("toggle", "toggle()", typeof(void));
		}
		/// <remarks>
		///  Sets the state of the widget to On.
		///  The widget will be painted immediately.
		/// </remarks>		<short>    Sets the state of the widget to On.</short>
		/// 		<see> off</see>
		/// 		<see> toggle</see>
		/// 		<see> setState</see>
		[Q_SLOT("void on()")]
		public void On() {
			interceptor.Invoke("on", "on()", typeof(void));
		}
		/// <remarks>
		///  Sets the state of the widget to Off.
		///  The widget will be painted immediately.
		/// </remarks>		<short>    Sets the state of the widget to Off.</short>
		/// 		<see> on</see>
		/// 		<see> toggle</see>
		/// 		<see> setState</see>
		[Q_SLOT("void off()")]
		public void Off() {
			interceptor.Invoke("off", "off()", typeof(void));
		}
		/// <remarks>
		///  Returns the width of the led.
		///      </remarks>		<short>    Returns the width of the led.</short>
		[SmokeMethod("ledWidth() const")]
		protected virtual int LedWidth() {
			return (int) interceptor.Invoke("ledWidth", "ledWidth() const", typeof(int));
		}
		/// <remarks>
		///  Paints a circular, flat LED.
		///      </remarks>		<short>    Paints a circular, flat LED.</short>
		[SmokeMethod("paintFlat()")]
		protected virtual void PaintFlat() {
			interceptor.Invoke("paintFlat", "paintFlat()", typeof(void));
		}
		/// <remarks>
		///  Paints a circular, raised LED.
		///      </remarks>		<short>    Paints a circular, raised LED.</short>
		[SmokeMethod("paintRaised()")]
		protected virtual void PaintRaised() {
			interceptor.Invoke("paintRaised", "paintRaised()", typeof(void));
		}
		/// <remarks>
		///  Paints a circular, sunken LED.
		///      </remarks>		<short>    Paints a circular, sunken LED.</short>
		[SmokeMethod("paintSunken()")]
		protected virtual void PaintSunken() {
			interceptor.Invoke("paintSunken", "paintSunken()", typeof(void));
		}
		/// <remarks>
		///  Paints a rectangular, flat LED.
		///      </remarks>		<short>    Paints a rectangular, flat LED.</short>
		[SmokeMethod("paintRect()")]
		protected virtual void PaintRect() {
			interceptor.Invoke("paintRect", "paintRect()", typeof(void));
		}
		/// <remarks>
		///  Paints a rectangular LED, either raised or
		///  sunken, depending on its argument.
		///      </remarks>		<short>    Paints a rectangular LED, either raised or  sunken, depending on its argument.</short>
		[SmokeMethod("paintRectFrame(bool)")]
		protected virtual void PaintRectFrame(bool raised) {
			interceptor.Invoke("paintRectFrame$", "paintRectFrame(bool)", typeof(void), typeof(bool), raised);
		}
		[SmokeMethod("paintEvent(QPaintEvent*)")]
		protected override void PaintEvent(QPaintEvent arg1) {
			interceptor.Invoke("paintEvent#", "paintEvent(QPaintEvent*)", typeof(void), typeof(QPaintEvent), arg1);
		}
		/// <remarks>
		///  Paint the cached antialiased pixmap corresponding to the state if any
		/// </remarks>		<return> true if the pixmap was painted, false if it hasn't been created yet
		///      </return>
		/// 		<short>    Paint the cached antialiased pixmap corresponding to the state if any </short>
		protected bool PaintCachedPixmap() {
			return (bool) interceptor.Invoke("paintCachedPixmap", "paintCachedPixmap()", typeof(bool));
		}
		~KLed() {
			interceptor.Invoke("~KLed", "~KLed()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KLed", "~KLed()", typeof(void));
		}
		protected new IKLedSignals Emit {
			get { return (IKLedSignals) Q_EMIT; }
		}
	}

	public interface IKLedSignals : IQWidgetSignals {
	}
}
