//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  Represent a mime type, like "text/plain", and the data that is associated
	///  with it.
	///  The starting point you need is often the static methods.
	///  KMimeType inherits KServiceType because "text/plain" can be used to find
	///  services (apps and components) "which can open text/plain".
	/// </remarks>		<short>    Represent a mime type, like "text/plain", and the data that is associated  with it.</short>
	/// 		<see> KServiceType</see>

	[SmokeClass("KMimeType")]
	public class KMimeType : KServiceType, IDisposable {
 		protected KMimeType(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KMimeType), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KMimeType() {
			staticInterceptor = new SmokeInvocation(typeof(KMimeType), null);
		}
		public enum FindByNameOption {
			DontResolveAlias = 0,
			ResolveAliases = 1,
		}
		// KMimeType::Ptr mimeType(const QString& arg1,KMimeType::FindByNameOption arg2); >>>> NOT CONVERTED
		// KMimeType::Ptr mimeType(const QString& arg1); >>>> NOT CONVERTED
		// KMimeType::Ptr findByUrl(const KUrl& arg1,mode_t arg2,bool arg3,bool arg4,int* arg5); >>>> NOT CONVERTED
		// KMimeType::Ptr findByUrl(const KUrl& arg1,mode_t arg2,bool arg3,bool arg4); >>>> NOT CONVERTED
		// KMimeType::Ptr findByUrl(const KUrl& arg1,mode_t arg2,bool arg3); >>>> NOT CONVERTED
		// KMimeType::Ptr findByUrl(const KUrl& arg1,mode_t arg2); >>>> NOT CONVERTED
		// KMimeType::Ptr findByUrl(const KUrl& arg1); >>>> NOT CONVERTED
		// KMimeType::Ptr findByPath(const QString& arg1,mode_t arg2,bool arg3,int* arg4); >>>> NOT CONVERTED
		// KMimeType::Ptr findByPath(const QString& arg1,mode_t arg2,bool arg3); >>>> NOT CONVERTED
		// KMimeType::Ptr findByPath(const QString& arg1,mode_t arg2); >>>> NOT CONVERTED
		// KMimeType::Ptr findByPath(const QString& arg1); >>>> NOT CONVERTED
		// KMimeType::Ptr findByContent(const QByteArray& arg1,int* arg2); >>>> NOT CONVERTED
		// KMimeType::Ptr findByContent(const QByteArray& arg1); >>>> NOT CONVERTED
		// KMimeType::Ptr findByNameAndContent(const QString& arg1,const QByteArray& arg2,mode_t arg3,int* arg4); >>>> NOT CONVERTED
		// KMimeType::Ptr findByNameAndContent(const QString& arg1,const QByteArray& arg2,mode_t arg3); >>>> NOT CONVERTED
		// KMimeType::Ptr findByNameAndContent(const QString& arg1,const QByteArray& arg2); >>>> NOT CONVERTED
		// KMimeType::Ptr findByFileContent(const QString& arg1,int* arg2); >>>> NOT CONVERTED
		// KMimeType::Ptr findByFileContent(const QString& arg1); >>>> NOT CONVERTED
		// KMimeType::List allMimeTypes(); >>>> NOT CONVERTED
		// KMimeType::Ptr defaultMimeTypePtr(); >>>> NOT CONVERTED
		// KMimeType* KMimeType(KMimeTypePrivate& arg1); >>>> NOT CONVERTED
		/// <remarks>
		///  Return the filename of the icon associated with the mimetype.
		///  Use KIconLoader.LoadMimeTypeIcon to load the icon.
		///  The url argument is unused, but is provided so that KMimeType-derived classes
		///  can use it (e.g. KFolderType uses the URL to return one out of 2 icons)
		/// </remarks>		<return> The path to the icon associated with this MIME type.
		///      </return>
		/// 		<short>    Return the filename of the icon associated with the mimetype.</short>
		public string IconName(KUrl url) {
			return (string) interceptor.Invoke("iconName#", "iconName(const KUrl&) const", typeof(string), typeof(KUrl), url);
		}
		public string IconName() {
			return (string) interceptor.Invoke("iconName", "iconName() const", typeof(string));
		}
		/// <remarks>
		///  Returns the descriptive comment associated with the MIME type.
		///  The url argument is unused, but provided so that KMimeType derived classes
		///  can use it.
		/// </remarks>		<return> The descriptive comment associated with the MIME type, if any.
		///      </return>
		/// 		<short>    Returns the descriptive comment associated with the MIME type.</short>
		public string Comment(KUrl url) {
			return (string) interceptor.Invoke("comment#", "comment(const KUrl&) const", typeof(string), typeof(KUrl), url);
		}
		public new string Comment() {
			return (string) interceptor.Invoke("comment", "comment() const", typeof(string));
		}
		/// <remarks>
		///  Retrieve the list of patterns associated with the MIME Type.
		/// </remarks>		<return> a list of file globs that describe the file names
		///          (or, usually, the extensions) of files with this mime type
		///      </return>
		/// 		<short>    Retrieve the list of patterns associated with the MIME Type.</short>
		public List<string> Patterns() {
			return (List<string>) interceptor.Invoke("patterns", "patterns() const", typeof(List<string>));
		}
		public bool IsDefault() {
			return (bool) interceptor.Invoke("isDefault", "isDefault() const", typeof(bool));
		}
		/// <remarks>
		///  If this mimetype inherits from ("is also") another mimetype,
		///  return the name of the parent.
		///  For instance a text/x-log is a special kind of text/plain,
		///  so the definition of text/x-log can say
		///       sub-class-of type="text/plain"
		///  Or an smb-workgroup is a special kind of inode/directory, etc.
		///  This mechanism can also be used to rename mimetypes and preserve compat.
		///  Note that this notion doesn't map to the servicetype inheritance mechanism,
		///  since an application that handles the specific type doesn't necessarily handle
		///  the base type. The opposite is true though.
		/// </remarks>		<return> the parent mime type, or string() if not set
		///      </return>
		/// 		<short>    If this mimetype inherits from ("is also") another mimetype,  return the name of the parent.</short>
		public string ParentMimeType() {
			return (string) interceptor.Invoke("parentMimeType", "parentMimeType() const", typeof(string));
		}
		/// <remarks>
		///  Do not use name()=="somename" anymore, to check for a given mimetype.
		///  For mimetype inheritance to work, use is("somename") instead.
		///  Warning, do not use inherits(), that's the servicetype inheritance concept!
		///  is() also supports mimetype aliases.
		///      </remarks>		<short>    Do not use name()=="somename" anymore, to check for a given mimetype.</short>
		public bool Is(string mimeTypeName) {
			return (bool) interceptor.Invoke("is$", "is(const QString&) const", typeof(bool), typeof(string), mimeTypeName);
		}
		/// <remarks>
		///  The stream must already be positionned at the correct offset
		///      </remarks>		<short>   </short>
		public KMimeType(QDataStream str, int offset) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KMimeType#$", "KMimeType(QDataStream&, int)", typeof(void), typeof(QDataStream), str, typeof(int), offset);
		}
		/// <remarks>
		///  Construct a mimetype and take all information from an XML file.
		/// <param> name="fullpath" the path to the xml that describes the mime type
		/// </param><param> name="name" the name of the mimetype (usually the end of the path)
		/// </param><param> name="comment" the comment associated with the mimetype
		///      </param></remarks>		<short>    Construct a mimetype and take all information from an XML file.</short>
		public KMimeType(string fullpath, string name, string comment) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KMimeType$$$", "KMimeType(const QString&, const QString&, const QString&)", typeof(void), typeof(string), fullpath, typeof(string), name, typeof(string), comment);
		}
		/// <remarks>
		///  The stream must already be positioned at the correct offset
		///      </remarks>		<short>   </short>
		protected void AddPattern(string pattern) {
			interceptor.Invoke("addPattern$", "addPattern(const QString&)", typeof(void), typeof(string), pattern);
		}
		protected void SetParentMimeType(string parent) {
			interceptor.Invoke("setParentMimeType$", "setParentMimeType(const QString&)", typeof(void), typeof(string), parent);
		}
		protected void InternalClearData() {
			interceptor.Invoke("internalClearData", "internalClearData()", typeof(void));
		}
		~KMimeType() {
			interceptor.Invoke("~KMimeType", "~KMimeType()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KMimeType", "~KMimeType()", typeof(void));
		}
		/// <remarks>
		///  Return the filename of the icon associated with the mimetype, for a given url.
		///  Use KIconLoader.LoadMimeTypeIcon to load the icon.
		/// <param> name="url" URL for the file
		/// </param><param> name="mode" the mode of the file. The mode may modify the icon
		///               with overlays that show special properties of the
		///               icon. Use 0 for default
		/// </param></remarks>		<return> the name of the icon. The name of a default icon if there is no icon
		///          for the mime type
		///      </return>
		/// 		<short>    Return the filename of the icon associated with the mimetype, for a given url.</short>
		public static string IconNameForUrl(KUrl url, long mode) {
			return (string) staticInterceptor.Invoke("iconNameForUrl#$", "iconNameForUrl(const KUrl&, mode_t)", typeof(string), typeof(KUrl), url, typeof(long), mode);
		}
		public static string IconNameForUrl(KUrl url) {
			return (string) staticInterceptor.Invoke("iconNameForUrl#", "iconNameForUrl(const KUrl&)", typeof(string), typeof(KUrl), url);
		}
		/// <remarks>
		///  Return the "favicon" (see http://www.favicon.com) for the given <code>url</code>,
		///  if available. Does NOT attempt to download the favicon, it only returns
		///  one that is already available.
		///  If unavailable, returns string().
		/// <param> name="url" the URL of the favicon
		/// </param></remarks>		<return> the name of the favicon, or string()
		///      </return>
		/// 		<short>    Return the "favicon" (see http://www.</short>
		public static string FavIconForUrl(KUrl url) {
			return (string) staticInterceptor.Invoke("favIconForUrl#", "favIconForUrl(const KUrl&)", typeof(string), typeof(KUrl), url);
		}
		/// <remarks>
		///  Retrieve a pointer to the mime type <code>name</code> .
		///  <b>Very</b> <b>important</b>: Don't store the result in a KMimeType !
		///  Also note that you get a new KMimeType pointer every time you call this.
		///  Don't ever write code that compares mimetype pointers, compare names instead.
		/// <param> name="name" the name of the mime type
		/// </param></remarks>		<return> the pointer to the KMimeType with the given <code>name</code>, or
		///          0 if not found
		/// </return>
		/// 		<short>    Retrieve a pointer to the mime type <code>name</code> .</short>
		/// 		<see> KServiceType.ServiceType</see>
		/// <remarks>
		///  Finds a KMimeType with the given <code>url.</code>
		///  This function looks at mode_t first.
		///  If that does not help it
		///  looks at the extension.  This is fine for FTP, FILE, TAR and
		///  friends, but is not for HTTP ( cgi scripts! ). You should use
		///  KRun instead, but this function returns immediately while
		///  KRun is async. If no extension matches, then
		///  the file contents will be examined if the URL is a local file, or
		///  "application/octet-stream" is returned otherwise.
		/// <param> name="url" Is the right most URL with a filesystem protocol. It
		///         is up to you to find out about that if you have a nested
		///         URL.  For example
		///         "http://localhost/mist.gz#gzip:/decompress" would have to
		///         pass the "http://..." URL part, while
		///         "file:/tmp/x.tar#tar:/src/test.gz#gzip:/decompress" would
		///         have to pass the "tar:/..." part of the URL, since gzip is
		///         a filter protocol and not a filesystem protocol.
		/// </param><param> name="mode" the mode of the file (used, for example, to identify
		///               executables)
		/// </param><param> name="is_local_file" true if the file is local; false if not, or if you don't know.
		/// </param><param> name="fast_mode" If set to true no disk access is allowed to
		///         find out the mimetype. The result may be suboptimal, but
		///         it is <b>fast</b>.
		/// </param><param> name="accuracy" if set, the accuracy of the result, between 0 and 100.
		///         For instance, when the extension was used to determine the mimetype,
		///         the accuracy is set to 80, as per the shared-mime spec.
		///         Some 'magic' rules (used when !fast_mode) have an accuracy > 80
		///         (and have priority over the filename, others are < 80).
		/// </param></remarks>		<return> A pointer to the matching mimetype. 0 is never returned.
		///  @em Very @em Important: Don't store the result in a KMimeType* !
		///      </return>
		/// 		<short>    Finds a KMimeType with the given <code>url.</code></short>
		/// <remarks>
		///  Finds a KMimeType with the given <code>url.</code>
		///  This function looks at mode_t first.
		///  If that does not help it
		///  looks at the extension.  This is fine for FTP, FILE, TAR and
		///  friends, but is not for HTTP ( cgi scripts! ). You should use
		///  KRun instead, but this function returns immediately while
		///  KRun is async. If no extension matches, then
		///  the file contents will be examined if the URL is a local file, or
		///  "application/octet-stream" is returned otherwise.
		///  Equivalent to
		///  <pre>
		///  KUrl u;
		///  u.setPath(path);
		///  return findByUrl( u, mode, true, fast_mode );
		///  </pre>
		/// <param> name="path" the path to the file
		/// </param><param> name="mode" the mode of the file (used, for example, to identify
		///               executables)
		/// </param><param> name="fast_mode" If set to true no disk access is allowed to
		///         find out the mimetype. The result may be suboptimal, but
		///         it is <b>fast</b>.
		/// </param><param> name="accuracy" If not a null pointer, accuracy is set to the
		///           accuracy of the match (which is in the range 0..100)
		/// </param></remarks>		<return> A pointer to the matching mimetype. 0 is never returned.
		///      </return>
		/// 		<short>    Finds a KMimeType with the given <code>url.</code></short>
		/// <remarks>
		///  Tries to find out the MIME type of a data chunk by looking for
		///  certain magic numbers and characteristic strings in it.
		/// <param> name="data" the data to examine
		/// </param><param> name="accuracy" If not a null pointer, accuracy is set to the
		///           accuracy of the match (which is in the range 0..100)
		/// </param></remarks>		<return> a pointer to the KMimeType. @c 0 if the
		///          type can not be found this way.
		///      </return>
		/// 		<short>    Tries to find out the MIME type of a data chunk by looking for  certain magic numbers and characteristic strings in it.</short>
		/// <remarks>
		///  Tries to find out the MIME type of filename/url and a data chunk.
		///  Whether to trust the extension or the data depends on the results of both approaches,
		///  and is determined automatically.
		///  This method is useful for instance in the get() method of kioslaves, and anywhere else
		///  where a filename is associated with some data which is available immediately.
		/// <param> name="name" the filename or url representing this data.
		///  Only used for the extension, not used as a local filename.
		/// </param><param> name="data" the data to examine when the extension isn't conclusive in itself
		/// </param><param> name="mode" the mode of the file (used, for example, to identify executables)
		/// </param><param> name="accuracy" If not a null pointer, accuracy is set to the
		///           accuracy of the match (which is in the range 0..100)
		///      </param></remarks>		<short>    Tries to find out the MIME type of filename/url and a data chunk.</short>
		/// <remarks>
		///  Tries to find out the MIME type of a file by looking for
		///  certain magic numbers and characteristic strings in it.
		///  This function is similar to the previous one. Note that the
		///  file name is not used for determining the file type, it is just
		///  used for loading the file's contents.
		/// <param> name="fileName" the path to the file
		/// </param><param> name="accuracy" If not a null pointer, accuracy is set to the
		///           accuracy of the match (which is in the range 0..100)
		/// </param></remarks>		<return> a pointer to the KMimeType, or the default mimetype
		///          (application/octet-stream) if the file cannot be opened.
		///      </return>
		/// 		<short>    Tries to find out the MIME type of a file by looking for  certain magic numbers and characteristic strings in it.</short>
		/// <remarks>
		///  Returns whether a file has an internal format that is not human readable.
		///  This is much more generic than "not mime.Is(text/plain)".
		///  Many application file formats (like rtf and postscript) are based on text,
		///  but text that the user should rarely ever see.
		///      </remarks>		<short>    Returns whether a file has an internal format that is not human readable.</short>
		public static bool IsBinaryData(string fileName) {
			return (bool) staticInterceptor.Invoke("isBinaryData$", "isBinaryData(const QString&)", typeof(bool), typeof(string), fileName);
		}
		/// <remarks>
		///  Returns whether a buffer has an internal format that is not human readable.
		///  This is much more generic than "not mime.Is(text/plain)".
		///  Many application file formats (like rtf and postscript) are based on text,
		///  but text that the user should rarely ever see.
		///      </remarks>		<short>    Returns whether a buffer has an internal format that is not human readable.</short>
		public static bool IsBufferBinaryData(QByteArray data) {
			return (bool) staticInterceptor.Invoke("isBufferBinaryData#", "isBufferBinaryData(const QByteArray&)", typeof(bool), typeof(QByteArray), data);
		}
		/// <remarks>
		///  Get all the mimetypes.
		///  Useful for showing the list of
		///  available mimetypes.
		///  More memory consuming than the ones above, don't use unless
		///  really necessary.
		/// </remarks>		<return> the list of all existing KMimeTypes
		///      </return>
		/// 		<short>    Get all the mimetypes.</short>
		/// <remarks>
		///  Returns the name of the default mimetype.
		///  Always application/octet-stream, but this method exists
		///  for performance purposes.
		/// </remarks>		<return> the name of the default mime type, always
		///          "application/octet-stream"
		///      </return>
		/// 		<short>    Returns the name of the default mimetype.</short>
		public static string DefaultMimeType() {
			return (string) staticInterceptor.Invoke("defaultMimeType", "defaultMimeType()", typeof(string));
		}
		/// <remarks>
		///  Returns the default mimetype.
		///  Always application/octet-stream.
		///  This can be used to check the result of mimeType(name).
		/// </remarks>		<return> the "application/octet-stream" mimetype pointer.
		///      </return>
		/// 		<short>    Returns the default mimetype.</short>
		/// <remarks>
		///  Determines the extension from a filename (or full path) using the mimetype database.
		///  This allows to extract "tar.bz2" for foo.tar.bz2
		///  but still return "txt" for my.doc.with.dots.txt
		///      </remarks>		<short>    Determines the extension from a filename (or full path) using the mimetype database.</short>
		public static string ExtractKnownExtension(string fileName) {
			return (string) staticInterceptor.Invoke("extractKnownExtension$", "extractKnownExtension(const QString&)", typeof(string), typeof(string), fileName);
		}
	}
}
