//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  A database for tips-of-the-day.
	///  This class provides convenient access to a database containing
	///  tips of the day. The database is stored in a XML file and parsed
	///  when a KTipDatabase object is created.
	///  Once the file is read in, you can access the tips to display
	///  them in the tip of the day dialog.
	///  The state of the tipdialog is saved to the applications's config file
	///  in the group "TipOfDay" with a bool entry "RunOnStart". Check this value
	///  if you want to allow the user to enable/disable the tipdialog in the
	///  application's configuration dialog.
	///  </remarks>		<author> Matthias Hoelzer-Kluepfel <mhk@kde.org>
	/// </author>
	/// 		<short>    A database for tips-of-the-day.</short>

	[SmokeClass("KTipDatabase")]
	public class KTipDatabase : Object, IDisposable {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KTipDatabase(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KTipDatabase), this);
		}
		/// <remarks>
		///  This constructor reads in the tips from a file with the given name. If
		///  no name is given, a file called 'application-name/tips' will be loaded.
		/// <param> name="tipFile" The absolute path to the tips file.
		///      </param></remarks>		<short>    This constructor reads in the tips from a file with the given name.</short>
		public KTipDatabase(string tipFile) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTipDatabase$", "KTipDatabase(const QString&)", typeof(void), typeof(string), tipFile);
		}
		public KTipDatabase() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTipDatabase", "KTipDatabase()", typeof(void));
		}
		/// <remarks>
		///  This constructor takes a list of files that will be merged. This constructor
		///  essentially behaves like the one above. It returns when tipFiles is empty.
		/// <param> name="tipFiles" A list of absolute paths to the tips file
		///      </param></remarks>		<short>    This constructor takes a list of files that will be merged.</short>
		public KTipDatabase(List<string> tipFiles) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTipDatabase?", "KTipDatabase(const QStringList&)", typeof(void), typeof(List<string>), tipFiles);
		}
		/// <remarks>
		///  Returns the current tip.
		///      </remarks>		<short>    Returns the current tip.</short>
		public string Tip() {
			return (string) interceptor.Invoke("tip", "tip() const", typeof(string));
		}
		/// <remarks>
		///  The next tip will become the current one.
		///      </remarks>		<short>    The next tip will become the current one.</short>
		public void NextTip() {
			interceptor.Invoke("nextTip", "nextTip()", typeof(void));
		}
		/// <remarks>
		///  The previous tip will become the current one.
		///      </remarks>		<short>    The previous tip will become the current one.</short>
		public void PrevTip() {
			interceptor.Invoke("prevTip", "prevTip()", typeof(void));
		}
		~KTipDatabase() {
			interceptor.Invoke("~KTipDatabase", "~KTipDatabase()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KTipDatabase", "~KTipDatabase()", typeof(void));
		}
	}
}
