// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore, <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */



#ifndef __KDETVELEGANT_PLUGIN_H
#define __KDETVELEGANT_PLUGIN_H

#include <kdetvosdplugin.h>
#include "elegantconfigwidget.h"

class KPopupTitle;
class QTimer;

#define INCLUDE_TESTS

/**
 * Elegant OSD Plugin.
 *
 * @author Richard Moore, rich@kde.org
 */
class KdetvElegant : public KdetvOSDPlugin
{
    Q_OBJECT

public:
    KdetvElegant( Kdetv *ktv, QWidget *parent=0, const char *name=0 );
    virtual ~KdetvElegant();

public slots:
    void readConfig();
    void saveConfig();
    void applySettings();

    void display( const QString &text, const QPixmap &icon );
    void display( const QString &text, const QString &icon=QString::null );

    virtual void clear();
    virtual void displayMisc(const QString& text);
    virtual void displayChannel(int channel, const QString& name);
    virtual void displayMuted(bool muted);
    virtual void displayVolume(int vol);
    virtual void displayCC(const QString& text);

    virtual void viewResized(int w, int h);

    virtual ElegantConfigWidget *configWidget( QWidget *parent, const char *name );
    void applyConfigWidget();

    void showPopup();
    void updateGeometry();

    void colourKeyChanged(QColor key);

#ifdef INCLUDE_TESTS
    void test_channel();
    void test_mute();
    void test_volume();
    void test_config();
#endif // INCLUDE_TESTS

private:
    QWidget *parent;
    KPopupTitle *popup;
    QTimer *timer;
    ElegantConfigWidget *form;
    int timeout;
    int align;
    int indent;
    int iconSize;
    int fontSize;
    bool fontBold;
    bool fontItalic;
    bool fontUnderline;
    bool autoFontSize;
};

#endif


