/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef PASSWORDITEM_H
#define PASSWORDITEM_H

#include "wallet.h"

#include <kcoreconfigskeleton.h>

class PasswordItem : public KCoreConfigSkeleton::ItemString
{
public:
    PasswordItem(const QString &group, const QString &key, QString &ref);
    ~PasswordItem();

    void readConfig(KConfig*);
    void writeConfig(KConfig*);

    void readDefault(KConfig*);
    void setDefault();
    void swapDefault();

private:
    Wallet *m_wallet;
    QString &m_reference;
    QString m_default;
};

#endif // PASSWORDITEM_H
