/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KINSTALLER_H_
#define _KINSTALLER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>

#include "kinstallerprocess.h"
#include "kinstallerview.h"
#include "kpkginfodialog.h"
#include "pref.h"
#include "ksetupwizard.h"

#include "tinstallersettings.h"
#include "tinstalldata.h"
#include "tpackageinfo.h"


class KPrinter;
class KToggleAction;
class KURL;

/**
 * This class serves as the main window for KInstaller.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 */
class KInstaller : public KMainWindow
{
  Q_OBJECT
      
  public:
    /**
     * Default Constructor
     */
    KInstaller();

    /**
     * Default Destructor
     */
    virtual ~KInstaller();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);

  protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

  protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);

    void readGlobalConfig();
    void writeGlobalConfig();
    
    bool queryExit();
    
  private slots:
    void fileNew();
    void fileOpen();
    void filePrint();
    
    void optionsShowToolbar();
    void optionsShowStatusbar();
//    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void slotSettingsWizard();
    void newToolbarConfig();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);

    void slotSelectSourceClicked();
    void slotGuessKDEBaseClicked(QString & dir);
    void slotSelectStorageDirClicked(QString & dir);
    void slotInstallClicked();
    
    void slotDeleteClicked();
    void slotUninstallClicked();
    void slotUninstall(bool deleteOnly);

    void slotGuessProcessStdout(const QString & str);
    void slotInstallProcessStdout(const QString & str);
    void slotInstallProcessStderr(const QString & str);
    void slotUninstallProcessStdout(const QString & str);
    void slotUninstallProcessStderr(const QString & str);
    
  private:
    void setupAccel();
    void setupActions();

    void showError(const QString & error, const QString & title = 0);
    void showInfo(const QString & msg, const QString & title = 0);

    QString guessKDEBase();
    bool testKDEBaseDir(const QString & path);
    
    void collectPackages();

    QString selectDirectory(const QString & startDir, const QString & caption);

    bool install(TInstallData * tid);
    bool installCheckEnvironment(TInstallData * tid);
    bool installPrepare(TInstallData * tid);
    bool installPrepareSplitName(const QString & name,
                                 QString * base, QString * ver, QString *rel);
    bool installUntar(TInstallData * tid);
    bool installConfigure(TInstallData * tid);
    bool installMake(TInstallData * tid);
    bool installInstall(TInstallData * tid);
    bool installCleanup(TInstallData * tid, bool success);
    bool installPost(TInstallData * tid);

    bool uninstall(TPackageInfo * info, bool deleteOnly);
    bool uninstallCheckEnvironment(TPackageInfo * info);
    bool uninstallUninstall(TPackageInfo * info);
    bool uninstallCleanup(TPackageInfo * info, bool success);
    bool uninstallPost(TPackageInfo * info);
    
  private:
    KInstallerView *m_view;

    KSetupWizard * m_setupWizard;
    KInstallerPreferences * m_prefDialog;
    KPkgInfoDialog * m_pkgInfoDialog;
  
    KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KAction * m_wizardAction;
    
    TInstallerSettings  * m_settings;
    TPackageInfoList * m_pkgInfos;

    bool m_firstRun;
    bool vRunning;
    bool vCanceled;
    KInstallerProcess * m_guessProc;
    QString m_guessStr;
    KInstallerProcess * m_instProc;
    KInstallerProcess * m_uninstProc;
};

#endif // _KINSTALLER_H_
