/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qradiobutton.h>

#include "ksettingsinstallwidget.h"



KSettingsInstallWidget::KSettingsInstallWidget(QWidget *parent, const char *name)
 : KSettingsInstallWdgt(parent, name)
{
  connect(makeRadioButton,SIGNAL(toggled(bool)),
          this,SLOT(slotInstallTypeToggled(bool)));
  connect(checkinstallRadioButton,SIGNAL(toggled(bool)),
          this,SLOT(slotInstallTypeToggled(bool)));
          
  connect(optionsCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotUseOptionsToggled(bool)));

  keepInstallfilesCheckBox->hide();
}


KSettingsInstallWidget::~KSettingsInstallWidget()
{
}


/*!
 */
void KSettingsInstallWidget::setSettings(TInstallerSettings * settings)
{
  if (settings->installType() == TInstallerSettings::Make)
    makeRadioButton->setChecked(true);
  else
    checkinstallRadioButton->setChecked(true);

  keepInstallfilesCheckBox->setChecked(settings->keepInstallfiles());

  if (settings->packageType() == TInstallerSettings::RPM)
    rpmRadioButton->setChecked(true);
  else if (settings->packageType() == TInstallerSettings::Debian)
    debianRadioButton->setChecked(true);
  else
    slackwareRadioButton->setChecked(true);
  
  optionsCheckBox->setChecked(settings->useConfigureOptions());
  optionsEdit->setText(settings->configureOptions());
}


/*!
 */
void KSettingsInstallWidget::getSettings(TInstallerSettings * settings)
{
  if (makeRadioButton->isChecked())
    settings->setInstallType(TInstallerSettings::Make);
  else
    settings->setInstallType(TInstallerSettings::Checkinstall);

  settings->setKeepInstallfiles(keepInstallfilesCheckBox->isChecked());

  if (rpmRadioButton->isChecked())
    settings->setPackageType(TInstallerSettings::RPM);
  else if (debianRadioButton->isChecked())
    settings->setPackageType(TInstallerSettings::Debian);
  else
    settings->setPackageType(TInstallerSettings::Slackware);

  settings->setUseConfigureOptions(optionsCheckBox->isChecked());
  settings->setConfigureOptions(optionsEdit->text());
}


/*!
 */
void KSettingsInstallWidget::slotInstallTypeToggled(bool checked)
{
  bool tmp;
  
  
  if (checked)
  {
    if (makeRadioButton->isChecked())
    {
      tmp = true;
    }
    else
    {
      tmp = false;
    }

    // all about 'make install'
    keepInstallfilesCheckBox->setEnabled(tmp);
    // all about 'checkinstall'
    packageTypeButtonGroup->setEnabled(!tmp);
  }
}


/*!
 */
void KSettingsInstallWidget::slotUseOptionsToggled(bool checked)
{
  optionsEdit->setEnabled(checked);
}


#include "ksettingsinstallwidget.moc"
