//Functions to manage visual diroperations.
//Last updated 15.12.03

#ifndef DIROPS_H
#define DIROPS_H

#include <inttypes.h>

#include <qdir.h>
#include <qpixmap.h>
#include <kdialog.h>


class QListView;
class QListViewItem;
class KProgress;

QStringList getDeviceList();

void GetDirView (QListView* Object, QDir directory = QDir::current(),
const char* filter = 0, bool visible = 0 );

QPixmap FileIcon (QFileInfo* File);

void changedirectory(QListView* Object, QString directory = 0, QString path = 0);

void Linkfiles(QDir Directory, QDir Dest, bool Createself = true );

void Convert(QString Selected, KProgress* kProgress1);

QString readoutheader(QString Selected, QString Type);

void openhex(QString File);

void MountISO(QString Selected, uint8_t imagenumber);

void CreateISO(QString Selected);

bool FindEncryption (QString Selected);

QString PrepforShell (QString Selected);

class Progressform : public KDialog
{
    Q_OBJECT

public:
      Progressform( QWidget* parent = 0, const char* name = 0);
      ~Progressform();

      KProgress* ShellProgress;
};

#endif  
