/****************************************************************************
** kiso.h
**
** Created: Mit Nov 26 21:30:18 2003
**      by: Stephan Gans
**
** 
****************************************************************************/

#ifndef MAINFORM_H
#define MAINFORM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kprocess.h>
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <kaction.h>
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <kfiletreeview.h>
#include <kfiletreebranch.h>

#include <qlistview.h>
#include <qdir.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qdragobject.h>


class KProgress;
class KPopupMenu;
class KPushButton;
class KRun;

class QAction;
class QToolBar;
class QLabel;
class QListViewItem;
class QLCDNumber;

class DNDListView;
class DNDListView2;
class KIsoTreeview;

QString addfile();

class Mainform : public KMainWindow
{
    Q_OBJECT

public:
    Mainform( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel, QString File = 0 );
    ~Mainform();
    void initialisation();

    QMovie* Film1;
    QMovie* Film2;
    KToolBar* tools;
    QFrame* frame1;
    QLabel* MLabel1;
    QLabel* MLabel2;
    QLabel* textLabel1;
    QFrame* frame2;
    QLCDNumber* lCDNumber1;

    DNDListView* listView1;
    KIsoTreeview* listView2;
    KFileTreeBranch* root;
    KFileTreeBranch* home;

    KProgress* kProgress1;
    KMenuBar* MenuBarEditor;
    KPopupMenu* CD_ImageMenu;
    KPopupMenu* ExtrasMenu;
    KRecentFilesAction* recent;
    KAction* menuNeues_ImageAction;
    KAction* menuImage_ladenAction;
    KAction* menuImage_EntpackenAction;
    KAction* menuDatei_hinzufgenAction;
    KAction* menuImage_speichernAction;
    KAction* menuKonvertiere_ImageAction;
    KAction* menu_EncryptAction;
    KAction* menuKISO_verlassenAction;
    KAction* extras_burnAction;
    KAction* extras_hexAction;
    KAction* extras_EinstellungenAction;
    KAction* extras_BootimageAction;
    KAction* extras_LabelimageAction;
    KAction* extras_PublisherAction;
    KAction* extras_Information;
    KAction* extras_cdscan;
    KRun* execute;

public slots:
    virtual void showabout();
    virtual void buttonsound(int id = 0, bool=false);
    virtual void showinformation();
    virtual void showdrive();
    virtual void preferences();
    virtual void startburner();
    virtual void showopen(QString Selected = 0);
    virtual void choice();
    virtual void showextract();
    virtual void openrecent(const KURL& Sel);
    virtual void showadd();
    virtual void showconvert();
    virtual void showsave();
    virtual void bootimage();
    virtual void openashex();
    virtual void newlabel();
    virtual void newpublisher();
    virtual void nextdir(QListViewItem* selection);
    virtual void createiso (QString Selected = 0);
    virtual void extractiso (QString Selected = 0);
    virtual void owniso (QString Selected = 0);
    virtual void encryption();
    virtual int createfromdvd( QString Selected );
    virtual int ProgressBar (QString source = 0, QString target = 0, KShellProcess* CallingP = 0, double already = 0);
    virtual int decryption(QString Selected, QCString encryptionid);
    virtual bool Proofforapp();

protected:
    void closeEvent( QCloseEvent* e);
    QString cdlabel;
    QString publisher;
    QString applicationid;
    QString systemid;
    QString preparer;
    QString format;
    
protected slots:

private:
    QPixmap image2;
    QPixmap image3;
    QPixmap image4;
    QPixmap image5;
    QPixmap image6;
    QPixmap image7;
    QPixmap image8;
    QPixmap image9;
    QPixmap image10;
    QPixmap image11;
    QPixmap image12;
    QPixmap image14;
    QPixmap image15;
    QPixmap image16;
    QPixmap image17;
    QPixmap image18;
};

class QDragObject;

class DNDListView: public QListView
{
    Q_OBJECT
public:
    DNDListView( QWidget* parent = 0, const char* name = 0 );
    ~DNDListView();

  public slots:
     virtual int DirSize (QString directory, QString options = "-sb");
     virtual double Adddialog();
     virtual void result(KProcess* prozess = 0, char* outp = 0, int id = 0);
};

class DNDListView;

class DNDListView2: public DNDListView
{
       Q_OBJECT
public:
    DNDListView2( QWidget* parent = 0, const char* name = 0, QLCDNumber* Object=0 );
    ~DNDListView2();

    QLCDNumber* LCD;

private:
    KAction* CDelItem;
    KAction* CEraseBoot;
    KAction* CAddItem;
    KAction* CAddDir;
    KAction* CNewDir;
    KAction* CRenItem;

protected:    
     void contentsDropEvent( QDropEvent * );
     void contextMenuEvent ( QContextMenuEvent * );
     void keyPressEvent (QKeyEvent *e );

private slots:
     virtual void actuallcd(double nvalue = 0);
     virtual void erase ();
     virtual void eraseboot();
     virtual void add ();
     virtual void addfolder();
     virtual void newsub();
     virtual void renameItem();
     virtual void Mergeimage(QString Name);

};

class KIsoTreeview: public KFileTreeView
{
       Q_OBJECT
public:
      KIsoTreeview(QWidget* parent = 0, const char* name = 0);
      ~KIsoTreeview();

private:
      KAction* Properties;
      KAction* Newsub;
      KAction* RenameItem;
      KAction* EraseItem;
      KAction* NewMainfolder;
      KAction* EraseMainfolder;
      KPopupMenu* Contextmenu;
      QListViewItem *dropItem;
      QPoint presspos;
      bool mousePressed;

protected:
    void contentsMousePressEvent( QMouseEvent * );
    void contentsMouseReleaseEvent( QMouseEvent *e );
    void contentsMouseMoveEvent( QMouseEvent *e );
    void contextMenuEvent ( QContextMenuEvent * );

private slots:
    virtual void Update();
    virtual void showPropertiesDialog();
    virtual void Rename();
    virtual void Erase();
    virtual void NewFolder();
    virtual void EraseFolder();
};

class Filelist
{
public:

Filelist( const QString& filepath, double filesize, QDateTime filedate ) : fp( filepath ), fs( filesize ), fd( filedate ) { }

QString    filepath()   const   { return fp; }
double     filesize()   const   { return fs; }
QDateTime  filedate()   const   { return fd; }
    
private:
QString fp;
double fs;
QDateTime fd;
};
       
#endif // MAINFORM_H
