/***************************************************************************
                          iconload  -  description
                             -------------------
    begin                : ��� ��� 14 2009
    copyright            : (C) 2009 by Spiros Georgaras
    email                : sng@hellug.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qstring.h> 

#include <kmessagebox.h>

#include "iconload.h"
//================================
iconload::iconload(){
	items=0;
	pix=0;
}
//================================
iconload::~iconload(){
	delete[] pix;
}
//================================
int iconload::loadIcon(QStringList picNames,int id){
QString pic;
if (id>items-1) if(resize(id+1)==-1) return -1;
for ( QStringList::Iterator it = picNames.begin(); it != picNames.end(); ++it ) {
	QString name=*it;
	//qWarning("name = %s",name.latin1());
//	if(name.find("/")==-1) pic=locateLocal("icon",name);
//	else{
		if(theme.isEmpty()) readThemeName();
		//qWarning("  theme = %s",theme.latin1());
		pic=locateLocal("icon",theme+"/"+name);
		//qWarning("  pic = %s",pic.latin1());
		pix[id]=QPixmap(pic);
		if(pix[id].isNull()){
			pic=locate("icon",theme+"/"+name);
			//qWarning("  pic = %s",pic.latin1());
			pix[id]=QPixmap(pic);
		}
		if(pix[id].isNull()){
			KStandardDirs a;
			QStringList folderList=a.findDirs("icon", "");
			for ( QStringList::Iterator it = folderList.begin(); it != folderList.end() ; ++it ) {
        			QString folder=*it;
				readFolder(folder,name,id);
				if(!pix[id].isNull()) return 1;
			}
		}
//	}
	pix[id]=QPixmap(pic);
	if(!pix[id].isNull()) return 1;
}
return 0;
}
//================================
void iconload::readFolder(QString folder, QString name, int id){
	QDir d;
	d.cd(folder);
	d.setFilter( QDir::Dirs | QDir::NoSymLinks );
	d.setSorting( QDir::Name );
	d.setNameFilter("*");
	const QFileInfoList *list = d.entryInfoList();
	QFileInfoListIterator it( *list );
	QFileInfo *fi;
	while ( (fi = it.current()) != 0 ) {
		if(fi->fileName()!="." && fi->fileName()!=".."){
			QString file=folder; file.append(fi->fileName());
			file.append("/"); file.append(name);
			//qWarning("  file = %s",file.latin1());
			QFile iconFile(file);
			if(iconFile.exists()){
				pix[id]=QPixmap(file);
				return;
			}
		}
		++it;
	}
}
//================================
QPixmap iconload::Icon(int index){
	return pix[index];
}
//================================
//	Returns -1 if memory alocation failed
//================================
int iconload::resize(int newItemNum){
	QPixmap* p;
	p=new QPixmap[newItemNum+1];
	if(p==NULL) return -1;
	for(int i=0;i<items;i++) p[i]=pix[i];
	delete [] pix;
	pix=p;
	items=newItemNum+1;
	return items;
}
//================================
QString iconload::defIconTheme(){
	if(theme.isEmpty()) readThemeName();
	return theme;
}
//================================
void iconload::readThemeName(){
	KConfig config("kdeglobals");
	config.setGroup("Icons");
	theme=config.readEntry("Theme",QString::null);
}
