//
// C++ Interface: kmailconfig
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMAILCONFIG_H
#define KMAILCONFIG_H

/**
This class reads several kmail parameters to be used form kmhtConvert/kio_mhtml
Also reads some system parameters (fonts etc.)

@author Spiros Georgaras
*/
class kmailConfig{
public:
    kmailConfig();

    ~kmailConfig();


		// eml header parameters
    QString subjectBgColor();
    QString ItemsBgColor();
    QString tableForeColor();


		// interface
		void reset(){fontsAndColorsRead=false;headerFrameRead=false;};

		bool usesSystemFonts(){return defaultFonts;};
		bool usesFixedFonts(){return useFixedFont;};

		QString fontName(int level);
		QString fontSize(int level);
		QString fontColor(int level);
		bool isFontBold(int level);
		bool isFontItalics(int level);
		
		QString quotedFontName(int level);
		QString quotedFontSize(int level);
		QString quotedFontColor(int level);
		bool isQuotedFontBold(int level);
		bool isBQuotedFontItalics(int level);
		
		QString bodyFontName();
		QString bodyFontSize();
		QString bodyFontColor();
		bool isBbodyFontBold();
		bool isBbodyFontItalics();
		
		QString standardFontName();
		QString standardFontSize();
		QString standardFontColor();
		bool isStandardFontBold();
		bool isStandardFontItalics();
		
		QString standardBodyFontName();
		QString standardBodyFontSize();
		QString standardBodyFontColor();
		bool isStandardBodyFontBold();
		bool isStandardBodyFontItalics();

private:
	bool fontsAndColorsRead;
	bool headerFrameRead;

	void readAllParameters();
	void readFontsAndColors();
	void readHeaderFrameParameters();
	void breakFontList(QStringList font, int id, bool setAll=false);
/*
	0:	quoted text level 1
	1:	quoted text level 2
	2:	quoted text level 3
	3:	body font
	4:	heder-attachment font (system standard font)
	5:	body font (standard kmail font)
*/
	QCString cols[6];
	QString fonts[6];
	QString m_bold[6];
	QString m_italics[6];
	bool bold[6];
	bool italics[6];
	QString size[6];

	bool useFixedFont;
	bool defaultFonts;
	QStringList systemFont;
	QStringList bodyFont;

	// eml header parameters	
	QString headerForegroundColor;
	QString headerTableBackgroundColor;
	QString innerTableBackgroundColor;
};

#endif
