/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         * 
 *   Based heavily on KPPP                                                 * 
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #ifndef _CONNECT_H_
#define _CONNECT_H_

#include <qtimer.h>
#include <kpushbutton.h>
#include <qlabel.h>
#include <qevent.h>

#include "knetconfig.h"
// #include "pwentry.h"
//#include "docking.h"
// #include "loginterm.h"

#define MAXLOOPNEST (MAX_SCRIPT_ENTRIES/2)

class PPPStats;
 class Knet;
 
class ConnectWidget : public QWidget {
  Q_OBJECT
public:
  ConnectWidget(QWidget *parent, const char *name, PPPStats *st);
  ~ConnectWidget();

public:
  void set_con_speed_string();
  void setMsg(const QString &);
  void pppdDied();

  // these are only necessary to prevent the user from clicking in the cancel 
  // button during the disconnect delay in KPPPWidget
  void disableButtons();
  void enableButtons();

protected:
  void timerEvent(QTimerEvent *);
  void closeEvent( QCloseEvent *e );
//void adddns()
//{
//  int fd;

//  if ((fd = Requester::rq->openResolv(O_WRONLY|O_APPEND)) >= 0) {
//    QStringList &dnslist = gpppdata.dns();
//    for ( QStringList::Iterator it = dnslist.begin();
//          it != dnslist.end();
//          ++it )
//    {
//      QCString dns = "nameserver " + (*it).local8Bit() +
//		     " \t#kppp temp entry\n";
//      write(fd, dns.data(), dns.length());
//    }
//    close(fd);
//  }
//  add_domain(gpppdata.domain());
//}

//void addpeerdns() {
//  int fd, fd2;

//  if((fd = Requester::rq->openResolv(O_WRONLY|O_APPEND)) >= 0) {
//    if((fd2 = open("/etc/ppp/resolv.conf", O_RDONLY)) >= 0) {
//      char c;
//      int i = 0;
//      while(i++ < 100 && read(fd2, &c, 1) == 1) {
//        if(c == '\n')
//          write(fd, "\t#kppp temp entry\n", 18);
//        else
//          write(fd, &c, 1);
//      close(fd2);
//    } else
//      fprintf(stderr, "failed to read from /etc/ppp/resolv.conf\n");
//    close(fd);
//  }
//  add_domain(gpppdata.domain());
//}

// remove the dns entries from the /etc/resolv.conf file
//void removedns() {

//  int fd;
//  char c;
//  QString resolv[MAX_RESOLVCONF_LINES];

// if((fd = Requester::rq->openResolv(O_RDONLY)) >= 0) {

//    int i=0;
//    while(read(fd, &c, 1) == 1 && i < MAX_RESOLVCONF_LINES) {
//      if(c == '\n') {
//	i++;
//      }
//      else {
//	resolv[i] += c;
//      }
//    }
//    close(fd);

//    if((fd = Requester::rq->openResolv(O_WRONLY|O_TRUNC)) >= 0) {
//      for(int j=0; j < i; j++) {
//	if(resolv[j].contains("#kppp temp entry")) continue;
//	if(resolv[j].contains("#entry disabled by kppp")) {
 //         QCString tmp = resolv[j].local8Bit();
//	  write(fd, tmp.data()+2, tmp.length() - 27);
//	  write(fd, "\n", 1);
//	}
//	else {
//	  QCString tmp = resolv[j].local8Bit() + "\n";
//	  write(fd, tmp, tmp.length());
//	}
//      }
//    }
//    close(fd);

//  }

//  if (  modified_hostname ) {
//    Requester::rq->setHostname(old_hostname);
//    modified_hostname = FALSE;
//  }

//}
private slots:
  void readChar(unsigned char);
  void pause();
  void if_waiting_slot();

public slots:
  void init();
  void preinit();
  void script_timed_out();
  void if_waiting_timed_out();
  void cancelbutton();

signals:
  void if_waiting_signal();
  void debugMessage(const QString &);
  void toggleDebugWindow();
  void closeDebugWindow();
  void debugPutChar(unsigned char);
  void startAccounting();
  void stopAccounting();

public:
  QString myreadbuffer;  // we want to keep every thing in order to fish for the

  // connection speed later on
  QPushButton *debug;
  int main_timer_ID;

private:
  int vmain;
  int substate;
  int scriptindex;
  QString scriptCommand, scriptArgument;
  QStringList *comlist, *arglist;

  //  static const int maxloopnest=(MAX_SCRIPT_ENTRIES/2);
  int loopnest;
  int loopstartindex[MAXLOOPNEST];
  bool loopend;
  QString loopstr[MAXLOOPNEST];

  bool semaphore;
  QTimer *inittimer;

  QTimer *timeout_timer;
  bool execppp();
  void writeline(const QString &);
  void checkBuffers();

  void setExpect(const QString &);
  bool expecting;
  QString expectstr;

  QString readbuffer;

  void setScan(const QString &);
  QString scanvar;
  QString scanstr;
  QString scanbuffer;
  bool scanning;

  bool pausing;
//  PWEntry *prompt;
//  LoginTerm *termwindow;

  int scriptTimeout;
  QTimer *pausetimer;
  QTimer *if_timer;
  QTimer *if_timeout_timer;

  QLabel *messg;
  KPushButton *cancel;

  bool firstrunID;
  bool firstrunPW;

  unsigned int dialnumber; // the current number to dial

  PPPStats *stats;
};


// non-member function to kill&wait on the pppd child process
extern void killppp();


#endif

