/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _PPPSTATS_H_
#define _PPPSTATS_H_

#include <net/if_ppp.h>
#include "knetconfig.h"
#include <qobject.h>

class QTimer;
class knet;
class PrefDialog;
class DockWidget;

class PPPStats : public QObject {
  Q_OBJECT
public:
  PPPStats();
  ~PPPStats();
  void clear();
  bool initStats();
  bool doStats();
  bool ifIsUp();
  void setUnit(int u);
  void start();
  void stop();

signals:
  void statsChanged(int);
  void resetStatus();
  void interfaceUp();
  void interfaceDown();
  void ipUp();
  void bytesChanged();
  void lostConnection();

private slots:
  void timerClick();

public:
  int ibytes, obytes;
  int totalbytes;
  int ipackets, opackets;
  int compressedin;
  int uncompressedin;
  int compressed;
  int errorin;
  int packetsunc, packetsoutunc;
  bool connectionStatus;

  QString local_ip_address;
  QString remote_ip_address;
  enum IOStatus { BytesDiscon = 0, BytesIn, BytesOut, BytesBoth, BytesNone};
  
private:
  bool get_ppp_stats(struct ppp_stats *curp);
  bool strioctl(int fd, int cmd, char* ptr,int ilen, int olen);

  int ibytes_last, obytes_last;
  int s;                      // socket file descriptor
#ifdef STREAMS
  int t;
#endif
  int unit;
  char unitName[5];
  enum IOStatus ioStatus;
  QTimer *timer;
    PrefDialog *m_prefDialog;
    DockWidget* dock_widget;  
  
};

#endif
