  /*

  knetfilter v 3.0.2

  Copyright (C) 2002 Luigi Genoni
                     venom@sns.it
  */
  
#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"

// tcpmss rules

void knetfilter::starttcpmssRules() {
    
    QString firsttcpmssnet, firsttcpmssnetmask, firsttcpmssnetwork, secondtcpmssnet, secondtcpmssnetmask, secondtcpmssnetwork, tcpmssrulepos; 
    
    //let's convert everything
    firsttcpmssnet.sprintf((const char *)(firsttcpmssNet->text()));
    firsttcpmssnetmask.sprintf((const char *)(firsttcpmssNetMask->text()));
    secondtcpmssnet.sprintf((const char *)(secondtcpmssNet->text()));
    secondtcpmssnetmask.sprintf((const char *)(secondtcpmssNetMask->text()));

    tcpmssrulepos.sprintf((const char *)(addtcpmssRuleNumber->text()));
    
    if (firsttcpmssnetmask.length()==0)
      {
	firsttcpmssnetmask.sprintf("255.255.255.255");
      }

    if (secondtcpmssnetmask.length()==0)
      {
	secondtcpmssnetmask.sprintf("255.255.255.255");
      }

    if ((strcmp((const char *)(firsttcpmssNet->text()),"0.0.0.0")==0))
      {
	firsttcpmssnetwork.sprintf("0.0.0.0/0");
      }

    if ((strcmp((const char *)(secondtcpmssNet->text()),"0.0.0.0")==0))
      {
	secondtcpmssnetwork.sprintf("0.0.0.0/0");
      }

    firsttcpmssnetwork.sprintf("%s/%s",(const char *)(firsttcpmssnet), (const char *)(firsttcpmssnetmask));  

    secondtcpmssnetwork.sprintf("%s/%s",(const char *)(secondtcpmssnet), (const char *)(secondtcpmssnetmask));  

    if (firsttcpmssnet.length()==0)
      {
	firsttcpmssnetwork.sprintf("0.0.0.0/0");
      }

    if (secondtcpmssnet.length()==0)
      {
	secondtcpmssnetwork.sprintf("0.0.0.0/0");
      }

    tcpmssrules.clearArguments();
    
    if (tcpmssrulepos.length()==0)
      {
	tcpmssruleaction = "-A";
	tcpmssrulepos.sprintf("-v");
      }
    else
      {
	tcpmssruleaction = "-I";
      }
    
    if (strcmp(tcpmssChoice,"FORWARD")==0)
      {
	tcpmssrules << "iptables" << tcpmssruleaction << "FORWARD" << tcpmssrulepos << "-p" << "tcp" << "--tcp-flags" << "SYN,RST" << "SYN" << "-s" << firsttcpmssnetwork << "-d" << secondtcpmssnetwork << "-j" << "TCPMSS" << "--clamp-mss-to-pmtu";
      }
    else
      {
	if (strcmp(tcpmssChoice,"OUTPUT")==0)
	  {
	    tcpmssrules << "iptables" << tcpmssruleaction << "OUTPUT" << tcpmssrulepos << "-p" << "tcp" << "--tcp-flags" << "SYN,RST" << "SYN" << "-s" << firsttcpmssnetwork << "-d" << secondtcpmssnetwork << "-j" << "TCPMSS" << "--clamp-mss-to-pmtu";
	  }
      }
    
    if (strcmp(tcpmssChoice,"NAT POSTROUTING")==0)
      {
	tcpmssrules << "iptables" << "-t" << "nat" << tcpmssruleaction << "POSTROUTING" << tcpmssrulepos << "-p" << "tcp" << "--tcp-flags" << "SYN,RST" << "SYN" << "-s" << firsttcpmssnetwork << "-d" << secondtcpmssnetwork << "-j" << "TCPMSS" << "--clamp-mss-to-pmtu";
      }
    else
      {
	if (strcmp(tcpmssChoice,"NAT OUTPUT")==0)
	  {
	    tcpmssrules << "iptables" << "-t" << "nat" << tcpmssruleaction << "OUTPUT" << tcpmssrulepos << "-p" << "tcp" << "--tcp-flags" << "SYN,RST" << "SYN" << "-s" << firsttcpmssnetwork << "-d" << secondtcpmssnetwork << "-j" << "TCPMSS" << "--clamp-mss-to-pmtu";
	  }
      }
    
    bool success=tcpmssrules.start();      
    if(success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

    if (success) {
      statusbar->message(i18n("TcpMSS setted up"), 2000);
      QString msg;
      msg.sprintf("Tcpmss setted to mtu for %s packets",tcpmssChoice);
      messageLog->insertItem(msg);
      firsttcpmssNet->clear();
      firsttcpmssNetMask->clear();
      secondtcpmssNet->clear();
      secondtcpmssNetMask->clear();
      addtcpmssRuleNumber->clear();
    }
    else
      {
	statusbar->message(i18n("iptables died"), 2000);
	firsttcpmssNet->setFocus();
	firsttcpmssNetMask->setFocus();
	secondtcpmssNet->setFocus();
	secondtcpmssNetMask->setFocus();	
	addtcpmssRuleNumber->setFocus();
      }
  };

//void knetfilter::stoptcpmssRules() {
//};

void knetfilter::tcpmssRules() {
  if ( tcpmssList == NULL )
    {
      // DBG(KNFDEBUG, "Creating tcpmssList");
      setupConnect();
      
      tcpmssList = new KNFWidget();
      tcpmssList->resize(420,240);
      tcpmssList->setCaption("Set TcpMSS Rules");
      
      QBoxLayout *top = new QBoxLayout(tcpmssList, QBoxLayout::LeftToRight, 10);
      QGridLayout *grid = new QGridLayout(10,10);
      top->addLayout(grid,10);

      QLabel *labelTcpmssadvise = new QLabel(tcpmssList);
      labelTcpmssadvise->setText("Alter MSS value of Tcp SYN packets, to limit");
      grid->addMultiCellWidget(labelTcpmssadvise,0,0,1,9);
      QLabel *labelTcpmssadvise2 = new QLabel(tcpmssList);
      labelTcpmssadvise2->setText("maximum size for a connection to your MTU");
      grid->addMultiCellWidget(labelTcpmssadvise2,1,1,1,9);

      QLabel *labelTcpmssaction = new QLabel(tcpmssList);
      labelTcpmssaction->setText("Action :");
      //      labelTcpmssaction->setText("Chain position :");
      grid->addMultiCellWidget(labelTcpmssaction,3,3,0,0);

      tcpmsschain = new QComboBox( FALSE, tcpmssList, "Action");
      tcpmsschain->insertItem("FORWARD (filter routed packets)"); 
      tcpmsschain->insertItem("OUTPUT"); 
      tcpmsschain->insertItem("NAT POSTROUTING"); 
      tcpmsschain->insertItem("NAT OUTPUT"); 
      tcpmsschain->setFixedHeight(tcpmsschain->sizeHint().height());
      connect(tcpmsschain, SIGNAL(activated(int)), SLOT(tcpmssActivated(int)));

      grid->addMultiCellWidget(tcpmsschain,3,3,1,3);

      QLabel *labeltcpmssRuleNumber = new QLabel(tcpmssList);
      labeltcpmssRuleNumber->setText("Rule Position:");
      addtcpmssRuleNumber = new QLineEdit(tcpmssList);
      addtcpmssRuleNumber->setFixedHeight(addtcpmssRuleNumber->sizeHint().height());
      addtcpmssRuleNumber->setText("");

      grid->addMultiCellWidget(labeltcpmssRuleNumber,3,3,5,6);
      grid->addMultiCellWidget(addtcpmssRuleNumber,3,3,7,7);

      QLabel *labelfirsttcpmssNet = new QLabel(tcpmssList);
      labelfirsttcpmssNet->setText("source addess:");
      
      QLabel *labelfirsttcpmssNetMask = new QLabel(tcpmssList);
      labelfirsttcpmssNetMask->setText("netmask");
      
      grid->addMultiCellWidget(labelfirsttcpmssNet,5,5,0,1);
      grid->addMultiCellWidget(labelfirsttcpmssNetMask,5,5,5,6);

      firsttcpmssNet = new QLineEdit(tcpmssList);
      firsttcpmssNetMask = new QLineEdit(tcpmssList);

      firsttcpmssNet->setFixedHeight(firsttcpmssNet->sizeHint().height());
      firsttcpmssNetMask->setFixedHeight(firsttcpmssNetMask->sizeHint().height());

      grid->addMultiCellWidget(firsttcpmssNet,5,5,2,3);
      grid->addMultiCellWidget(firsttcpmssNetMask,5,5,7,8);

      QLabel *labelsecondtcpmssNet = new QLabel(tcpmssList);
      labelsecondtcpmssNet->setText("destination addess:");

      QLabel *labelsecondtcpmssNetMask = new QLabel(tcpmssList);
      labelsecondtcpmssNetMask->setText("netmask");
      
      grid->addMultiCellWidget(labelsecondtcpmssNet,6,6,0,1);
      grid->addMultiCellWidget(labelsecondtcpmssNetMask,6,6,5,6);

      secondtcpmssNet = new QLineEdit(tcpmssList);
      secondtcpmssNetMask = new QLineEdit(tcpmssList);

      secondtcpmssNet->setFixedHeight(secondtcpmssNet->sizeHint().height());
      secondtcpmssNetMask->setFixedHeight(secondtcpmssNetMask->sizeHint().height());

      grid->addMultiCellWidget(secondtcpmssNet,6,6,2,3);
      grid->addMultiCellWidget(secondtcpmssNetMask,6,6,7,8);

      QPushButton *btnRules = new QPushButton(tcpmssList);
      btnRules->setText("Commit");
      btnRules->setFixedHeight(btnRules->sizeHint().height());
      connect(btnRules,SIGNAL(clicked()), this, SLOT(starttcpmssRules()));
      grid->addWidget(btnRules,9,3);

      QPushButton *btnClose = new QPushButton(tcpmssList);
      btnClose->setText("Close");
      btnClose->setFixedHeight(btnClose->sizeHint().height());
      connect(btnClose,SIGNAL(clicked()), this, SLOT(closetcpmssRules()));
      grid->addWidget(btnClose,9,7);
    
      tcpmssList->show();
      setCentralWidget(tcpmssList);
    }
  else
    {
            if( !tcpmssList->isVisible() )
        {
          tcpmssList->show();
        } 
      else
        {
          QMessageBox::critical(0,"Warning", "Already Running\n");
        }	    
    }
};

void knetfilter::settcpmssRules(KProcess *, char *data, int len) {
  
  if (len<0)
    return;
  static QString remainder;
  QString list;
  
  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;
  
  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;
  
  while (1)
  {
    newindex=list.find('\n',index);
    if(newindex==-1) {
      remainder=list.right(list.length()-index);
      break;
    } else {
      lines.append(list.mid(index,newindex-index));
      index=newindex+1;
    };
  };
};

void knetfilter::tcpmssActivated(int index) {
  switch(index) {
  default:
    tcpmssChoice = "FORWARD";
  case 0:
    tcpmssChoice = "FORWARD";
    break;
  case 1:
    tcpmssChoice = "OUTPUT";
    break;
  case 2:
    tcpmssChoice = "NAT POSTROUTING";
    break;
  case 3:
    tcpmssChoice = "NAT OUTPUT";
    break;
  };
};

void knetfilter::tcpmssRulesDone() {
  if (tcpmssrules.normalExit() && (tcpmssrules.exitStatus()==0))
    statusbar->message(i18n("Setting TcpMSS Rule..."), 2000);
  else
    statusbar->message(i18n("Couldn't set TcpMSS Rule"), 2000);
};


void knetfilter::closetcpmssRules() {
  tcpmssList->close();

};
