/***************************************************************************
 *
 * knetworkmanager-connection_editor.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_EDITOR_H
#define KNETWORKMANAGER_CONNECTION_EDITOR_H

// qt headers
#include <qvaluelist.h>

// qt autogenerated headers
#include "connection_editor.h"

// knm headers
#include "knetworkmanager-connection_setting.h"

class QWidget;
class Device;

namespace ConnectionSettings
{
	class WidgetInterface;
	class ConnectionSetting;
}

class ConnectionEditorImpl : public ConnectionEditor
{
	Q_OBJECT
	public:
		ConnectionEditorImpl(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
		~ConnectionEditorImpl();

	protected slots:
		void slotRemoveCurrentConnection();
		void slotEditCurrentConnection();
		void slotNewWirelessConnection();
		void slotNewWiredConnection();
		void slotNewVPNConnection();
		void slotEditNewConnection(Connection* conn);
		void slotRefershConnectionList();

	private:
		void fillConnectionList();
};

#endif /* KNETWORKMANAGER_CONNECTION_EDITOR_H*/
