/***************************************************************************
 *
 * knetworkmanager-connection_setting.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_H
#define KNETWORKMANAGER_CONNECTION_SETTING_H

#include <qmap.h>
#include <qobject.h>
#include <dbus/qdbusdata.h>

namespace ConnectionSettings
{

/*
  Annotation: hopefully we can convert these to
  QMap<QString, QVariant> when switching to Qt4 
*/
typedef QMap<QString, QDBusData> SettingsMap;

class Connection;

// the base class for all settings
class ConnectionSetting : public QObject
{
	Q_OBJECT
	public:
		ConnectionSetting(Connection* conn, QString type, const char* name = 0, bool enabled = true);
		ConnectionSetting(const ConnectionSetting&);

		// serialize the setting to a map
		virtual SettingsMap toMap() const = 0;

		// serialize the secrets to a map
		virtual SettingsMap toSecretsMap(bool withSettings = true) const;

		// initialize setting from a settingsmap
		virtual void fromMap(const SettingsMap&) = 0;

		// set secrtes from a secretsmap
		virtual bool fromSecretsMap(const SettingsMap&);

		// return whether this setting should be used or not
		virtual bool getEnabled(void) const;

		// return whether this setting is valid or not
		virtual bool isValid() const = 0;

		// return the settings type
		QString getType(void) const;

		// return the connection this setting belongs to
		Connection* getConnection(void) const;

		// return whether the setting has secrets or not
		virtual bool hasSecrets(void) const;

	signals:
		void validityChanged();

	protected:
		void emitValidityChanged();

		// parent-connection
		Connection* _conn;

	private:
		QString     _type;
		bool        _enabled;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_H */
