/***************************************************************************
 *
 * knetworkmanager-connection_setting_ppp_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <nm-setting-ppp.h>

// qt headers
#include <qwidget.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qiconset.h>
#include <kiconloader.h>
#include <qwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_ppp.h"
#include "knetworkmanager-connection_setting_ppp_widget.h"
#include "knetworkmanager-device.h"

#include "connection_setting_ppp.h"

using namespace ConnectionSettings;

PPPWidgetImpl::PPPWidgetImpl(Connection* conn, QWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_pppsetting = dynamic_cast<ConnectionSettings::PPP*> (conn->getSetting(NM_SETTING_PPP_SETTING_NAME));

	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingPppWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
PPPWidgetImpl::Init()
{
    _mainWid->mNoAuth->setChecked( _pppsetting->getNoAuth() );
    _mainWid->mRefuseEap->setChecked( _pppsetting->getRefuseEAP( ) );
    _mainWid->mRefusePap->setChecked( _pppsetting->getRefusePAP( ) );
    _mainWid->mRefuseChap->setChecked( _pppsetting->getRefuseChap() );
    _mainWid->mRefuseMschap->setChecked( _pppsetting->getRefuseMSChap() );
    _mainWid->mRefuseMschapV2->setChecked( _pppsetting->getRefuseMSChapV2() );
    _mainWid->mNoBsd->setChecked( _pppsetting->getNoBSDComp() );
    _mainWid->mNoDeflate->setChecked( _pppsetting->getNoDeflate() );
    _mainWid->mNoVjComp->setChecked( _pppsetting->getNoVJComp() );
    _mainWid->mRequireMppe->setChecked( _pppsetting->getRequireMPPE( ));
    _mainWid->mRequireMppe128->setChecked( _pppsetting->getRequireMPPE128( ));
    _mainWid->mStatefulMppe->setChecked( _pppsetting->getMPPEStateful() );
    _mainWid->mRequireMppc->setChecked( _pppsetting->getRequireMPPC() );
    _mainWid->mCrtscts->setChecked( _pppsetting->getCRTSCTS() );

    _mainWid->mBaudRate->setValue(_pppsetting->getBaud());
    _mainWid->mMru->setValue(_pppsetting->getMRU());
    _mainWid->mMtu->setValue(_pppsetting->getMTU());
    _mainWid->mLcpEchoFailure->setValue(_pppsetting->getLCPEchoFailure());
    _mainWid->mLcpEchoInterval->setValue(_pppsetting->getLCPEchoInterval());
    connect( _mainWid->mNoAuth, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRefuseEap, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRefusePap, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRefuseChap, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRefuseMschap, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRefuseMschapV2, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mNoBsd, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mNoDeflate, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRequireMppe, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRequireMppe128, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mStatefulMppe, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mRequireMppc, SIGNAL(toggled(bool)), SLOT(dirty()));
    connect( _mainWid->mCrtscts, SIGNAL(toggled(bool)), SLOT(dirty()));
}

void
PPPWidgetImpl::Deactivate()
{
}

void
PPPWidgetImpl::Activate()
{

}

void
PPPWidgetImpl::dirty()
{
    _pppsetting->setNoAuth( _mainWid->mNoAuth->isChecked() );
    _pppsetting->setRefuseEAP( _mainWid->mRefuseEap->isChecked() );
    _pppsetting->setRefuseChap( _mainWid->mRefuseChap->isChecked() );
    _pppsetting->setRefuseMSChap( _mainWid->mRefuseMschap->isChecked() );
    _pppsetting->setNoBSDComp( _mainWid->mNoBsd->isChecked() );
    _pppsetting->setNoDeflate( _mainWid->mNoDeflate->isChecked() );
    _pppsetting->setRequireMPPE( _mainWid->mRequireMppe->isChecked() );
    _pppsetting->setRequireMPPE( _mainWid->mRequireMppe128->isChecked() );
    _pppsetting->setMPPEStateful( _mainWid->mStatefulMppe->isChecked() );

    _pppsetting->setBaud(_mainWid->mBaudRate->value());
    _pppsetting->setMRU(_mainWid->mMru->value());
    _pppsetting->setMTU(_mainWid->mMtu->value());
    _pppsetting->setLCPEchoFailure(_mainWid->mLcpEchoFailure->value());
    _pppsetting->setLCPEchoInterval(_mainWid->mLcpEchoInterval->value());
}

#include "knetworkmanager-connection_setting_ppp_widget.moc"
