/***************************************************************************
 *
 * knetworkmanager-connection_setting_serial.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_SERIAL_H
#define KNETWORKMANAGER_CONNECTION_SETTING_SERIAL_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>

#include <dbus/qdbusdata.h>

#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-ppp.h>
#include <nm-setting-serial.h>

namespace ConnectionSettings
{

class Connection;

// serial setting
class Serial : public ConnectionSetting
{
	public:
		enum PARITY_MODE
		{
			PARITY_NONE = 0
		, PARITY_EVEN
		, PARITY_ODD
		};

		Serial(Connection* conn);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		bool     isValid() const;
		bool     useSetting();

		void     setBaud(Q_UINT32);
		Q_UINT32 getBaud() const;

		void     setBits(Q_UINT32);
		Q_UINT32 getBits() const;

		void     setParity(PARITY_MODE);
		PARITY_MODE getParity() const;

		void     setStopBits(Q_UINT32);
		Q_UINT32 getStopBits() const;

		void     setSendDelay(Q_UINT64);
		Q_UINT64 getSendDelay() const;

	private:
		Q_UINT32 _baud;
		Q_UINT32 _bits;
		PARITY_MODE _parity;
		Q_UINT32 _stopBits;
		Q_UINT64 _sendDelay;
};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_SERIAL_H */
