/***************************************************************************
 *
 * knetworkmanager-connection_setting_vpn.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDBus headers*/
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection_setting_vpn.h"

using namespace ConnectionSettings;

/*
	class VPN
*/
VPN::VPN(Connection* conn)
	: ConnectionSetting(conn, NM_SETTING_VPN_SETTING_NAME)
{

}

QString VPN::getUserName() const
{
	return _userName;
}

void VPN::setUserName(const QString& u)
{
	_userName = u;
	emitValidityChanged();
}

QString VPN::getServiceType() const
{
	return _serviceType;
}

void VPN::setServiceType(const QString& s)
{
	_serviceType = s;
	emitValidityChanged();
}

QValueList<QString> VPN::getRoutes() const
{
	return _routes;
}

void VPN::setRoutes(const QValueList<QString>& r)
{
	_routes = r;
	emitValidityChanged();
}

void VPN::setData(QMap<QString, QString> data)
{
	_data = data;
	emitValidityChanged();
}

QMap<QString, QString> VPN::getData() const
{
	return _data;
}

void VPN::setSecrets(const QMap<QString, QString>& data)
{
	_secrets = data;
	emitValidityChanged();
}

QMap<QString, QString> VPN::getSecrets() const
{
	return _secrets;
}


SettingsMap
VPN::toMap() const
{
	SettingsMap map;

	map.insert(NM_SETTING_VPN_SERVICE_TYPE, QDBusData::fromString(_serviceType));
	map.insert(NM_SETTING_VPN_USER_NAME, QDBusData::fromString(_userName));

	if (!_routes.isEmpty())
	{
		QValueList<QDBusData> list;
		for (QValueList<QString>::ConstIterator it = _routes.begin(); it != _routes.end(); ++it)
		{
			list.append(QDBusData::fromString(*it));
		}
	}

	// NM expects a String/String map -> convert
	QDBusDataMap<QString> data;
	
	for (QMap<QString, QString>::ConstIterator it = _data.begin(); it != _data.end(); ++it)
	{
		data.insert(it.key(), QDBusData::fromString(it.data()));
	}

	map.insert(NM_SETTING_VPN_DATA, QDBusData::fromStringKeyMap(data));


	return map;
}

void
VPN::fromMap(const SettingsMap& map)
{
	SettingsMap::ConstIterator it;

	if ((it = map.find(NM_SETTING_VPN_SERVICE_TYPE)) != map.end())
		_serviceType = it.data().toString();
	
	if ((it = map.find(NM_SETTING_VPN_USER_NAME)) != map.end())
		_userName = it.data().toString();

	QDBusDataMap<QString> data;
	_data.clear();

	if ((it = map.find(NM_SETTING_VPN_DATA)) != map.end())
	{
		data = it.data().toStringKeyMap();
		for (QMap<QString, QDBusData>::ConstIterator it = data.begin(); it != data.end(); ++it)
		{
			_data.insert(it.key(), it.data().toString());
		} 
	}
}

SettingsMap
VPN::toSecretsMap(bool with_settings) const
{
	SettingsMap map;

	// NM does not want the settings too
/*	if (with_settings)
		map = toMap();*/

	// copy all secrets into the map
	for (QMap<QString, QString>::ConstIterator it = _secrets.begin(); it != _secrets.end(); ++it)
		map.insert(it.key(), QDBusData::fromString(it.data()));

	return map;
}

bool
VPN::fromSecretsMap(const SettingsMap& map)
{
/*	SettingsMap::ConstIterator it;
	QDBusDataMap<QString> data;
	
	if ((it = map.find(NM_SETTING_VPN_DATA)) != map.end())
	{
		data = it.data().toStringKeyMap();
		_data = data.toQMap();
	}*/
	// FIXME
	return false;
}

bool
VPN::isValid() const
{
	// name is essential
	if (_userName.isEmpty() || _serviceType.isEmpty())
		return false;

	// data is essential
	if (_data.isEmpty())
		return false;

	return true;
}
