/***************************************************************************
 *
 * knetworkmanager-device.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICE_H
#define KNETWORKMANAGER_DEVICE_H

#include <NetworkManager.h>

#include "knetworkmanager.h"

#include <stdint.h>

class KNetworkManager;
class Network;
class IP4Config;

class DevicePrivate;

class Device : public QObject
{
	Q_OBJECT
	public:
		Device (const QString & obj_path );
		~Device ();

		Q_UINT32 getDeviceType() const;
		QString getInterface() const;
    QString getUdi() const;
    QString getDriver() const;
    Q_UINT32 getCapabilities() const;
    Q_INT32 getIp4Address() const;
    NMDeviceState getState() const;
// FIXME: should return IPv4-objects
//    QDBusObjectPath getIp4Config() const;

		QString getVendor() const;
		QString getProduct() const;
		QString getObjectPath() const;

	signals:
		void StateChanged(NMDeviceState);

	public slots:
		void slotStateChanged(Q_UINT32);
		void slotDeactivate();

	private:
		DevicePrivate * d;
};

#endif /* KNETWORKMANAGER_DEVICE_H */
