/***************************************************************************
 *
 * knetworkmanager-device_tray.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICE_TRAY_H
#define KNETWORKMANAGER_DEVICE_TRAY_H

#include <qmap.h>
#include <qtimer.h>

#include <qtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <kpopupmenu.h>
#include <kactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qprogressbar.h>
#include <qguardedptr.h>

#include <NetworkManager.h>
#include "knetworkmanager.h"

class Device;
class DeviceTrayPrivate;

class DeviceTray : public KSystemTray
{
	Q_OBJECT

	public:
	  DeviceTray (Device*);
	  ~DeviceTray ();

		void contextMenuAboutToShow (KPopupMenu* menu);
		virtual void addMenuItems(KPopupMenu* menu) = 0;
		Device* getDevice() const;

	protected:
		void setPixmapForState(NMDeviceState, QMovie);
		void setPixmapForState(NMDeviceState, QPixmap);

		virtual QString getTooltipText();

	public slots:
		void setPixmap(const QPixmap &);
		void slotUpdateDeviceState(NMDeviceState);
		void slotUpdateDeviceState();

	private:
		void updateTrayIcon(NMDeviceState);
		void updateActions(NMDeviceState);
		void updateActiveConnection(NMDeviceState);
		void enterEvent (QEvent*);

		DeviceTrayPrivate* d;
};

#endif /* KNETWORKMANAGER_DEVICE_TRAY_H */
