/***************************************************************************
 *
 * knetworkmanager-wired_device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <qhostaddress.h>

// QDBus includes
#include <dbus/qdbuserror.h>
#include <dbus/qdbusconnection.h>

// NM includes
#include <NetworkManager.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-wired_device.h"
#include "dbus/wiredproxy.h"
#include "knetworkmanager-hal_device_proxy.h"

class WiredDevicePrivate
{
public:
	WiredDevicePrivate(QString service, QString obj_path)
		: nmWired(service, obj_path)
	{}
	~WiredDevicePrivate() {}

	DBus::WiredDeviceProxy nmWired;
};

QString WiredDevice::getHwAddress()
{
	QDBusError err;
	return d->nmWired.getHwAddress(err);
}

Q_UINT32 WiredDevice::getSpeed()
{
	QDBusError err;
	return d->nmWired.getSpeed(err);
}

bool WiredDevice::getCarrier() const
{
	QDBusError err;
	return d->nmWired.getCarrier(err);
}

WiredDevice::WiredDevice (const QString & obj_path)
	: Device(obj_path)
{
	d = new WiredDevicePrivate(NM_DBUS_SERVICE, obj_path);
	d->nmWired.setConnection(QDBusConnection::systemBus());
}

WiredDevice::~WiredDevice ()
{
	delete d;
}


#include "knetworkmanager-wired_device.moc"
