/***************************************************************************
 *
 * knetworkmanager-wireless_manager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_WIRELESS_MANAGER_H
#define KNETWORKMANAGER_WIRELESS_MANAGER_H

// Qt includes
#include <qguardedptr.h>
#include <qmap.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-device_tray.h"
#include "knetworkmanager-accesspoint.h"
#include "knetworkmanager-wireless_device.h"
#include "knetworkmanager-wireless_network.h"

namespace ConnectionSettings
{
	class WirelessConnection;
}

class WirelessManager
{
	public:
		// get all accesspoints from device dev or from all devices if dev is NULL
		// and group them together using all properties specified in match
		static QValueList<WirelessNetwork> getWirelessNetworks(WirelessDevice* dev = 0, Q_UINT32 match = WirelessNetwork::MATCH_SSID);

		// get all aps from either one device or from all available devices
		static QValueList<AccessPoint*> getAccessPoints(WirelessDevice* dev = 0);

		// get a list of all known wireless connections
		static QValueList<ConnectionSettings::WirelessConnection*> getWirelessConnections();

		// get a list of all APs with a specific SSID
		static QValueList<AccessPoint*> getAccessPointsForEssid(QByteArray, WirelessDevice* dev = 0);

};

#endif /* KNETWORKMANAGER_WIRELESS_MANAGER_H */
