/***************************************************************************
 *
 * knetworkmanager.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// NM includes
#include <NetworkManager.h>

// QDBus includes
#include <dbus/qdbusdata.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-tray.h"
#include "knetworkmanager-devicestore.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-cellular_device.h"
#include "knetworkmanager-wireless_device.h"
#include "knetworkmanager-wired_device.h"
#include "knetworkmanager-cellular_device_tray.h"
#include "knetworkmanager-wireless_device_tray.h"
#include "knetworkmanager-wired_device_tray.h"
#include "knetworkmanager-nmsettings.h"
#include "knetworkmanager-storage.h"
#include "xmlmarshaller.h"

class KNetworkManagerPrivate
{
	public:
		KNetworkManagerPrivate() {}
		~KNetworkManagerPrivate() {}
};

KNetworkManager* KNetworkManager::_ctx = NULL;

KNetworkManager* KNetworkManager::getInstance()
{
	return _ctx;
}

void
KNetworkManager::slotShutDown()
{
	// cleanup code
	Storage* storage = Storage::getInstance();

	storage->saveConnections();
}

KNetworkManager::KNetworkManager () : KUniqueApplication ()
{
	_ctx = this;
	d = new KNetworkManagerPrivate();

	// we need to get informed when shutting down
	connect(this, SIGNAL(shutDown()), this, SLOT(slotShutDown()));

	// create the main-tray-icon
	Tray* tray = Tray::getInstance();
	tray->show();
	setMainWidget(tray);

	// create the settings interface
	NMSettings::getInstance();

	// restore all known connections first
	Storage* storage = Storage::getInstance();
	storage->restoreConnections();
}

KNetworkManager::~KNetworkManager()
{
	delete d;
}

#include "knetworkmanager.moc"

