FIND_LIBRARY(KRITAIMAGE_LIBRARY NAMES kritaimage
  PATHS
  $ENV{KDEDIR}/lib
  ${KDE3PREFIX}/lib
  /opt/kde3/lib
  /opt/kde/lib
  NO_DEFAULT_PATH
)

FIND_LIBRARY(KRITAIMAGE_LIBRARY NAMES kritaimage)

FIND_LIBRARY(KRITAUI_LIBRARY NAMES kritaui
  PATHS
  $ENV{KDEDIR}/lib
  ${KDE3PREFIX}/lib
  /opt/kde3/lib
  /opt/kde/lib
  NO_DEFAULT_PATH
)

FIND_LIBRARY(KRITAUI_LIBRARY NAMES kritaui)

set(LIB_INSTALL_DIR  ${CMAKE_INSTALL_PREFIX}/lib${LIB_SUFFIX})
set(SHARE_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX}/share)
set(DATA_INSTALL_DIR  "${SHARE_INSTALL_PREFIX}/apps" )

set(PLUGIN_INSTALL_DIR "${LIB_INSTALL_DIR}/kde3")
set(SERVICES_INSTALL_DIR "${SHARE_INSTALL_PREFIX}/services")

if (KRITA_EXTRA_INCLUDE_DIR)
   # in cache already
   set(KRITA_EXTRA_FOUND TRUE)
else (KRITA_EXTRA_INCLUDE_DIR)

   # Make sure we can find the place where kis_transform_worker is installed.
   find_path(KRITA_EXTRA_INCLUDE_DIR NAMES core/kis_transform_worker.h
             PATHS
             ${KRITA_EXTRA_INCLUDE_PATH}
             ${INCLUDE_INSTALL_DIR}
             /usr/include
             /usr/local/include
                )

   if(KRITA_EXTRA_INCLUDE_DIR)
      set(KRITA_EXTRA_FOUND TRUE)
   endif(KRITA_EXTRA_INCLUDE_DIR)

mark_as_advanced( KRITA_EXTRA_INCLUDE_DIR )

endif(KRITA_EXTRA_INCLUDE_DIR)

if(KRITA_EXTRA_FOUND)
   # Include the paths to the different include files.
   # XXX: IMHO only ${KRITA_EXTRA_INCLUDE_DIR} should be in the include path and 
   # the include statements should be written <core/kis_filter_strategy.h>
   include_directories( ${KRITA_EXTRA_INCLUDE_DIR} 
	   ${KRITA_EXTRA_INCLUDE_DIR}/core 
      ${KRITA_EXTRA_INCLUDE_DIR}/ui 
      ${KRITA_EXTRA_INCLUDE_DIR}/sdk
   )
endif(KRITA_EXTRA_FOUND)

# XXX: Remove these later because we should be able to track Krita_extra_include_DIR instead!!!
# find if there is kis_paint_layer.h 
find_path(KRITA_KIS_PAINT_LAYER_H_FOUND NAMES kis_paint_layer.h
     PATHS
     ${INCLUDE_INSTALL_DIR}
     ${KDE3_INCLUDE_DIRS}
     /usr/include
     /usr/local/include
     ${KRITA_EXTRA_INCLUDE_DIR}
   )

# find if there is kis_layer_visitor.h
find_path(KRITA_KIS_LAYER_VISITOR_H_FOUND NAMES kis_layer_visitor.h
     PATHS
     ${INCLUDE_INSTALL_DIR}
     ${KDE3_INCLUDE_DIRS}
     /usr/include
     /usr/local/include
     ${KRITA_EXTRA_INCLUDE_DIR}
   )

# find if there is kis_filter_strategy.h
find_path(KRITA_KIS_FILTER_STRATEGY_H_FOUND NAMES kis_filter_strategy.h
     PATHS
     ${INCLUDE_INSTALL_DIR}
     ${KDE3_INCLUDE_DIRS}
     /usr/include
     /usr/local/include
     ${KRITA_EXTRA_INCLUDE_DIR}
   )

# find if there is kis_transform_worker.h
find_path(KRITA_KIS_TRANSFORM_WORKER_H_FOUND NAMES kis_transform_worker.h
     PATHS
     ${INCLUDE_INSTALL_DIR}
     ${KDE3_INCLUDE_DIRS}
     /usr/include
     /usr/local/include
     ${KRITA_EXTRA_INCLUDE_DIR}
   )

mark_as_advanced( KRITA_KIS_PAINT_LAYER_H_FOUND 
	KRITA_EXTRA_INCLUDE_DIR 
	KRITA_KIS_LAYER_VISITOR_H_FOUND 
	KRITA_KIS_FILTER_STRATEGY_H_FOUND 
	KRITA_KIS_TRANSFORM_WORKER_H_FOUND
	)
   
