/*
 * This file is part of Krita
 *
 * Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "DodgeBurnConfigurationWidget.h"

#include <qlayout.h>
#include <qradiobutton.h>
#include <qslider.h>

#include "DodgeBurnConfigurationBaseWidget.h"

DodgeBurnConfigurationWidget::DodgeBurnConfigurationWidget(QWidget * parent, const char * name) : KisFilterConfigWidget ( parent, name )
{
    QGridLayout *widgetLayout = new QGridLayout(this, 1, 1);
    m_widget = new DodgeBurnConfigurationBaseWidget(this);
    widgetLayout -> addWidget(m_widget,0,0);
    
    connect(widget()->sliderExposure, SIGNAL(valueChanged(int)), SIGNAL(sigPleaseUpdatePreview()));
    connect(widget()->radioButtonShadows, SIGNAL( toggled(bool)  ), SIGNAL(sigPleaseUpdatePreview()));
    connect(widget()->radioButtonMidtones, SIGNAL( toggled(bool)  ), SIGNAL(sigPleaseUpdatePreview()));
    connect(widget()->radioButtonHighlights, SIGNAL( toggled(bool)  ), SIGNAL(sigPleaseUpdatePreview()));
}


DodgeBurnConfigurationWidget::~DodgeBurnConfigurationWidget()
{
}

void DodgeBurnConfigurationWidget::setConfiguration(KisFilterConfiguration* config)
{
    QVariant value;
    if (config->getProperty("exposure", value))
    {
        widget()->sliderExposure->setValue((int)(value.toDouble(0) * 100));
    }
    if (config->getProperty("type", value))
    {
        int type = value.toInt(0);
        switch(type)
        {
            case SHADOWS:
                widget()->radioButtonShadows->setChecked(true);
                break;
            case MIDTONES:
                widget()->radioButtonMidtones->setChecked(true);
                break;
            case HIGHLIGHTS:
                widget()->radioButtonHighlights->setChecked(true);
                break;
        }
    }
}

KisFilterConfiguration* DodgeBurnConfigurationWidget::configuration(QString id, int version)
{
    KisFilterConfiguration* config = new KisFilterConfiguration(id, version);
    config->setProperty("exposure", widget()->sliderExposure->value() / 100.0);
    int type;
    if(widget()->radioButtonShadows->isChecked())
    {
        type = SHADOWS;
    } else if(widget()->radioButtonMidtones->isChecked())
    {
        type = MIDTONES;
    } else {
        type = HIGHLIGHTS;
    }
    config->setProperty("type", type);
    return config;
}

#include "DodgeBurnConfigurationWidget.moc"
