/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "configlogoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>

#include <kcolordialog.h>
#include <kpushbutton.h>

ConfigLogOptions::ConfigLogOptions(QWidget *parent)
{
    Q_UNUSED(parent);

    setupUi(this);
    connect(DebugLogFontPushButton, SIGNAL(clicked(bool)), this, SLOT(debugLogColorClicked(bool)));
    connect(ErrorLogFontPushButton, SIGNAL(clicked(bool)), this, SLOT(errorLogColorClicked(bool)));
    connect(InfoLogFontPushButton, SIGNAL(clicked(bool)), this, SLOT(infoLogColorClicked(bool)));
    connect(RemoteLogFontPushButton, SIGNAL(clicked(bool)), this, SLOT(remoteLogColorClicked(bool)));
    connect(SuccessLogFontPushButton, SIGNAL(clicked(bool)), this, SLOT(successLogColorClicked(bool)));
    connect(UseColorizedLogOutputcheckBox, SIGNAL(stateChanged(int)), this, SLOT(useColorizedLogOutputToggled(int)));
    connect(BackgroundLogFontPushButton, SIGNAL(clicked(bool)), this, SLOT(backgroundLogColorClicked(bool)));

    ErrorLogLabel->setAutoFillBackground(true);
    DebugLogLabel->setAutoFillBackground(true);
    InfoLogLabel->setAutoFillBackground(true);
    RemoteLogLabel->setAutoFillBackground(true);
    SuccessLogLabel->setAutoFillBackground(true);
    SuccessLogLabel->setAutoFillBackground(true);
}


ConfigLogOptions::~ConfigLogOptions()
{}

void ConfigLogOptions::errorLogColorClicked(bool)
{

    int result = KColorDialog::getColor(ErrorLogColor);
    if (result == KColorDialog::Accepted) {
        QPalette ErrorLogPalette;
        ErrorLogPalette.setColor(ErrorLogLabel->backgroundRole(), ErrorLogColor);
        ErrorLogLabel->setPalette(ErrorLogPalette);
    }
}

void ConfigLogOptions::debugLogColorClicked(bool)
{
    int result = KColorDialog::getColor(DebugLogColor);
    if (result == KColorDialog::Accepted) {
        QPalette DebugLogPalette;
        DebugLogPalette.setColor(DebugLogLabel->backgroundRole(), DebugLogColor);
        DebugLogLabel->setPalette(DebugLogPalette);
    }
}

void ConfigLogOptions::infoLogColorClicked(bool)
{
    int result = KColorDialog::getColor(InfoLogColor);
    if (result == KColorDialog::Accepted) {
        QPalette InfoLogPalette;
        InfoLogPalette.setColor(InfoLogLabel->backgroundRole(), InfoLogColor);
        InfoLogLabel->setPalette(InfoLogPalette);
    }
}

void ConfigLogOptions::remoteLogColorClicked(bool)
{
    int result = KColorDialog::getColor(RemoteLogColor);
    if (result == KColorDialog::Accepted) {
        QPalette RemoteLogPalette;
        RemoteLogPalette.setColor(RemoteLogLabel->backgroundRole(), RemoteLogColor);
        RemoteLogLabel->setPalette(RemoteLogPalette);
    }
}

void ConfigLogOptions::successLogColorClicked(bool)
{
    int result = KColorDialog::getColor(SuccessLogColor);
    if (result == KColorDialog::Accepted) {
        QPalette SuccessLogPalette;
        SuccessLogPalette.setColor(SuccessLogLabel->backgroundRole(), SuccessLogColor);
        SuccessLogLabel->setPalette(SuccessLogPalette);
    }
}

void ConfigLogOptions::useColorizedLogOutputToggled(int)
{
    if (UseColorizedLogOutputcheckBox->isChecked())
        ColorGroupBox->setEnabled(true);
    else
        ColorGroupBox->setEnabled(false);
}

void ConfigLogOptions::backgroundLogColorClicked(bool)
{
    int result = KColorDialog::getColor(BackgroundLogColor);
    if (result == KColorDialog::Accepted) {
        QPalette BackgroundLogPalette;
        BackgroundLogPalette.setColor(BackgroundLogLabel->backgroundRole(), BackgroundLogColor);
        BackgroundLogLabel->setPalette(BackgroundLogPalette);
    }
}

void ConfigLogOptions::dialogChanged()
{
    dialogModified = true;
}

#include "configlogoptions.moc"
