/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilepptpoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QSpinBox>

#include <klineedit.h>

#include "widgetnotifyhelper.h"

ProfilePptpOptions::ProfilePptpOptions(QWidget *parent)
{
    Q_UNUSED(parent);

    setupUi(this);
    connect(DnsServerCheckbox, SIGNAL(toggled(bool)), (ProfilePptpOptions *)this, SLOT(useDnsServerToggled(bool)));
    connect(UseSearchDomainInResolvConfCheckbox, SIGNAL(toggled(bool)), (ProfilePptpOptions *)this, SLOT(useSearchDomainInResolvConfToggled(bool)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;


}


ProfilePptpOptions::~ProfilePptpOptions()
{}

void ProfilePptpOptions::useDnsServerToggled(bool)
{
    if (DnsServerCheckbox->isChecked())
        DnsServerLineedit->setEnabled(true);
    else
        DnsServerLineedit->setEnabled(false);
}


void ProfilePptpOptions::useSearchDomainInResolvConfToggled(bool)
{
    if (UseSearchDomainInResolvConfCheckbox ->isChecked())
        SearchDomainInResolvConfLineedit->setEnabled(true);
    else
        SearchDomainInResolvConfLineedit->setEnabled(false);
}

void ProfilePptpOptions::dialogChanged()
{
    dialogModified = true;
}

