/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KWCENTRYURLLABEL_H
#define KWCENTRYURLLABEL_H

#include <kwcentry.h>
#include <kurllabel.h>
#include <kapplication.h>

/**
@author Matthias Reif
*/
class KWCEntryURLLabel : public KWCEntry
{
Q_OBJECT
public:
	KWCEntryURLLabel( const QString & insrc, QString text, QString url, KSingleTabWidget *parent = 0, const char *name = 0 );
	~KWCEntryURLLabel();

protected:
	KURLLabel* urlLabel;

private slots:
	void leftClickedURLSlot(const QString &url);

signals:
	void leftClickedURL(const QString & );
};

#endif
