/***************************************************************************
                          smallwidget.cpp  -  description
                             -------------------
    begin                : Sam Jan 25 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smallwidget.h"

/*!
	\fn SmallWidget::SmallWidget( QWidget *parent, const char *name, WFlags flags )
*/
SmallWidget::SmallWidget( QWidget *parent, const char *name, WFlags flags ) : QWidget( parent, name, flags )
{
	/* move to the last position of the widget */
	KGlobal::config()->setGroup( "KWaveControl" );
	move( KGlobal::config()->readNumEntry( "smallX", 0 ), KGlobal::config()->readNumEntry( "smallY", 0 ) );
	
	resize( 105, 20 );

	linkBar = new KProgress( this );
	linkBar->resize( width( ), height( ) );
	linkBar->move( 0,0 );
	linkBar->show( );

	isCard = true;
	
	popup = new KPopupMenu( this );
	popup->insertItem( KGlobal::iconLoader()->loadIcon( "fileclose", KIcon::Small ), "Close" , this, SLOT( hide() ) );

	hold = false;

	/* needed to get the resolution */
	desktop = QApplication::desktop( );
}


/*!
	\fn SmallWidget::~SmallWidget()
*/
SmallWidget::~SmallWidget()
{
	delete linkBar;
	delete popup;
}


/*!
	\fn SmallWidget::mousePressEvent( QMouseEvent *ev )
*/
void SmallWidget::mousePressEvent( QMouseEvent *ev )
{
  if( ev->button() == LeftButton )
  {
		xPress = ev->x();
		yPress = ev->y();
		hold = true;
	}
  if( ev->button() == RightButton )
  {
		popup->move( ev->globalPos() );
		popup->exec();
	}
}


/*!
	\fn SmallWidget::mouseReleaseEvent( QMouseEvent *ev )
*/
void SmallWidget::mouseReleaseEvent( QMouseEvent *ev )
{
	// avoid compiler warning
	ev = ev;
	hold = false;
	KGlobal::config()->setGroup( "KWaveControl" );
	KGlobal::config()->writeEntry( "smallX", x() );
	KGlobal::config()->writeEntry( "smallY", y() );
}


/*!
	\fn SmallWidget::mouseMoveEvent( QMouseEvent *ev )
*/
void SmallWidget::mouseMoveEvent( QMouseEvent *ev )
{
	if( hold )
	{
		int x = ev->globalX() - xPress;
		int y = ev->globalY() - yPress;
		if( x > desktop->width() - width() )
			x = desktop->width() - width();
		if( y > desktop->height() - height() )
			y = desktop->height() - height();
		if( x < 0 )
			x = 0;
		if( y < 0 )
			y = 0;
		move( x, y );
	}
}


/*!
	\fn SmallWidget::act( int value )
	actualize link
*/
void SmallWidget::act( int value )
{
	if( value >= 0 )
	{
		linkBar->setValue( value );
		if( ! isCard )
		{
			isCard = true;
		}
	}
	else if( isCard )
	{
		isCard = false;
		hide();
	}
	
}
