/***
* Author: Juergen Heinemann http://www.hjcms.de, (C) 2007-2008
* Copyright: See COPYING file that comes with this distribution
**/

/* QtCore */
#include <QtCore/QObject>
#include <QtCore/QCoreApplication>
#include <QtCore/QLocale>
#include <QtCore/QTextCodec>
#include <QtCore/QStringList>
#include <QtCore/QLibraryInfo>


/* KDE */
#include <KDE/KApplication>
#include <KDE/KLocale>
#include <KDE/KAboutData>
#include <KDE/KCmdLineArgs>
#include <KDE/KMessageBox>

/* QtGui */
#include <QtGui/QX11Info>
#include <QtGui/QSystemTrayIcon>

#include "config.h"
#include "settings.h"
#include "qx11grab.h"

int main ( int argc, char *argv[] )
{
  KAboutData aboutData ( "kx11grab", 0, ki18n ( "X11Grabber" ), KX11GRAB_VERSION,
                         ki18n ( "X11 Window Grabber" ),
                         KAboutData::License_GPL, ki18n ( "(c) 2007-2009" ),
                         ki18n ( "a systray program that uses ffmpeg for recording x11 desktop windows" ),
                         "http://qx11grab.hjcms.de","nospam@hjcms.de" );

  KCmdLineArgs::init( argc, argv, &aboutData );
  KApplication app;
  app.setApplicationName ( "kx11grab" );
  app.setApplicationVersion ( KX11GRAB_VERSION );
  app.setOrganizationDomain ( "hjcms.de" );

  if ( ! QSystemTrayIcon::isSystemTrayAvailable() )
  {
    KMessageBox::error ( 0, "Systray", i18n( "I couldn't detect any system tray." ) );
    return EXIT_FAILURE;
  }

  KApplication::setQuitOnLastWindowClosed ( false );
  QTextCodec::setCodecForLocale ( QTextCodec::codecForName ( "UTF-8" ) );



  Settings *m_Settings = new Settings ( &app );

  QX11Grab grab ( m_Settings );

  if ( m_Settings->getBool ( "startMinimized" ) )
    grab.hide();
  else
    grab.show();

  return app.exec();
}
