/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <kprinter.h>
#include <klocale.h>
#include "configuration.h"
#include "printdlgpage.h"
#include "printdlg.h"

PrintDlgPage::PrintDlgPage(KPrinter* prn, QSize cells, QWidget* parent, const char* name)
  : KPrintDialogPage(parent, name),
    m_printer(prn),
    m_gridSize(cells),
    m_dlg(new PrintDlgUI(this))
{
  setTitle(i18n("KXStitch Print Options"));
}

void PrintDlgPage::getOptions(QMap<QString,QString>& opts, bool)
{
  if (m_dlg->Print_SetDefault->isChecked())
  {
    KXSConfig().Print_FrontPage = m_dlg->Print_FrontPage->isChecked();
    KXSConfig().Print_Instructions = m_dlg->Print_Instructions->isChecked();
    KXSConfig().Print_Pattern = m_dlg->Print_Pattern->isChecked();
    KXSConfig().Print_SquaresInch = m_dlg->Print_SquaresInch->value(); // TODO modify to use users preferred units
    KXSConfig().Print_SpillOver = m_dlg->Print_SpillOver->value();
    KXSConfig().Print_FitSingle = m_dlg->Print_FitSingle->isChecked();
    KXSConfig().Print_GridLines = m_dlg->Print_GridLines->isChecked();
    KXSConfig().Print_SelectedArea = m_dlg->Print_SelectedArea->isChecked();
    KXSConfig().Print_StitchesAs = m_dlg->Print_StitchesAs->currentText();
    KXSConfig().Print_BackstitchesAs = m_dlg->Print_BackstitchesAs->currentText();
    KXSConfig().Print_ColorKey = m_dlg->Print_ColorKey->isChecked();
    KXSConfig().Print_FlossUsage = m_dlg->Print_FlossUsage->isChecked();
    KXSConfig().Print_StitchCount = m_dlg->Print_StitchCount->isChecked();
    KXSConfig().Print_CombineFractionals = m_dlg->Print_CombineFractionals->isChecked();
    KXSConfig().Print_SeperateBackstitching = m_dlg->Print_SeperateBackstitching->isChecked();
    KXSConfig().Print_StitchTotals = m_dlg->Print_StitchTotals->isChecked();
    KXSConfig().Print_StitchSummary = m_dlg->Print_StitchSummary->isChecked();
    KXSConfig().writeSettings();
  }
  opts["kde-kxstitch-frontpage"] = (m_dlg->Print_FrontPage->isChecked() ? "true" : "false");
  opts["kde-kxstitch-instructions"] = (m_dlg->Print_Instructions->isChecked() ? "true" : "false");
  opts["kde-kxstitch-pattern"] = (m_dlg->Print_Pattern->isChecked() ? "true" : "false");
  opts["kde-kxstitch-squaresinch"] = QString("%1").arg(m_dlg->Print_SquaresInch->value());
  opts["kde-kxstitch-spillover"] = QString("%1").arg(m_dlg->Print_SpillOver->value());
  opts["kde-kxstitch-fitsingle"] = (m_dlg->Print_FitSingle->isChecked() ? "true" : "false");
  opts["kde-kxstitch-gridlines"] = (m_dlg->Print_GridLines->isChecked() ? "true" : "false");
  opts["kde-kxstitch-selectedarea"] = (m_dlg->Print_SelectedArea->isChecked() ? "true" : "false");
  opts["kde-kxstitch-stitches"] = m_dlg->Print_StitchesAs->currentText();
  opts["kde-kxstitch-backstitches"] = m_dlg->Print_BackstitchesAs->currentText();
  opts["kde-kxstitch-colorkey"] = (m_dlg->Print_ColorKey->isChecked() ? "true" : "false");
  opts["kde-kxstitch-flossusage"] = (m_dlg->Print_FlossUsage->isChecked() ? "true" : "false");
  opts["kde-kxstitch-stitchcount"] = (m_dlg->Print_StitchCount->isChecked() ? "true" : "false");
  opts["kde-kxstitch-combinefractionals"] = (m_dlg->Print_CombineFractionals->isChecked() ? "true" : "false");
  opts["kde-kxstitch-seperatebackstitching"] = (m_dlg->Print_SeperateBackstitching->isChecked() ? "true" : "false");
  opts["kde-kxstitch-stitchtotals"] = (m_dlg->Print_StitchTotals->isChecked() ? "true" : "false");
  opts["kde-kxstitch-stitchsummary"] = (m_dlg->Print_StitchSummary->isChecked() ? "true" : "false");
}

void PrintDlgPage::setOptions(const QMap<QString,QString>& opts)
{
  m_dlg->Print_FrontPage->setChecked(opts.contains("kde-kxstitch-frontpage")?((opts["kde-kxstitch-frontpage"] == "true")?true:false):KXSConfig().Print_FrontPage);
  m_dlg->Print_Instructions->setChecked(opts.contains("kde-kxstitch-instructions")?((opts["kde-kxstitch-instructions"] == "true")?true:false):KXSConfig().Print_Instructions);
  m_dlg->Print_Pattern->setChecked(opts.contains("kde-kxstitch-pattern")?((opts["kde-kxstitch-pattern"] == "true")?true:false):KXSConfig().Print_Pattern);
  m_dlg->Print_SquaresInch->setValue(opts.contains("kde-kxstitch-squaresinch")?opts["kde-kxstitch-squaresinch"].toInt():KXSConfig().Print_SquaresInch);
  m_dlg->Print_SpillOver->setValue(opts.contains("kde-kxstitch-spillover")?opts["kde-kxstitch-spillover"].toInt():KXSConfig().Print_SpillOver);
  m_dlg->Print_FitSingle->setChecked(opts.contains("kde-kxstitch-fitsingle")?((opts["kde-kxstitch-fitsingle"] == "true")?true:false):KXSConfig().Print_FitSingle);
  m_dlg->Print_GridLines->setChecked(opts.contains("kde-kxstitch-gridlines")?((opts["kde-kxstitch-gridlines"] == "true")?true:false):KXSConfig().Print_GridLines);
  m_dlg->Print_SelectedArea->setChecked(opts.contains("kde-kxstitch-selectedarea")?((opts["kde-kxstitch-selectedarea"] == "true")?true:false):KXSConfig().Print_SelectedArea);
  Configuration::setComboBoxItem(m_dlg->Print_StitchesAs,opts.contains("kde-kxstitch-stitches")?opts["kde-kxstitch-stitches"]:KXSConfig().Print_StitchesAs);
  Configuration::setComboBoxItem(m_dlg->Print_BackstitchesAs,opts.contains("kde-kxstitch-backstitches")?opts["kde-kxstitch-backstitches"]:KXSConfig().Print_BackstitchesAs);
  m_dlg->Print_ColorKey->setChecked(opts.contains("kde-kxstitch-colorkey")?((opts["kde-kxstitch-colorkey"] == "true")?true:false):KXSConfig().Print_ColorKey);
  m_dlg->Print_FlossUsage->setChecked(opts.contains("kde-kxstitch-flossusage")?((opts["kde-kxstitch-flossusage"] == "true")?true:false):KXSConfig().Print_FlossUsage);
  m_dlg->Print_StitchCount->setChecked(opts.contains("kde-kxstitch-stitchcount")?((opts["kde-kxstitch-stitchcount"] == "true")?true:false):KXSConfig().Print_StitchCount);
  m_dlg->Print_CombineFractionals->setChecked(opts.contains("kde-kxstitch-combinefractionals")?((opts["kde-kxstitch-combinefractionals"] == "true")?true:false):KXSConfig().Print_CombineFractionals);
  m_dlg->Print_SeperateBackstitching->setChecked(opts.contains("kde-kxstitch-seperatebackstitching")?((opts["kde-kxstitch-seperatebackstitching"] == "true")?true:false):KXSConfig().Print_SeperateBackstitching);
  m_dlg->Print_StitchTotals->setChecked(opts.contains("kde-kxstitch-stitchtotals")?((opts["kde-kxstitch-stitchtotals"] == "true")?true:false):KXSConfig().Print_StitchTotals);
  m_dlg->Print_StitchSummary->setChecked(opts.contains("kde-kxstitch-stitchsummary")?((opts["kde-kxstitch-stitchsummary"] == "true")?true:false):KXSConfig().Print_StitchSummary);
}

bool PrintDlgPage::isValid(QString&)
{
/*  TODO check values of the dialog box are sane.
    For now just return TRUE.
  */
  return true;
}

QSize PrintDlgPage::minimumSizeHint() const
{
  return m_dlg->size();
}
