/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef SCHEMEMANAGER_H
#define SCHEMEMANAGER_H

#include <qptrlist.h>
#include <qstringlist.h>
#include "flossscheme.h"

/** Manages the global and user specific schemes.
    Schemes are stored as XML and loaded at application startup.
    The scheme list can be refreshed if a user stores a new scheme
    @author Stephen P. Allewell
  */
class SchemeManager
{
public:
  SchemeManager();
/** Create a new scheme
    @return Pointer to the new FlossScheme, will return NULL if
    a scheme already exists with this name, or if it could not
    be created.
    @param schemeName The name of the scheme to create
  */
  FlossScheme* createScheme(QString schemeName);
/** Read a scheme file
    @return Pointer to the FlossScheme read,
    will return NULL if the read failed or a scheme
    has previously been read by this name, ie if a calibrated
    scheme was read first.
    @param name The name of the file (scheme) to be read.
  */
  FlossScheme* readScheme(QString name);
/** write the scheme to a user writable directory.
    @return TRUE if successful, FALSE if no writable directory found.
    @param name The name of the scheme to be written.
  */
  bool writeScheme(QString name);
/** Get a list of the currently loaded scheme names.
    @return @ref QStringList containing the names of the avialable schemes.
  */
  QStringList schemes();
/** Get a pointer to a FlossScheme
    @return pointer to the FlossScheme,
    will return NULL if the scheme is not available.
    @param name The name of the scheme.
  */
  FlossScheme* scheme(QString name);
/** reload schemes
  */
  void refresh();

private:
  typedef QMap<QString,QColor>  CalibratedColor;
  QPtrList<FlossScheme>         m_flossSchemes;
};

#endif
