/***************************************************************************
 *
 *  $Id: kzenprogressdialog.cpp,v 1.9 2005/07/01 17:31:52 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <qlayout.h>
#include <qvbox.h>
#include <qapplication.h>
#include <qheader.h>

#include <kiconloader.h>
#include <klocale.h>

#include "kzentrack.h"

#include "kzenprogressdialog.h"

KZenProgressDialog::KZenProgressDialog(QWidget *parent, const char *name)
  :KDialogBase(parent, name, true, i18n("Progress - KZenExplorer"), Cancel)
{
  makeVBoxMainWidget();
  
  fListView = new KListView(mainWidget(),"listview");
  fListView->addColumn("",10);
  fListView->setColumnWidthMode(0,QListView::Maximum);
  fListView->addColumn(i18n("Artist"),200);
  fListView->setColumnWidthMode(1,QListView::Maximum);
  fListView->addColumn(i18n("Title"),200);
  fListView->setColumnWidthMode(2,QListView::Maximum);
  fListView->addColumn(i18n("Progress"),100);
  fListView->setColumnWidthMode(3,QListView::Maximum);
  fListView->setColumnAlignment(3,Qt::AlignRight);
  fListView->setSorting(-1);
  fListView->setAllColumnsShowFocus(true);
  fListView->setResizePolicy(QScrollView::AutoOneFit);
  fListView->setResizeMode(QListView::LastColumn);

  fCount = 0;
}

KZenProgressDialog::~KZenProgressDialog()
{

}

void KZenProgressDialog::slotCancel()
{
  KListViewItem * item = (KListViewItem*) fListView->firstChild();
  while ((item = (KListViewItem*) item->nextSibling())) {
    item->setText(3,i18n("Cancelled"));
  }
  
  emit cancelRequest(true);
}

void KZenProgressDialog::addTrack(KZenTrack * track, bool upload)
{
  KListViewItem * item = (KListViewItem*) fListView->lastItem();
  
  KListViewItem * newitem = new KListViewItem(fListView,item);
  if (upload) {
    newitem->setPixmap(0, UserIcon("upload", 16));
  } else {
    newitem->setPixmap(0, UserIcon("download", 16));
  }
  newitem->setText(1,track->getArtist());
  newitem->setText(2,track->getTitle());
  newitem->setText(3,"0 %");

  fCount++;
  
  fListView->adjustSize();
  adjustSize();

  if (fCount>0) show();
}

void KZenProgressDialog::removeFirst()
{
  KListViewItem * item = (KListViewItem*) fListView->firstChild();
  if (item) {
    delete item;
    fCount--;
  }

  if (fCount==0) {
    hide();
    emit cancelRequest(false);
  }
}

void KZenProgressDialog::refresh(int percentage)
{
  KListViewItem * item = (KListViewItem*) fListView->firstChild();
  if (item) {
    item->setSelected(true);
    QString temp;
    temp.setNum(percentage);
    temp += " %";
    item->setText(3,temp);
  }
  if (percentage==100) {
    removeFirst();
  }
}

#include "kzenprogressdialog.moc"
