/***************************************************************************
 *
 *  $Id: kzentageditor.cpp,v 1.9 2005/06/02 07:09:01 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qvariant.h>
#include <kcompletion.h>
#include <iostream>
#include <qstring.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <klineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kdialog.h>
#include <klocale.h>
#include <kpushbutton.h>

#include <id3v1genres.h>

#include "kzenmediafiles.h"
#include "kzenratingwidget.h"
#include "kzencategories.h"
#include "kzencategorydialog.h"
#include "kzengenre.h"

#include "kzentageditor.h"

KZenTagEditor::KZenTagEditor(QWidget* parent, const char* name)
  :KDialogBase(parent, name, true, i18n("Tag Editor - KZenExplorer"), Ok|Cancel)
{
  makeVBoxMainWidget();
  
  QWidget * privateLayoutWidget = new QWidget(mainWidget(), "privateLayoutWidget");
  fTopLayout = new QHBoxLayout(privateLayoutWidget, 11, 6, "TopLayout"); 
  
  fGridLayout = new QGridLayout(0, 1, 1, 0, 6, "GridLayout"); 
  
  fArtistCombo = new KComboBox(false, privateLayoutWidget, "fArtistCombo");
  fArtistCombo->setEditable(true);
  fArtistCombo->setAutoCompletion(true);
  fArtistCombo->setDuplicatesEnabled(false);
  fArtistCombo->setProperty("urlDropsEnabled",QVariant(false,0));
    
  fGridLayout->addMultiCellWidget(fArtistCombo, 0, 0, 1, 9);

  fRatingInput = new KZenRatingWidget(privateLayoutWidget, "fRatingInput");

  fGridLayout->addWidget(fRatingInput, 3, 9);
  fSpacer1 = new QSpacerItem(21, 21, QSizePolicy::Fixed, QSizePolicy::Minimum);
  fGridLayout->addItem(fSpacer1, 3, 3);

  fAlbumCombo = new KComboBox(false, privateLayoutWidget, "fAlbumCombo");
  fAlbumCombo->setEditable(true);
  fAlbumCombo->setAutoCompletion(true);
  fAlbumCombo->setDuplicatesEnabled(false);
  fAlbumCombo->setProperty("urlDropsEnabled", QVariant(false, 0));

  fGridLayout->addMultiCellWidget(fAlbumCombo, 1, 1, 1, 9);
  
  fCategoryLabel = new QLabel(i18n("none"), privateLayoutWidget, "fCategoryPush");

  fGridLayout->addMultiCellWidget(fCategoryLabel, 5, 5, 1, 9);

  fTitleCheck = new QCheckBox(privateLayoutWidget, "fTitleCheck");

  fGridLayout->addWidget(fTitleCheck, 2, 10);

  fArtistLabel = new QLabel(privateLayoutWidget, "fArtistLabel");

  fGridLayout->addWidget(fArtistLabel, 0, 0);

  fTrackLabel = new QLabel(privateLayoutWidget, "fTrackLabel");

  fGridLayout->addWidget(fTrackLabel, 3, 0);

  fYearEdit = new KIntSpinBox(privateLayoutWidget, "fYearEdit");
  fYearEdit->setMaxValue(2100);
  fYearEdit->setMinValue(1900);

  fGridLayout->addWidget(fYearEdit, 3, 5);

  fYearCheck = new QCheckBox(privateLayoutWidget, "fYearCheck");

  fGridLayout->addWidget(fYearCheck, 3, 6);

  fAlbumLabel = new QLabel(privateLayoutWidget, "fAlbumLabel");

  fGridLayout->addWidget(fAlbumLabel, 1, 0);

  fTitleLabel = new QLabel(privateLayoutWidget, "fTitleLabel");

  fGridLayout->addWidget(fTitleLabel, 2, 0);

  fYearLabel = new QLabel(privateLayoutWidget, "fYearLabel");

  fGridLayout->addWidget(fYearLabel, 3, 4);

  fCategoryPush = new KPushButton(i18n("Category"), privateLayoutWidget, "fCategoryPush");
  fGridLayout->addWidget(fCategoryPush, 5, 0);

  fGenreCheck = new QCheckBox(privateLayoutWidget, "fGenreCheck");

  fGridLayout->addWidget(fGenreCheck, 4, 10);
  fSpacer2 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
  fGridLayout->addItem(fSpacer2 , 3, 7);

  fTrackEdit = new KIntSpinBox(privateLayoutWidget, "fTrackEdit");

  fGridLayout->addWidget(fTrackEdit, 3, 1);

  fRatingCheck = new QCheckBox(privateLayoutWidget, "fRatingCheck");

  fGridLayout->addWidget(fRatingCheck, 3, 10);

  fRatingLabel = new QLabel(privateLayoutWidget, "fRatingLabel");

  fGridLayout->addWidget(fRatingLabel, 3, 8);

  fCategoryLabel = new QLabel(privateLayoutWidget, "fCategoryLabel");
  fGridLayout->addMultiCellWidget(fCategoryLabel, 5, 5, 1, 9);

  fCategoryCheck = new QCheckBox(privateLayoutWidget, "fCategoryCheck");
  fGridLayout->addWidget(fCategoryCheck, 5, 10);

  fGenreCombo = new KComboBox(false, privateLayoutWidget, "fGenreCombo");
  fGenreCombo->setEditable(true);
  fGenreCombo->setAutoCompletion(true);
  fGenreCombo->setProperty("urlDropsEnabled", QVariant(false, 0));

  fGridLayout->addMultiCellWidget(fGenreCombo, 4, 4, 1, 9);

  fGenreLabel = new QLabel(privateLayoutWidget, "fGenreLabel");

  fGridLayout->addWidget(fGenreLabel, 4, 0);

  fTitleEdit = new KLineEdit(privateLayoutWidget, "fTitleEdit");

  fGridLayout->addMultiCellWidget(fTitleEdit, 2, 2, 1, 9);
  
  fTrackCheck = new QCheckBox(privateLayoutWidget, "fTrackCheck");

  fGridLayout->addWidget(fTrackCheck, 3, 2);

  fArtistCheck = new QCheckBox(privateLayoutWidget, "fArtistCheck");

  fGridLayout->addWidget(fArtistCheck, 0, 10);

  fAlbumCheck = new QCheckBox(privateLayoutWidget, "fAlbumCheck");

  fGridLayout->addWidget(fAlbumCheck, 1, 10);
  fTopLayout->addLayout(fGridLayout);

  languageChange();

  // signals and slots connections
  connect(fArtistCheck, SIGNAL(clicked()), this, SLOT(slotArtistCheck_clicked()));
  connect(fAlbumCheck, SIGNAL(clicked()), this, SLOT(slotAlbumCheck_clicked()));
  connect(fTitleCheck, SIGNAL(clicked()), this, SLOT(slotTitleCheck_clicked()));
  connect(fGenreCheck, SIGNAL(clicked()), this, SLOT(slotGenreCheck_clicked()));
  connect(fTrackCheck, SIGNAL(clicked()), this, SLOT(slotTrackCheck_clicked()));
  connect(fYearCheck, SIGNAL(clicked()), this, SLOT(slotYearCheck_clicked()));
  connect(fRatingCheck, SIGNAL(clicked()), this, SLOT(slotRatingCheck_clicked()));
  connect(fCategoryCheck, SIGNAL(clicked()), this, SLOT(slotCategoryCheck_clicked()));
  connect(fCategoryPush, SIGNAL(clicked()), this, SLOT(slotSelectCategory()));
}

KZenTagEditor::~KZenTagEditor()
{
  
}

void KZenTagEditor::languageChange()
{
  setCaption(i18n("Tag Editor - KZenExplorer"));
  fTitleCheck->setText(QString::null);
  fArtistLabel->setText(i18n("Artist"));
  fTrackLabel->setText(i18n("Track"));
  fYearCheck->setText(QString::null);
  fAlbumLabel->setText(i18n("Album"));
  fTitleLabel->setText(i18n("Title"));
  fYearLabel->setText(i18n("Year"));
  fCategoryLabel->setText(i18n("Category"));
  fGenreCheck->setText(QString::null);
  fRatingCheck->setText(QString::null);
  fRatingLabel->setText(i18n("Rating"));
  fCategoryCheck->setText(QString::null);
  fGenreLabel->setText(i18n("Genre"));
  fTrackCheck->setText(QString::null);
  fArtistCheck->setText(QString::null);
  fAlbumCheck->setText(QString::null);
}

void KZenTagEditor::setTrackList(QPtrList<KZenTrackItem> & tracks)
{
  KZenTrack * track;
  QString artist;
  QString album;
  QString title;
  QString genre;
  uint tracknum = 0;
  uint year = 0;
  uint rating = 0;
  for (uint i=0;i<tracks.count();i++) {
    track = tracks.at(i)->getTrack();
    if (i == 0) {
      artist = track->getArtist();
      album = track->getAlbum();
      title = track->getTitle();
      genre = track->getGenre();
      tracknum = track->getTrackNumber();
      year = track->getYear();
      rating = track->getRating();
      fCategories = track->getCategories();
      
      fArtistCheck->setChecked(true);
      fArtistCheck->hide();
      fArtistCombo->setEnabled(true);
      fArtistCombo->setCurrentText(artist);
	    
      fAlbumCheck->setChecked(true);
      fAlbumCheck->hide();
      fAlbumCombo->setEnabled(true);
      fAlbumCombo->setCurrentText(album);
	    
      fTitleCheck->setChecked(true);
      fTitleCheck->hide();
      fTitleEdit->setEnabled(true);
      fTitleEdit->setText(title);
	    
      fGenreCheck->setChecked(true);
      fGenreCheck->hide();
      fGenreCombo->setEnabled(true);
      fGenreCombo->setCurrentText(genre);
	    
      fTrackCheck->setChecked(true);
      fTrackCheck->hide();
      fTrackEdit->setEnabled(true);
      fTrackEdit->setValue(tracknum);
	    
      fYearCheck->setChecked(true);
      fYearCheck->hide();
      fYearEdit->setEnabled(true);
      fYearEdit->setValue(year);
	    
      fRatingCheck->setChecked(true);
      fRatingCheck->hide();
      fRatingInput->setEnabled(true);
      fRatingInput->setValue(rating);
	    
      fCategoryCheck->setChecked(true);
      fCategoryCheck->hide();
      fCategoryPush->setEnabled(true);
      QString t = "";
      for (uint i=0;i<fCategories.size();i++) {
	if (fCategories[i]) {
	  if (t.length()>0) t += ", ";
	  t += gCategories->category(i);
	}
      }
      fCategoryLabel->setText(t);
    }
	
    if (artist != track->getArtist()) {
      fArtistCheck->setChecked(false);
      fArtistCheck->show();
      fArtistCombo->setEnabled(false);
      fArtistCombo->setCurrentText("");
    }
    if (album != track->getAlbum()) {
      fAlbumCheck->setChecked(false);
      fAlbumCheck->show();
      fAlbumCombo->setEnabled(false);
      fAlbumCombo->setCurrentText("");
    }
    if (title != track->getTitle()) {
      fTitleCheck->setChecked(false);
      fTitleCheck->show();
      fTitleEdit->setEnabled(false);
      fTitleEdit->setText("");
    }
    if (genre != track->getGenre()) {
      fGenreCheck->setChecked(false);
      fGenreCheck->show();
      fGenreCombo->setEnabled(false);
      fGenreCombo->setCurrentText("");
    }
    if (tracknum != track->getTrackNumber()) {
      fTrackCheck->setChecked(false);
      fTrackCheck->show();
      fTrackEdit->setEnabled(false);
      fTrackEdit->setValue(0);
    }
    if (year != track->getYear()) {
      fYearCheck->setChecked(false);
      fYearCheck->show();
      fYearEdit->setEnabled(false);
      fYearEdit->setValue(0);
    }
    if (rating != track->getRating()) {
      fRatingCheck->setChecked(false);
      fRatingCheck->show();
      fRatingInput->setEnabled(false);
      fRatingInput->setValue(0);
    }
    if (fCategories != track->getCategories()) {
      fCategoryCheck->setChecked(false);
      fCategoryCheck->show();
      fCategoryPush->setEnabled(false);
      fCategoryLabel->setText("");
      fCategories.resize(0);
    }
  }
}

void KZenTagEditor::setup(QPtrList<KZenTrack> * tracks)
{
  KZenTrack * track;
  for (uint i=0;i<tracks->count();i++) {
    track = tracks->at(i);
    fArtistCombo->insertItem(track->getArtist());
    fAlbumCombo->insertItem(track->getAlbum());
  }
  
  for (int i=0;i<fArtistCombo->count();i++) {
    QString artist = fArtistCombo->text(i);
    fArtistCombo->completionObject()->addItem(artist);
  }
    
  for (int i=0;i<fAlbumCombo->count();i++) {
    QString album = fAlbumCombo->text(i);
    fAlbumCombo->completionObject()->addItem(album);
  }

  TagLib::StringList genres = TagLib::ID3v1::genreList();
  QString genre;
  for (uint g=0;g<genres.size();g++) {
    genre = TStringToQString(genres[g]);
    fGenreCombo->insertItem(genre);
    fGenreCombo->completionObject()->addItem(genre);  

    if (!KZenGenre::getGenres().contains(genre)) {
      KZenGenre::getGenres().append(genre);
      KZenGenre::getGenres().sort();
    }
  }
}

bool KZenTagEditor::isArtistChecked()
{
  return fArtistCheck->isChecked();
}

bool KZenTagEditor::isAlbumChecked()
{
  return fAlbumCheck->isChecked();
}

bool KZenTagEditor::isTitleChecked()
{
  return fTitleCheck->isChecked();
}

bool KZenTagEditor::isGenreChecked()
{
  return fGenreCheck->isChecked();
}

bool KZenTagEditor::isTrackNumberChecked()
{
  return fTrackCheck->isChecked();
}

bool KZenTagEditor::isYearChecked()
{
  return fYearCheck->isChecked();
}

bool KZenTagEditor::isRatingChecked()
{
  return fRatingCheck->isChecked();
}

bool KZenTagEditor::isCategoryChecked()
{
  return fCategoryCheck->isChecked();
}

void KZenTagEditor::checkAll(bool check)
{
  fArtistCheck->setChecked(check);
  fAlbumCheck->setChecked(check);
  fTitleCheck->setChecked(check);
  fGenreCheck->setChecked(check);
  fTrackCheck->setChecked(check);
  fYearCheck->setChecked(check);
  fRatingCheck->setChecked(check);
  fCategoryCheck->setChecked(check);
}

const char * KZenTagEditor::getArtist()
{
  return fArtistCombo->currentText().stripWhiteSpace();
}

const char * KZenTagEditor::getAlbum()
{
  return fAlbumCombo->currentText().stripWhiteSpace();
}

const char * KZenTagEditor::getTitle()
{
  return fTitleEdit->text().stripWhiteSpace();
}

const char * KZenTagEditor::getGenre()
{	
  return fGenreCombo->currentText().stripWhiteSpace();
}

uint KZenTagEditor::getTrackNumber()
{
  return fTrackEdit->value();
}

uint KZenTagEditor::getYear()
{
  return fYearEdit->value();
}

uint KZenTagEditor::getRating()
{
  return fRatingInput->value();
}

const QBitArray & KZenTagEditor::getCategories()
{
  return fCategories;
}

void KZenTagEditor::slotArtistCheck_clicked()
{
  if (fArtistCheck->isChecked()) {
    fArtistCombo->setEnabled(true);
  } else {
    fArtistCombo->setEnabled(false);
  }
}

void KZenTagEditor::slotAlbumCheck_clicked()
{
  if (fAlbumCheck->isChecked()) {
    fAlbumCombo->setEnabled(true);
  } else {
    fAlbumCombo->setEnabled(false);
  }
}

void KZenTagEditor::slotTitleCheck_clicked()
{
  if (fTitleCheck->isChecked()) {
    fTitleEdit->setEnabled(true);
  } else {
    fTitleEdit->setEnabled(false);
  }
}

void KZenTagEditor::slotGenreCheck_clicked()
{
  if (fGenreCheck->isChecked()) {
    fGenreCombo->setEnabled(true);
  } else {
    fGenreCombo->setEnabled(false);
  }
}

void KZenTagEditor::slotTrackCheck_clicked()
{
  if (fTrackCheck->isChecked()) {
    fTrackEdit->setEnabled(true);
  } else {
    fTrackEdit->setEnabled(false);
  }
}

void KZenTagEditor::slotYearCheck_clicked()
{
  if (fYearCheck->isChecked()) {
    fYearEdit->setEnabled(true);
  } else {
    fYearEdit->setEnabled(false);
  }
}

void KZenTagEditor::slotRatingCheck_clicked()
{
  if (fRatingCheck->isChecked()) {
    fRatingInput->setEnabled(true);
  } else {
    fRatingInput->setEnabled(false);
  }
}

void KZenTagEditor::slotCategoryCheck_clicked()
{
  if (fCategoryCheck->isChecked()) {
    fCategoryPush->setEnabled(true);
  } else {
    fCategoryPush->setEnabled(false);
  }
}

void KZenTagEditor::slotSelectCategory()
{
  KZenCategoryDialog dlg;
  for (uint i=0;i<fCategories.size();i++) {
    dlg.setChecked(i,fCategories[i]);
  }

  if (dlg.exec()==QDialog::Accepted) {
    fCategories.resize(dlg.count());
    for (uint i=0;i<dlg.count();i++) {
      fCategories[i] = dlg.isChecked(i);
    }
    
    QString t = "";
    for (uint i=0;i<fCategories.size();i++) {
      if (fCategories[i]) {
	if (t.length()>0) t += ", ";
	t += gCategories->category(i);
      }
    }
    fCategoryLabel->setText(t);
  }
}

void KZenTagEditor::accept()
{
  QString artist = fArtistCombo->currentText().stripWhiteSpace();
  fArtistCombo->insertItem(artist);
  fArtistCombo->completionObject()->addItem(artist);
  
  QString album = fAlbumCombo->currentText().stripWhiteSpace();
  fAlbumCombo->insertItem(artist);
  fAlbumCombo->completionObject()->addItem(artist);
  
  QString genre = fGenreCombo->currentText().stripWhiteSpace();
  fGenreCombo->insertItem(genre);
  fGenreCombo->completionObject()->addItem(genre);
  
  QDialog::accept();
}

#include "kzentageditor.moc"
