.TH lash_wrap 1 "January 27, 2008" "Lash-Wrap 1.0.1"
.SH NAME
lash_wrap \- a small LASH wrapper for non-LASH apps
.SH SYNOPSIS
lash_wrap [options] \fB\-\-\fR [commandline to start the wrapped app]
.SH DESCRIPTION
Lash-Wrap is a small helper application that serves as a "proxy" between an un-LASH'ified app and the LASH Audio Session Handler.

Lash-Wrap enables automatic Jack and Alsa connection handling/restoring by passing the wrapped application's Jack and Alsa id's to the LASH server. Next time the LASH project is loaded the connections are restored like when dealing with a native LASH client.

Restoring files/projects is also possible if the wrapped application has a command line option to load files/projects. The load option has to be given when the application is first brought to a LASH project with Lash-Wrap even though the file/project wouldn't exist yet. Saving has to be done manually in the wrapped app (this is a good thing to remember before closing the LASH session). To imitate a real LASH client the project/file should be saved to the LASH project directory.
.SH OPTIONS
.TP
\fB\-h\fR [ \fB\-\-help\fR ]
produce help message
.TP
\fB\-v\fR [ \fB\-\-version\fR ]
show version
.TP
\fB\-l\fR [ \fB\-\-lash\-name\fR ] arg
Set LASH client name.
.TP
\fB\-j\fR [ \fB\-\-jack\-name\fR ] arg
Set jack client name.
.TP
\fB\-a\fR [ \fB\-\-alsa\-name\fR ] arg
Set alsa seq client name.
.TP
\fB\-i\fR [ \fB\-\-alsa\-id\fR ] arg
Set alsa seq client id.
.TP
\fB\-d\fR [ \fB\-\-jack\-name\-send\-delay\fR ] arg
Set the delay time in seconds until the jack
client name is sent after lash_wrap found a
corresponding port (default 5(s)).
.TP
\fB\-t\fR [ \fB\-\-search\-timeout\fR ] arg
Set the timeout time in seconds until lash_
wrap gives up searching for the alsa seq
id, alsa client name or jack client name
(default 30(s)). Use \fB\-1\fR for no timeout.
.TP
\fB\-s\fR [ \fB\-\-shutdown\-timeout\fR ] arg
Set the timeout time in seconds until lash_
wrap gives up waiting for the guest process
to stop. First it is sent a SIGTERM, then
the shutdown\-timeout time is waited, then a
SIGKILL is sent (default 5(s)).
.TP
\fB\-p\fR [ \fB\-\-probe\-client\-names\fR ]
Try to probe startup command with correct
Jack and/or Alsa client names and exit. Uses
a search\-timeout value of 10(s) by default.
Use \fB\-t\fR option to alter timeout. Produces
a lash_wrap command with the probed client
names as an output.
.SH EXAMPLES
.TP
Starting a LASHified Ardour with a project file:
lash_wrap \-\-jack\-name ardour \-\-alsa\-name ardour \-\- ardour2 /media/sound/ardour/foo/foo.ardour
.TP
Probing client names and startup command for Phasex (produces the command in the next example):
lash_wrap \-\-probe\-client\-names \-\- phasex
.TP
Starting a LASHified Phasex using short option names:
lash_wrap \-l phasex \-j "phasex" \-a "PHASEX Synthesizer" \-\- phasex
.SH COPYRIGHT
Copyright 2007 Florian Paul Schmidt (GPL v2)
.SH SEE ALSO
The complete documentation can be found from the README file (/usr/share/doc/lashwrap/README).
