#include "lc_global.h"
#include "system.h"

#ifdef WIN32

char* strcasestr(const char *s, const char *find)
{
	char c, sc;
	size_t len;

	if ((c = *find++) != 0)
	{
		c = tolower((unsigned char)c);
		len = strlen(find);
		do
		{
			do
			{
				if ((sc = *s++) == 0)
					return (NULL);
			} while ((char)tolower((unsigned char)sc) != c);
		} while (strncasecmp(s, find, len) != 0);
		s--;
	}
	return ((char *)s);
}

#else

char* strupr(char *string)
{
	for (char *c = string; *c; c++)
		*c = toupper(*c);

	return string;
}

char* strlwr(char *string)
{
	for (char *c = string; *c; c++)
		*c = tolower(*c);

	return string;
}

int stricmp(const char *str1, const char *str2)
{
	return strcasecmp(str1, str2);
}

#endif

void SystemUpdateAnimation(bool bAnimation, bool bAddKeys)
{
}

void SystemUpdatePlay(bool play, bool stop)
{
}

void SystemPieceComboAdd(char* name)
{
}
