/* Editor Settings: expandtabs and use 4 spaces for indentation
* ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
* -*- mode: c, c-basic-offset: 4 -*- */

/*
 * Copyright (C) Centeris Corporation 2004-2007
 * Copyright (C) Likewise Software    2007-2008
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation; either version 2.1 of 
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>.
 */


#define INTERNAL_ONLY "An internal error has occurred. Please contact Likewise technical support."

CENTERROR_CATALOG(CENTERROR_SUCCESS)
CENTERROR_CATALOG(CENTERROR_ACCESS_DENIED)
CENTERROR_CATALOG(CENTERROR_OUT_OF_MEMORY)
CENTERROR_CATALOG(CENTERROR_INVALID_PASSWORD)
CENTERROR_CATALOG(CENTERROR_INVALID_PARAMETER)
CENTERROR_CATALOG(CENTERROR_INVALID_OPERATION)
CENTERROR_CATALOG(CENTERROR_INVALID_MESSAGE)
CENTERROR_CATALOG(CENTERROR_CONNECTION_UNAVAIL)
CENTERROR_CATALOG(CENTERROR_INVALID_GROUPNAME)
CENTERROR_CATALOG(CENTERROR_INVALID_COMPUTERNAME)
CENTERROR_CATALOG(CENTERROR_INVALID_DOMAINNAME)
CENTERROR_CATALOG(CENTERROR_INVALID_SERVICENAME)
CENTERROR_CATALOG(CENTERROR_INVALID_NETNAME)
CENTERROR_CATALOG(CENTERROR_INVALID_SHARENAME)
CENTERROR_CATALOG(CENTERROR_INVALID_PASSWORDNAME)
CENTERROR_CATALOG(CENTERROR_INVALID_VALUE)
CENTERROR_CATALOG(CENTERROR_INVALID_VALUE_TYPE)
CENTERROR_CATALOG(CENTERROR_DUP_DOMAINNAME)
CENTERROR_CATALOG(CENTERROR_NO_NETWORK)
CENTERROR_CATALOG(CENTERROR_CONNECTION_REFUSED)
CENTERROR_CATALOG(CENTERROR_CONNECTION_INVALID)
CENTERROR_CATALOG(CENTERROR_ILL_FORMED_PASSWORD)
CENTERROR_CATALOG(CENTERROR_PASSWORD_RESTRICTION)
CENTERROR_CATALOG(CENTERROR_LOGON_FAILURE)
CENTERROR_CATALOG(CENTERROR_PASSWORD_EXPIRED)
CENTERROR_CATALOG(CENTERROR_ACCOUNT_DISABLED)
CENTERROR_CATALOG(CENTERROR_BAD_TOKEN)
CENTERROR_CATALOG(CENTERROR_BAD_GUID)
CENTERROR_CATALOG(CENTERROR_NO_SUCH_DOMAIN)
CENTERROR_CATALOG(CENTERROR_DOMAIN_EXISTS)
CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAIN_JOIN_FAILED,
    
    "Unable to join domain",
    
    "Creating the computer account in Active Directory failed. Common causes are a bad administrator password, a bad OU name, or an existing computer account but not modificiation permissions.")
CENTERROR_CATALOG(CENTERROR_DOMAIN_LEAVE_FAILED)
CENTERROR_CATALOG(CENTERROR_LICENSE_INCORRECT)
CENTERROR_CATALOG(CENTERROR_LICENSE_EXPIRED)
CENTERROR_CATALOG(CENTERROR_LICENSE_ALREADY_IN_USE)
CENTERROR_CATALOG(CENTERROR_LICENSE_NOT_AVAILABLE_FOR_USE)
CENTERROR_CATALOG(CENTERROR_LICENSE_AD_NOT_PROVISIONED)
CENTERROR_CATALOG(CENTERROR_LICENSE_DUPLICATE_PROVISIONED)
CENTERROR_CATALOG(CENTERROR_LICENSE_NO_KEY_IN_DN)
CENTERROR_CATALOG(CENTERROR_CFG_INVALID_SECTION_NAME)
CENTERROR_CATALOG(CENTERROR_CFG_INVALID_NVPAIR_NAME)
CENTERROR_CATALOG(CENTERROR_CFG_SECTION_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_CFG_VALUE_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_VALUE_NOT_IN_SECTION)
CENTERROR_CATALOG(CENTERROR_CFG_INVALID_SIGNATURE)
CENTERROR_CATALOG(CENTERROR_CFG_NOT_ENOUGH_BUFFER)
CENTERROR_CATALOG(CENTERROR_REGEX_COMPILE_FAILED)
CENTERROR_CATALOG(CENTERROR_LWIAUTH_NOT_RUNNING)
CENTERROR_CATALOG(CENTERROR_NO_SUCH_PROCESS)
CENTERROR_CATALOG(CENTERROR_NO_SUCH_SYMBOL)
CENTERROR_CATALOG(CENTERROR_PTHREAD_ERROR)
CENTERROR_CATALOG_DESC(
        CENTERROR_COMMAND_FAILED,
        "Program execution failed",
        "This program attempted to run another program, but it returned a non-zero exit code"
        )
CENTERROR_CATALOG(CENTERROR_INVALID_UID)
CENTERROR_CATALOG(CENTERROR_INVALID_GID)
CENTERROR_CATALOG(CENTERROR_INVALID_FILENAME)
CENTERROR_CATALOG(CENTERROR_INVALID_OPTION_VALUE)
CENTERROR_CATALOG(CENTERROR_ABNORMAL_TERMINATION)
CENTERROR_CATALOG(CENTERROR_SED_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_SHELL_VARIABLE_UNKNOWN)
CENTERROR_CATALOG(CENTERROR_FILE_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_NOT_IMPLEMENTED)
CENTERROR_CATALOG_DESC(

    CENTERROR_INVALID_DIRECTORY,
    
    "The specified path is not a directory",
    
    INTERNAL_ONLY)
CENTERROR_CATALOG(CENTERROR_INCOMPATIBLE_LIBRARY) 

CENTERROR_CATALOG(CENTERROR_GP_SYSTEM_CALL_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_SYSTEM_RESULT_UNEXPECTED)
CENTERROR_CATALOG(CENTERROR_GP_BAD_GPT_VERSION_NUMBER)
CENTERROR_CATALOG(CENTERROR_GP_NO_PARENT_DN)
CENTERROR_CATALOG(CENTERROR_GP_INVALID_GPLINK)
CENTERROR_CATALOG(CENTERROR_GP_FILE_COPY_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_ERROR)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_GETDN_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_NO_SUCH_POLICY)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_MULTIPLE_POLICIES)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_NO_SUCH_GUID)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_FOUND_MULTIPLE_GUIDS)
CENTERROR_CATALOG(CENTERROR_GP_LDAP_NO_VALUE_FOUND)
CENTERROR_CATALOG(CENTERROR_GP_KRB5_CALL_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_GSS_CALL_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_REFRESH_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_REGPOL_UNEXPECTED_TOKEN)
CENTERROR_CATALOG(CENTERROR_GP_REGPOL_NOT_ENOUGH_DATA)
CENTERROR_CATALOG(CENTERROR_GP_REGPOL_EOF)
CENTERROR_CATALOG(CENTERROR_GP_REGPOL_INVALID_SIGNATURE)
CENTERROR_CATALOG(CENTERROR_GP_PROCESS_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_GP_XMLPARSER_CREATE_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_XMLPARSE_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_XMLPARSE_BAD_STATE)
CENTERROR_CATALOG(CENTERROR_GP_XMLPARSE_BAD_SCHEMA)
CENTERROR_CATALOG(CENTERROR_GP_XMLPARSE_BAD_DATA)
CENTERROR_CATALOG(CENTERROR_GP_XPATH_CONTEXT_INIT_ERR)
CENTERROR_CATALOG(CENTERROR_GP_XPATH_BAD_EXPRESSION)
CENTERROR_CATALOG(CENTERROR_GP_LWIDATA_NOT_INITIALIZED)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_COPY_NODE)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_ADD_NODE)
CENTERROR_CATALOG(CENTERROR_GP_FILE_OPEN_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_ADD_PROP)
CENTERROR_CATALOG(CENTERROR_GP_FILE_PARSE_ERROR)
CENTERROR_CATALOG(CENTERROR_GP_XML_PROPERTY_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_GP_XML_NO_NODE_TEXT)
CENTERROR_CATALOG(CENTERROR_GP_XML_TYPE_MISMATCH)
CENTERROR_CATALOG(CENTERROR_GP_XML_GPITEM_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_GP_XML_NODE_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_GP_GNOME_UNKNOWN_SETTING)
CENTERROR_CATALOG(CENTERROR_GP_GNOME_UNKNOWN_TYPE)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_CREATE_DOC)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_WRITE_DOC)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_CREATE_NODE)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_CREATE_CDATA)
CENTERROR_CATALOG(CENTERROR_GP_XML_FAILED_TO_SET_ATTR)
CENTERROR_CATALOG(CENTERROR_GP_UNEXPECTED_ACTION_TYPE)
CENTERROR_CATALOG(CENTERROR_GP_FAILED_TO_GET_MAC_SETTING)
CENTERROR_CATALOG(CENTERROR_GP_LOGIN_POLICY_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_LOGOUT_POLICY_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_NOT_AD_USER)
CENTERROR_CATALOG(CENTERROR_GP_FAILED_TO_GET_DOMAIN_SID)
CENTERROR_CATALOG(CENTERROR_GP_NO_DNS_RECORDS)
CENTERROR_CATALOG(CENTERROR_GP_NO_SMB_KRB5_INFO)
CENTERROR_CATALOG(CENTERROR_GP_NO_SMB_KRB5_SITE_INFO)
CENTERROR_CATALOG(CENTERROR_GP_NO_SMB_KRB5_SITE_KDC_INFO)
CENTERROR_CATALOG(CENTERROR_GP_GETHOSTNAME_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_GETHOSTBYNAME_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_GETHOSTBYADDR_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_DNS_MESSAGE_REPLY_TOO_SMALL)
CENTERROR_CATALOG(CENTERROR_GP_DNS_COULD_NOT_RESOLVE_NAME)
CENTERROR_CATALOG(CENTERROR_GP_DNS_HOSTENT_NAME_INVALID)
CENTERROR_CATALOG(CENTERROR_GP_DNS_QUERY_FAILED)
CENTERROR_CATALOG(CENTERROR_GP_EVENT_LOG_NOT_AVAILABLE)

CENTERROR_CATALOG(CENTERROR_REGISTRY_OPEN_KEYDB_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_NO_SUCH_KEY)
CENTERROR_CATALOG(CENTERROR_REGISTRY_GET_CHILD_KEYS_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_REMOVE_KEY_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_REMOVE_VALUE_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_UNSUPPORTED_TYPE)
CENTERROR_CATALOG(CENTERROR_REGISTRY_UNEXPECTED_VALUE_TYPE)
CENTERROR_CATALOG(CENTERROR_REGISTRY_ADD_KEY_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_GET_KEYPATHLEN_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_GET_KEYPATH_FAILED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_ROOT_UNDEFINED)
CENTERROR_CATALOG(CENTERROR_REGISTRY_INVALID_KDB_HANDLE)
CENTERROR_CATALOG(CENTERROR_REGISTRY_INVALID_DATA_TYPE)
CENTERROR_CATALOG(CENTERROR_REGISTRY_INVALID_DATA_SIZE)

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_NON_ROOT_USER,
    
    "Current user is not root",
    
    "The requested operation must be run as root or a user "
    "with root privileges." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_INVALID_HOSTNAME,
    
    "Invalid hostname",
    
    "The current or specified hostname is invalid.  Legal hostnames "
    "must be 15 characters or less, consisting only of letters, "
    "numbers, or hyphens.  Additionally, generic names such as "
    "'localhost', 'hostname', or 'linux' are not permitted." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_SYSCONFIG_EDIT_FAIL)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_NO_ETH_ITF_CFG_FILE,

    "Network interface configuration file not found",
    
    "The configuration file for the network interface could not be "
    "located.  Please ensure that this system is supported by "
    "Likewise Identity and connected to a network." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_DHCPINFO_EDIT_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_HOSTS_EDIT_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_SET_MACHINESID_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_NETCONFIGCMD_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_DHCPRESTART_SET_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_DHCPRESTART_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_KRB5_EDIT_FAIL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_NSSWITCH_EDIT_FAIL)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_PAM_EDIT_FAIL,
    
    "Could not edit PAM configuration",
    
    "Adding Likewise Identity settings into the system PAM setup "
    "failed due to a non-standard or unsupported configuration.  "
    "Please check that your PAM configuration is correct." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_JOIN_FAILED,
    
    "Unable to join domain",
    
    "Creating the computer account in Active Directory failed. Common causes are a bad administrator password, a bad OU name, or an existing computer account but not modificiation permissions.")

CENTERROR_CATALOG_DESC( 
    
    CENTERROR_DOMAINJOIN_JOIN_TIMEDOUT,
    
    "Domain join timed out",
    
    "A network operation timed out while attemping to join the domain.  "
    "Please ensure that the domain controller is resolvable through DNS, "
    "running and responsive.  Also check that firewall settings are not "
    "restricting outbound traffic." )

CENTERROR_CATALOG_DESC( 
    
    CENTERROR_DOMAINJOIN_JOIN_NO_WKGRP,
    
    "Could not identify short domain name",
    
    "The domain join appears to have succeeded but did not return "
    "the short (workgroup) name as expected." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_SMB_VALUE_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_DOMAIN_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_WORKGROUP_NOT_FOUND)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_DESCRIPTION_NOT_FOUND)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_HOSTNAME_CONTAINS_DOT,
    
    "Invalid hostname (contains dot)",
    
    "An invalid hostname was specified.  Please specify the hostname "
    "without the full domain suffix (e.g. 'example' rather than "
    "'example.domain.com'" )

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_MISSING_DAEMON,
    
    "Required daemon not found",
    
    "A required daemon (e.g. likewise-winbindd, gpagentd) could not be located "
    "on this system.  Please ensure that Likewise Identity has been "
    "completely installed and that the install completed successfully." )

CENTERROR_CATALOG_DESC( 
    
    CENTERROR_DOMAINJOIN_UNEXPECTED_ERRCODE,

    "Unrecognized error from external program",
    
    "An external program or daemon (e.g. likewise-winbindd, gpagentd) failed "
    "to run and provided an unrecognized error code." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_INCORRECT_STATUS)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_CHKCONFIG_FAILED,

    "Could not configure required service",

    "An error occurred while adding a required daemon (e.g. likewise-winbindd, "
    "gpagentd) to the set of system services started on boot.  Please "
    "ensure that your system is supported by Likewise Identity." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_UPDATERCD_FAILED,
    
    "Could not configure required service",
    
    "An error occurred while adding a required daemon (e.g. likewise-winbindd, "
    "gpagentd) to the set of system services started on boot.  Please "
    "ensure that your system is supported by Likewise Identity." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_LICENSE_ERROR)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_NO_LICENSE_KEY)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_WRONG_PRODUCT_CODE)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_WRONG_LICENSE_VERSION)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_NOT_JOINED_TO_AD)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_GPAGENTD_INCOMMUNICADO,

    "Cannot contact Likewise Identity group policy daemon",
    
    "The Likewise Identity group policy daemon cannot be conacted "
    "despite having started successfully.  Please check the daemon's "
    "logs for more information." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_BAD_LICENSE_KEY,

    "Invalid license key",

    "The provided license key is not valid.  Please ensure that a valid "
    "license has been provisioned for this system." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_INVALID_USERID,

    "Invalid username",

    "The username provided to join the computer to AD is empty. Please enter a valid username." )

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_INVALID_DOMAIN_NAME, 
    
    "Invalid domain name",

    NULL /* FIXME: add help describing valid domain names */ )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_INVALID_PASSWORD,
    
    "Invalid password",

    NULL /* FIXME: add help describing valid passwords */ )
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_FAILED_TO_LEAVE_DOMAIN)

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_UNRESOLVED_DOMAIN_NAME,
    
    "Could not resolve domain name",

    "The specified domain name could not be resolved using DNS.  "
    "Please ensure that your system is connected to the network, has a "
    "valid nameserver configuration, and that the configured nameservers "
    "are running and responsive.  Also check that any configured firewall "
    "is not restricting DNS traffic." )

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_INVALID_LOG_LEVEL, 

    "Invalid log level",
    
    "The specified log level is unrecognized.  Valid levels are "
    "error, warning, info, and verbose." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_FAILED_SET_HOSTNAME)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_LISTSVCS_FAILED)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_SVC_LOAD_FAILED)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_SVC_UNLOAD_FAILED)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_PREPSVC_FAILED)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_UNKNOWN_DAEMON)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_INVALID_OU,

    "Invalid organizational unit",

    NULL /* FIXME: add description of legal OU names */ )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_FAILED_KICKER_INSTALL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_FAILED_KICKER_UNINSTALL)
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_FAILED_SET_SEARCHPATH)
CENTERROR_CATALOG_DESC(

        CENTERROR_DOMAINJOIN_FAILED_REG_OPENDIR,
        
        "Unable to enable ds plugin",
        
        "The Likewise directory services plugin could not be added to the directory services search path. Most likely this is because the plugin has been disabled via the 'Directory Access' program. Please check 'Likewise Enterprise' inside of 'Directory Access'." )
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_FAILED_UNREG_OPENDIR)
CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_PAM_MISSING_SERVICE,
    
    "Phase not defined for PAM service",

    INTERNAL_ONLY )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_PAM_BAD_CONF,

    "Invalid PAM configuration",
    
    "The likewise PAM module cannot be added to the system "
    "pam.conf/pam.d because the system configuration cannot be "
    "parsed. Typically this occurs when a servce is unprotected "
    "(does not require a password to login), or an unknown PAM "
    "module is being used." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_PAM_MISSING_MODULE,
    
    "Required PAM module not found",
    
    "The pam_lwidentity module or a required system PAM module "
    "could not be found.  Please ensure that all pam modules are "
    "present in correct location and that Likewise Enterprise is "
    "completely installed." )

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_FAILED_ADMIN_PRIVS,
    
    "Insufficient privileges",
    
    "The specified Windows user does not have sufficient privileges to "
    "join systems to Active Directory.  Please try a different user or "
    "ensure that the specified user is a member of the Administrators "
    "group." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_LWINET_TIME_FAILED,

    "Could not synchronize time",

    "Unable to synchronize time with the domain controller.  "
    "Please ensure that the domain controller is running and "
    "contactable from this system." )

CENTERROR_CATALOG_DESC(

    CENTERROR_DOMAINJOIN_TIME_NOT_SET,
    
    "Could not synchronize time",
    
    "Unable to synchronize time with the domain controller.  "
    "The domain controller was successfully contacted, but "
    "updating the system time failed silently." )

CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_INVALID_FORMAT)

CENTERROR_CATALOG_DESC(
    
    CENTERROR_DOMAINJOIN_INVALID_FIREWALLCFG,
    
    "Could not parse /etc/vmware/firewall/services.xml",
    
    "Please ensure that the VMWare ESX firewall configuration "
    "file contains valid XML")
CENTERROR_CATALOG(CENTERROR_DOMAINJOIN_WARNING)

CENTERROR_CATALOG_ERRNO(E2BIG)
CENTERROR_CATALOG_ERRNO(EACCES)
CENTERROR_CATALOG_ERRNO(EADDRINUSE)
CENTERROR_CATALOG_ERRNO(EADDRNOTAVAIL)
CENTERROR_CATALOG_ERRNO(EAFNOSUPPORT)
CENTERROR_CATALOG_ERRNO(EAGAIN)
CENTERROR_CATALOG_ERRNO(EALREADY)
/*CENTERROR_CATALOG_ERRNO(EBADE)*/
CENTERROR_CATALOG_ERRNO(EBADF)
/*CENTERROR_CATALOG_ERRNO(EBADFD)*/
CENTERROR_CATALOG_ERRNO(EBADMSG)
/*CENTERROR_CATALOG_ERRNO(EBADR)*/
/*CENTERROR_CATALOG_ERRNO(EBADRQC)*/
/*CENTERROR_CATALOG_ERRNO(EBADSLT)*/
CENTERROR_CATALOG_ERRNO(EBUSY)
CENTERROR_CATALOG_ERRNO(ECANCELED)
CENTERROR_CATALOG_ERRNO(ECHILD)
/* OS X doesn't have this:
CENTERROR_CATALOG_ERRNO(ECHRNG)*/
/*CENTERROR_CATALOG_ERRNO(ECOMM)*/
CENTERROR_CATALOG_ERRNO(ECONNABORTED)
CENTERROR_CATALOG_ERRNO(ECONNREFUSED)
CENTERROR_CATALOG_ERRNO(ECONNRESET)
CENTERROR_CATALOG_ERRNO(EDEADLK)
/*CENTERROR_CATALOG_ERRNO(EDEADLOCK)*/
CENTERROR_CATALOG_ERRNO(EDESTADDRREQ)
CENTERROR_CATALOG_ERRNO(EDOM)
CENTERROR_CATALOG_ERRNO(EDQUOT)
CENTERROR_CATALOG_ERRNO(EEXIST)
CENTERROR_CATALOG_ERRNO(EFAULT)
CENTERROR_CATALOG_ERRNO(EFBIG)
CENTERROR_CATALOG_ERRNO(EHOSTDOWN)
CENTERROR_CATALOG_ERRNO(EHOSTUNREACH)
CENTERROR_CATALOG_ERRNO(EIDRM)
CENTERROR_CATALOG_ERRNO(EILSEQ)
CENTERROR_CATALOG_ERRNO(EINPROGRESS)
CENTERROR_CATALOG_ERRNO(EINTR)
CENTERROR_CATALOG_ERRNO(EINVAL)
CENTERROR_CATALOG_ERRNO(EIO)
CENTERROR_CATALOG_ERRNO(EISCONN)
CENTERROR_CATALOG_ERRNO(EISDIR)
/*CENTERROR_CATALOG_ERRNO(EISNAM)*/
/* OSX doesn't have this:
CENTERROR_CATALOG_ERRNO(EL2HLT)
CENTERROR_CATALOG_ERRNO(EL2NSYNC)
CENTERROR_CATALOG_ERRNO(EL3HLT)
CENTERROR_CATALOG_ERRNO(EL3RST)*/
/*CENTERROR_CATALOG_ERRNO(ELIBACC)*/
/*CENTERROR_CATALOG_ERRNO(ELIBBAD)*/
/*CENTERROR_CATALOG_ERRNO(ELIBMAX)*/
/*CENTERROR_CATALOG_ERRNO(ELIBSCN)*/
/*CENTERROR_CATALOG_ERRNO(ELIBEXEC)*/
CENTERROR_CATALOG_ERRNO(ELOOP)
/*CENTERROR_CATALOG_ERRNO(EMEDIUMTYPE)*/
CENTERROR_CATALOG_ERRNO(EMFILE)
CENTERROR_CATALOG_ERRNO(EMLINK)
CENTERROR_CATALOG_ERRNO(EMSGSIZE)
CENTERROR_CATALOG_ERRNO(EMULTIHOP)
CENTERROR_CATALOG_ERRNO(ENAMETOOLONG)
CENTERROR_CATALOG_ERRNO(ENETDOWN)
CENTERROR_CATALOG_ERRNO(ENETRESET)
CENTERROR_CATALOG_ERRNO(ENETUNREACH)
CENTERROR_CATALOG_ERRNO(ENFILE)
CENTERROR_CATALOG_ERRNO(ENOBUFS)
CENTERROR_CATALOG_ERRNO(ENODATA)
CENTERROR_CATALOG_ERRNO(ENODEV)
CENTERROR_CATALOG_ERRNO(ENOENT)
CENTERROR_CATALOG_ERRNO(ENOEXEC)
CENTERROR_CATALOG_ERRNO(ENOLCK)
CENTERROR_CATALOG_ERRNO(ENOLINK)
/*CENTERROR_CATALOG_ERRNO(ENOMEDIUM)*/
CENTERROR_CATALOG_ERRNO(ENOMEM)
CENTERROR_CATALOG_ERRNO(ENOMSG)
/*CENTERROR_CATALOG_ERRNO(ENONET)*/
/*CENTERROR_CATALOG_ERRNO(ENOPKG)*/
CENTERROR_CATALOG_ERRNO(ENOPROTOOPT)
CENTERROR_CATALOG_ERRNO(ENOSPC)
CENTERROR_CATALOG_ERRNO(ENOSR)
CENTERROR_CATALOG_ERRNO(ENOSTR)
CENTERROR_CATALOG_ERRNO(ENOSYS)
CENTERROR_CATALOG_ERRNO(ENOTBLK)
CENTERROR_CATALOG_ERRNO(ENOTCONN)
CENTERROR_CATALOG_ERRNO(ENOTDIR)
CENTERROR_CATALOG_ERRNO(ENOTEMPTY)
CENTERROR_CATALOG_ERRNO(ENOTSOCK)
CENTERROR_CATALOG_ERRNO(ENOTSUP)
CENTERROR_CATALOG_ERRNO(ENOTTY)
/*CENTERROR_CATALOG_ERRNO(ENOTUNIQ)*/
CENTERROR_CATALOG_ERRNO(ENXIO)
CENTERROR_CATALOG_ERRNO(EOPNOTSUPP)
CENTERROR_CATALOG_ERRNO(EOVERFLOW)
CENTERROR_CATALOG_ERRNO(EPERM)
CENTERROR_CATALOG_ERRNO(EPFNOSUPPORT)
CENTERROR_CATALOG_ERRNO(EPIPE)
CENTERROR_CATALOG_ERRNO(EPROTO)
CENTERROR_CATALOG_ERRNO(EPROTONOSUPPORT)
CENTERROR_CATALOG_ERRNO(EPROTOTYPE)
CENTERROR_CATALOG_ERRNO(ERANGE)
/*CENTERROR_CATALOG_ERRNO(EREMCHG)*/
CENTERROR_CATALOG_ERRNO(EREMOTE)
/*CENTERROR_CATALOG_ERRNO(EREMOTEIO)*/
/*CENTERROR_CATALOG_ERRNO(ERESTART)*/
CENTERROR_CATALOG_ERRNO(EROFS)
CENTERROR_CATALOG_ERRNO(ESHUTDOWN)
CENTERROR_CATALOG_ERRNO(ESPIPE)
CENTERROR_CATALOG_ERRNO(ESOCKTNOSUPPORT)
CENTERROR_CATALOG_ERRNO(ESRCH)
CENTERROR_CATALOG_ERRNO(ESTALE)
/*CENTERROR_CATALOG_ERRNO(ESTRPIPE)*/
CENTERROR_CATALOG_ERRNO(ETIME)
CENTERROR_CATALOG_ERRNO(ETIMEDOUT)
CENTERROR_CATALOG_ERRNO(ETXTBSY)
/*CENTERROR_CATALOG_ERRNO(EUCLEAN)*/
/* OSX doesn't have this:
CENTERROR_CATALOG_ERRNO(EUNATCH) */
CENTERROR_CATALOG_ERRNO(EUSERS)
CENTERROR_CATALOG_ERRNO(EWOULDBLOCK)
CENTERROR_CATALOG_ERRNO(EXDEV)
/*CENTERROR_CATALOG_ERRNO(EXFULL)*/

#undef INTERNAL_ONLY
