/*
 * Copyright (c) Likewise Software.  All rights Reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

/*
 * Module Name:
 *
 *        rpcstatus.c
 *
 * Abstract:
 *
 *        Rpc status codes
 *
 * Authors: Kyle Stemen <kstemen@likewise.com>
 *
 */

#include "includes.h"

#define LW_ERROR_RPC_S_MOD                          0x16c9a000
#define LW_ERROR_RPC_S_OP_RNG_ERROR                 0x16c9a001
#define LW_ERROR_RPC_S_CANT_CREATE_SOCKET           0x16c9a002
#define LW_ERROR_RPC_S_CANT_BIND_SOCKET             0x16c9a003
#define LW_ERROR_RPC_S_NOT_IN_CALL                  0x16c9a004
#define LW_ERROR_RPC_S_NO_PORT                      0x16c9a005
#define LW_ERROR_RPC_S_WRONG_BOOT_TIME              0x16c9a006
#define LW_ERROR_RPC_S_TOO_MANY_SOCKETS             0x16c9a007
#define LW_ERROR_RPC_S_ILLEGAL_REGISTER             0x16c9a008
#define LW_ERROR_RPC_S_CANT_RECV                    0x16c9a009
#define LW_ERROR_RPC_S_BAD_PKT                      0x16c9a00a
#define LW_ERROR_RPC_S_UNBOUND_HANDLE               0x16c9a00b
#define LW_ERROR_RPC_S_ADDR_IN_USE                  0x16c9a00c
#define LW_ERROR_RPC_S_IN_ARGS_TOO_BIG              0x16c9a00d
#define LW_ERROR_RPC_S_STRING_TOO_LONG              0x16c9a00e
#define LW_ERROR_RPC_S_TOO_MANY_OBJECTS             0x16c9a00f
#define LW_ERROR_RPC_S_BINDING_HAS_NO_AUTH          0x16c9a010
#define LW_ERROR_RPC_S_UNKNOWN_AUTHN_SERVICE        0x16c9a011
#define LW_ERROR_RPC_S_NO_MEMORY                    0x16c9a012
#define LW_ERROR_RPC_S_CANT_NMALLOC                 0x16c9a013
#define LW_ERROR_RPC_S_CALL_FAULTED                 0x16c9a014
#define LW_ERROR_RPC_S_CALL_FAILED                  0x16c9a015
#define LW_ERROR_RPC_S_COMM_FAILURE                 0x16c9a016
#define LW_ERROR_RPC_S_RPCD_COMM_FAILURE            0x16c9a017
#define LW_ERROR_RPC_S_ILLEGAL_FAMILY_REBIND        0x16c9a018
#define LW_ERROR_RPC_S_INVALID_HANDLE               0x16c9a019
#define LW_ERROR_RPC_S_CODING_ERROR                 0x16c9a01a
#define LW_ERROR_RPC_S_OBJECT_NOT_FOUND             0x16c9a01b
#define LW_ERROR_RPC_S_CTHREAD_NOT_FOUND            0x16c9a01c
#define LW_ERROR_RPC_S_INVALID_BINDING              0x16c9a01d
#define LW_ERROR_RPC_S_ALREADY_REGISTERED           0x16c9a01e
#define LW_ERROR_RPC_S_ENDPOINT_NOT_FOUND           0x16c9a01f
#define LW_ERROR_RPC_S_INVALID_RPC_PROTSEQ          0x16c9a020
#define LW_ERROR_RPC_S_DESC_NOT_REGISTERED          0x16c9a021
#define LW_ERROR_RPC_S_ALREADY_LISTENING            0x16c9a022
#define LW_ERROR_RPC_S_NO_PROTSEQS                  0x16c9a023
#define LW_ERROR_RPC_S_NO_PROTSEQS_REGISTERED       0x16c9a024
#define LW_ERROR_RPC_S_NO_BINDINGS                  0x16c9a025
#define LW_ERROR_RPC_S_MAX_DESCS_EXCEEDED           0x16c9a026
#define LW_ERROR_RPC_S_NO_INTERFACES                0x16c9a027
#define LW_ERROR_RPC_S_INVALID_TIMEOUT              0x16c9a028
#define LW_ERROR_RPC_S_CANT_INQ_SOCKET              0x16c9a029
#define LW_ERROR_RPC_S_INVALID_NAF_ID               0x16c9a02a
#define LW_ERROR_RPC_S_INVAL_NET_ADDR               0x16c9a02b
#define LW_ERROR_RPC_S_UNKNOWN_IF                   0x16c9a02c
#define LW_ERROR_RPC_S_UNSUPPORTED_TYPE             0x16c9a02d
#define LW_ERROR_RPC_S_INVALID_CALL_OPT             0x16c9a02e
#define LW_ERROR_RPC_S_NO_FAULT                     0x16c9a02f
#define LW_ERROR_RPC_S_CANCEL_TIMEOUT               0x16c9a030
#define LW_ERROR_RPC_S_CALL_CANCELLED               0x16c9a031
#define LW_ERROR_RPC_S_INVALID_CALL_HANDLE          0x16c9a032
#define LW_ERROR_RPC_S_CANNOT_ALLOC_ASSOC           0x16c9a033
#define LW_ERROR_RPC_S_CANNOT_CONNECT               0x16c9a034
#define LW_ERROR_RPC_S_CONNECTION_ABORTED           0x16c9a035
#define LW_ERROR_RPC_S_CONNECTION_CLOSED            0x16c9a036
#define LW_ERROR_RPC_S_CANNOT_ACCEPT                0x16c9a037
#define LW_ERROR_RPC_S_ASSOC_GRP_NOT_FOUND          0x16c9a038
#define LW_ERROR_RPC_S_STUB_INTERFACE_ERROR         0x16c9a039
#define LW_ERROR_RPC_S_INVALID_OBJECT               0x16c9a03a
#define LW_ERROR_RPC_S_INVALID_TYPE                 0x16c9a03b
#define LW_ERROR_RPC_S_INVALID_IF_OPNUM             0x16c9a03c
#define LW_ERROR_RPC_S_DIFFERENT_SERVER_INSTANCE    0x16c9a03d
#define LW_ERROR_RPC_S_PROTOCOL_ERROR               0x16c9a03e
#define LW_ERROR_RPC_S_CANT_RECVMSG                 0x16c9a03f
#define LW_ERROR_RPC_S_INVALID_STRING_BINDING       0x16c9a040
#define LW_ERROR_RPC_S_CONNECT_TIMED_OUT            0x16c9a041
#define LW_ERROR_RPC_S_CONNECT_REJECTED             0x16c9a042
#define LW_ERROR_RPC_S_NETWORK_UNREACHABLE          0x16c9a043
#define LW_ERROR_RPC_S_CONNECT_NO_RESOURCES         0x16c9a044
#define LW_ERROR_RPC_S_REM_NETWORK_SHUTDOWN         0x16c9a045
#define LW_ERROR_RPC_S_TOO_MANY_REM_CONNECTS        0x16c9a046
#define LW_ERROR_RPC_S_NO_REM_ENDPOINT              0x16c9a047
#define LW_ERROR_RPC_S_REM_HOST_DOWN                0x16c9a048
#define LW_ERROR_RPC_S_HOST_UNREACHABLE             0x16c9a049
#define LW_ERROR_RPC_S_ACCESS_CONTROL_INFO_INV      0x16c9a04a
#define LW_ERROR_RPC_S_LOC_CONNECT_ABORTED          0x16c9a04b
#define LW_ERROR_RPC_S_CONNECT_CLOSED_BY_REM        0x16c9a04c
#define LW_ERROR_RPC_S_REM_HOST_CRASHED             0x16c9a04d
#define LW_ERROR_RPC_S_INVALID_ENDPOINT_FORMAT      0x16c9a04e
#define LW_ERROR_RPC_S_UNKNOWN_STATUS_CODE          0x16c9a04f
#define LW_ERROR_RPC_S_UNKNOWN_MGR_TYPE             0x16c9a050
#define LW_ERROR_RPC_S_ASSOC_CREATION_FAILED        0x16c9a051
#define LW_ERROR_RPC_S_ASSOC_GRP_MAX_EXCEEDED       0x16c9a052
#define LW_ERROR_RPC_S_ASSOC_GRP_ALLOC_FAILED       0x16c9a053
#define LW_ERROR_RPC_S_SM_INVALID_STATE             0x16c9a054
#define LW_ERROR_RPC_S_ASSOC_REQ_REJECTED           0x16c9a055
#define LW_ERROR_RPC_S_ASSOC_SHUTDOWN               0x16c9a056
#define LW_ERROR_RPC_S_TSYNTAXES_UNSUPPORTED        0x16c9a057
#define LW_ERROR_RPC_S_CONTEXT_ID_NOT_FOUND         0x16c9a058
#define LW_ERROR_RPC_S_CANT_LISTEN_SOCKET           0x16c9a059
#define LW_ERROR_RPC_S_NO_ADDRS                     0x16c9a05a
#define LW_ERROR_RPC_S_CANT_GETPEERNAME             0x16c9a05b
#define LW_ERROR_RPC_S_CANT_GET_IF_ID               0x16c9a05c
#define LW_ERROR_RPC_S_PROTSEQ_NOT_SUPPORTED        0x16c9a05d
#define LW_ERROR_RPC_S_CALL_ORPHANED                0x16c9a05e
#define LW_ERROR_RPC_S_WHO_ARE_YOU_FAILED           0x16c9a05f
#define LW_ERROR_RPC_S_UNKNOWN_REJECT               0x16c9a060
#define LW_ERROR_RPC_S_TYPE_ALREADY_REGISTERED      0x16c9a061
#define LW_ERROR_RPC_S_STOP_LISTENING_DISABLED      0x16c9a062
#define LW_ERROR_RPC_S_INVALID_ARG                  0x16c9a063
#define LW_ERROR_RPC_S_NOT_SUPPORTED                0x16c9a064
#define LW_ERROR_RPC_S_WRONG_KIND_OF_BINDING        0x16c9a065
#define LW_ERROR_RPC_S_AUTHN_AUTHZ_MISMATCH         0x16c9a066
#define LW_ERROR_RPC_S_CALL_QUEUED                  0x16c9a067
#define LW_ERROR_RPC_S_CANNOT_SET_NODELAY           0x16c9a068
#define LW_ERROR_RPC_S_NOT_RPC_TOWER                0x16c9a069
#define LW_ERROR_RPC_S_INVALID_RPC_PROTID           0x16c9a06a
#define LW_ERROR_RPC_S_INVALID_RPC_FLOOR            0x16c9a06b
#define LW_ERROR_RPC_S_CALL_TIMEOUT                 0x16c9a06c
#define LW_ERROR_RPC_S_MGMT_OP_DISALLOWED           0x16c9a06d
#define LW_ERROR_RPC_S_MANAGER_NOT_ENTERED          0x16c9a06e
#define LW_ERROR_RPC_S_CALLS_TOO_LARGE_FOR_WK_EP    0x16c9a06f
#define LW_ERROR_RPC_S_SERVER_TOO_BUSY              0x16c9a070
#define LW_ERROR_RPC_S_PROT_VERSION_MISMATCH        0x16c9a071
#define LW_ERROR_RPC_S_RPC_PROT_VERSION_MISMATCH    0x16c9a072
#define LW_ERROR_RPC_S_SS_NO_IMPORT_CURSOR          0x16c9a073
#define LW_ERROR_RPC_S_FAULT_ADDR_ERROR             0x16c9a074
#define LW_ERROR_RPC_S_FAULT_CONTEXT_MISMATCH       0x16c9a075
#define LW_ERROR_RPC_S_FAULT_FP_DIV_BY_ZERO         0x16c9a076
#define LW_ERROR_RPC_S_FAULT_FP_ERROR               0x16c9a077
#define LW_ERROR_RPC_S_FAULT_FP_OVERFLOW            0x16c9a078
#define LW_ERROR_RPC_S_FAULT_FP_UNDERFLOW           0x16c9a079
#define LW_ERROR_RPC_S_FAULT_ILL_INST               0x16c9a07a
#define LW_ERROR_RPC_S_FAULT_INT_DIV_BY_ZERO        0x16c9a07b
#define LW_ERROR_RPC_S_FAULT_INT_OVERFLOW           0x16c9a07c
#define LW_ERROR_RPC_S_FAULT_INVALID_BOUND          0x16c9a07d
#define LW_ERROR_RPC_S_FAULT_INVALID_TAG            0x16c9a07e
#define LW_ERROR_RPC_S_FAULT_PIPE_CLOSED            0x16c9a07f
#define LW_ERROR_RPC_S_FAULT_PIPE_COMM_ERROR        0x16c9a080
#define LW_ERROR_RPC_S_FAULT_PIPE_DISCIPLINE        0x16c9a081
#define LW_ERROR_RPC_S_FAULT_PIPE_EMPTY             0x16c9a082
#define LW_ERROR_RPC_S_FAULT_PIPE_MEMORY            0x16c9a083
#define LW_ERROR_RPC_S_FAULT_PIPE_ORDER             0x16c9a084
#define LW_ERROR_RPC_S_FAULT_REMOTE_COMM_FAILURE    0x16c9a085
#define LW_ERROR_RPC_S_FAULT_REMOTE_NO_MEMORY       0x16c9a086
#define LW_ERROR_RPC_S_FAULT_UNSPEC                 0x16c9a087
#define LW_ERROR_UUID_S_BAD_VERSION                 0x16c9a088
#define LW_ERROR_UUID_S_SOCKET_FAILURE              0x16c9a089
#define LW_ERROR_UUID_S_GETCONF_FAILURE             0x16c9a08a
#define LW_ERROR_UUID_S_NO_ADDRESS                  0x16c9a08b
#define LW_ERROR_UUID_S_OVERRUN                     0x16c9a08c
#define LW_ERROR_UUID_S_INTERNAL_ERROR              0x16c9a08d
#define LW_ERROR_UUID_S_CODING_ERROR                0x16c9a08e
#define LW_ERROR_UUID_S_INVALID_STRING_UUID         0x16c9a08f
#define LW_ERROR_UUID_S_NO_MEMORY                   0x16c9a090
#define LW_ERROR_RPC_S_NO_MORE_ENTRIES              0x16c9a091
#define LW_ERROR_RPC_S_UNKNOWN_NS_ERROR             0x16c9a092
#define LW_ERROR_RPC_S_NAME_SERVICE_UNAVAILABLE     0x16c9a093
#define LW_ERROR_RPC_S_INCOMPLETE_NAME              0x16c9a094
#define LW_ERROR_RPC_S_GROUP_NOT_FOUND              0x16c9a095
#define LW_ERROR_RPC_S_INVALID_NAME_SYNTAX          0x16c9a096
#define LW_ERROR_RPC_S_NO_MORE_MEMBERS              0x16c9a097
#define LW_ERROR_RPC_S_NO_MORE_INTERFACES           0x16c9a098
#define LW_ERROR_RPC_S_INVALID_NAME_SERVICE         0x16c9a099
#define LW_ERROR_RPC_S_NO_NAME_MAPPING              0x16c9a09a
#define LW_ERROR_RPC_S_PROFILE_NOT_FOUND            0x16c9a09b
#define LW_ERROR_RPC_S_NOT_FOUND                    0x16c9a09c
#define LW_ERROR_RPC_S_NO_UPDATES                   0x16c9a09d
#define LW_ERROR_RPC_S_UPDATE_FAILED                0x16c9a09e
#define LW_ERROR_RPC_S_NO_MATCH_EXPORTED            0x16c9a09f
#define LW_ERROR_RPC_S_ENTRY_NOT_FOUND              0x16c9a0a0
#define LW_ERROR_RPC_S_INVALID_INQUIRY_CONTEXT      0x16c9a0a1
#define LW_ERROR_RPC_S_INTERFACE_NOT_FOUND          0x16c9a0a2
#define LW_ERROR_RPC_S_GROUP_MEMBER_NOT_FOUND       0x16c9a0a3
#define LW_ERROR_RPC_S_ENTRY_ALREADY_EXISTS         0x16c9a0a4
#define LW_ERROR_RPC_S_NSINIT_FAILURE               0x16c9a0a5
#define LW_ERROR_RPC_S_UNSUPPORTED_NAME_SYNTAX      0x16c9a0a6
#define LW_ERROR_RPC_S_NO_MORE_ELEMENTS             0x16c9a0a7
#define LW_ERROR_RPC_S_NO_NS_PERMISSION             0x16c9a0a8
#define LW_ERROR_RPC_S_INVALID_INQUIRY_TYPE         0x16c9a0a9
#define LW_ERROR_RPC_S_PROFILE_ELEMENT_NOT_FOUND    0x16c9a0aa
#define LW_ERROR_RPC_S_PROFILE_ELEMENT_REPLACED     0x16c9a0ab
#define LW_ERROR_RPC_S_IMPORT_ALREADY_DONE          0x16c9a0ac
#define LW_ERROR_RPC_S_DATABASE_BUSY                0x16c9a0ad
#define LW_ERROR_RPC_S_INVALID_IMPORT_CONTEXT       0x16c9a0ae
#define LW_ERROR_RPC_S_UUID_SET_NOT_FOUND           0x16c9a0af
#define LW_ERROR_RPC_S_UUID_MEMBER_NOT_FOUND        0x16c9a0b0
#define LW_ERROR_RPC_S_NO_INTERFACES_EXPORTED       0x16c9a0b1
#define LW_ERROR_RPC_S_TOWER_SET_NOT_FOUND          0x16c9a0b2
#define LW_ERROR_RPC_S_TOWER_MEMBER_NOT_FOUND       0x16c9a0b3
#define LW_ERROR_RPC_S_OBJ_UUID_NOT_FOUND           0x16c9a0b4
#define LW_ERROR_RPC_S_NO_MORE_BINDINGS             0x16c9a0b5
#define LW_ERROR_RPC_S_INVALID_PRIORITY             0x16c9a0b6
#define LW_ERROR_RPC_S_NOT_RPC_ENTRY                0x16c9a0b7
#define LW_ERROR_RPC_S_INVALID_LOOKUP_CONTEXT       0x16c9a0b8
#define LW_ERROR_RPC_S_BINDING_VECTOR_FULL          0x16c9a0b9
#define LW_ERROR_RPC_S_CYCLE_DETECTED               0x16c9a0ba
#define LW_ERROR_RPC_S_NOTHING_TO_EXPORT            0x16c9a0bb
#define LW_ERROR_RPC_S_NOTHING_TO_UNEXPORT          0x16c9a0bc
#define LW_ERROR_RPC_S_INVALID_VERS_OPTION          0x16c9a0bd
#define LW_ERROR_RPC_S_NO_RPC_DATA                  0x16c9a0be
#define LW_ERROR_RPC_S_MBR_PICKED                   0x16c9a0bf
#define LW_ERROR_RPC_S_NOT_ALL_OBJS_UNEXPORTED      0x16c9a0c0
#define LW_ERROR_RPC_S_NO_ENTRY_NAME                0x16c9a0c1
#define LW_ERROR_RPC_S_PRIORITY_GROUP_DONE          0x16c9a0c2
#define LW_ERROR_RPC_S_PARTIAL_RESULTS              0x16c9a0c3
#define LW_ERROR_RPC_S_NO_ENV_SETUP                 0x16c9a0c4
#define LW_ERROR_TWR_S_UNKNOWN_SA                   0x16c9a0c5
#define LW_ERROR_TWR_S_UNKNOWN_TOWER                0x16c9a0c6
#define LW_ERROR_TWR_S_NOT_IMPLEMENTED              0x16c9a0c7
#define LW_ERROR_RPC_S_MAX_CALLS_TOO_SMALL          0x16c9a0c8
#define LW_ERROR_RPC_S_CTHREAD_CREATE_FAILED        0x16c9a0c9
#define LW_ERROR_RPC_S_CTHREAD_POOL_EXISTS          0x16c9a0ca
#define LW_ERROR_RPC_S_CTHREAD_NO_SUCH_POOL         0x16c9a0cb
#define LW_ERROR_RPC_S_CTHREAD_INVOKE_DISABLED      0x16c9a0cc
#define LW_ERROR_EPT_S_CANT_PERFORM_OP              0x16c9a0cd
#define LW_ERROR_EPT_S_NO_MEMORY                    0x16c9a0ce
#define LW_ERROR_EPT_S_DATABASE_INVALID             0x16c9a0cf
#define LW_ERROR_EPT_S_CANT_CREATE                  0x16c9a0d0
#define LW_ERROR_EPT_S_CANT_ACCESS                  0x16c9a0d1
#define LW_ERROR_EPT_S_DATABASE_ALREADY_OPEN        0x16c9a0d2
#define LW_ERROR_EPT_S_INVALID_ENTRY                0x16c9a0d3
#define LW_ERROR_EPT_S_UPDATE_FAILED                0x16c9a0d4
#define LW_ERROR_EPT_S_INVALID_CONTEXT              0x16c9a0d5
#define LW_ERROR_EPT_S_NOT_REGISTERED               0x16c9a0d6
#define LW_ERROR_EPT_S_SERVER_UNAVAILABLE           0x16c9a0d7
#define LW_ERROR_RPC_S_UNDERSPECIFIED_NAME          0x16c9a0d8
#define LW_ERROR_RPC_S_INVALID_NS_HANDLE            0x16c9a0d9
#define LW_ERROR_RPC_S_UNKNOWN_ERROR                0x16c9a0da
#define LW_ERROR_RPC_S_SS_CHAR_TRANS_OPEN_FAIL      0x16c9a0db
#define LW_ERROR_RPC_S_SS_CHAR_TRANS_SHORT_FILE     0x16c9a0dc
#define LW_ERROR_RPC_S_SS_CONTEXT_DAMAGED           0x16c9a0dd
#define LW_ERROR_RPC_S_SS_IN_NULL_CONTEXT           0x16c9a0de
#define LW_ERROR_RPC_S_SOCKET_FAILURE               0x16c9a0df
#define LW_ERROR_RPC_S_UNSUPPORTED_PROTECT_LEVEL    0x16c9a0e0
#define LW_ERROR_RPC_S_INVALID_CHECKSUM             0x16c9a0e1
#define LW_ERROR_RPC_S_INVALID_CREDENTIALS          0x16c9a0e2
#define LW_ERROR_RPC_S_CREDENTIALS_TOO_LARGE        0x16c9a0e3
#define LW_ERROR_RPC_S_CALL_ID_NOT_FOUND            0x16c9a0e4
#define LW_ERROR_RPC_S_KEY_ID_NOT_FOUND             0x16c9a0e5
#define LW_ERROR_RPC_S_AUTH_BAD_INTEGRITY           0x16c9a0e6
#define LW_ERROR_RPC_S_AUTH_TKT_EXPIRED             0x16c9a0e7
#define LW_ERROR_RPC_S_AUTH_TKT_NYV                 0x16c9a0e8
#define LW_ERROR_RPC_S_AUTH_REPEAT                  0x16c9a0e9
#define LW_ERROR_RPC_S_AUTH_NOT_US                  0x16c9a0ea
#define LW_ERROR_RPC_S_AUTH_BADMATCH                0x16c9a0eb
#define LW_ERROR_RPC_S_AUTH_SKEW                    0x16c9a0ec
#define LW_ERROR_RPC_S_AUTH_BADADDR                 0x16c9a0ed
#define LW_ERROR_RPC_S_AUTH_BADVERSION              0x16c9a0ee
#define LW_ERROR_RPC_S_AUTH_MSG_TYPE                0x16c9a0ef
#define LW_ERROR_RPC_S_AUTH_MODIFIED                0x16c9a0f0
#define LW_ERROR_RPC_S_AUTH_BADORDER                0x16c9a0f1
#define LW_ERROR_RPC_S_AUTH_BADKEYVER               0x16c9a0f2
#define LW_ERROR_RPC_S_AUTH_NOKEY                   0x16c9a0f3
#define LW_ERROR_RPC_S_AUTH_MUT_FAIL                0x16c9a0f4
#define LW_ERROR_RPC_S_AUTH_BADDIRECTION            0x16c9a0f5
#define LW_ERROR_RPC_S_AUTH_METHOD                  0x16c9a0f6
#define LW_ERROR_RPC_S_AUTH_BADSEQ                  0x16c9a0f7
#define LW_ERROR_RPC_S_AUTH_INAPP_CKSUM             0x16c9a0f8
#define LW_ERROR_RPC_S_AUTH_FIELD_TOOLONG           0x16c9a0f9
#define LW_ERROR_RPC_S_INVALID_CRC                  0x16c9a0fa
#define LW_ERROR_RPC_S_BINDING_INCOMPLETE           0x16c9a0fb
#define LW_ERROR_RPC_S_KEY_FUNC_NOT_ALLOWED         0x16c9a0fc
#define LW_ERROR_RPC_S_UNKNOWN_STUB_RTL_IF_VERS     0x16c9a0fd
#define LW_ERROR_RPC_S_UNKNOWN_IFSPEC_VERS          0x16c9a0fe
#define LW_ERROR_RPC_S_PROTO_UNSUPP_BY_AUTH         0x16c9a0ff
#define LW_ERROR_RPC_S_AUTHN_CHALLENGE_MALFORMED    0x16c9a100
#define LW_ERROR_RPC_S_PROTECT_LEVEL_MISMATCH       0x16c9a101
#define LW_ERROR_RPC_S_NO_MEPV                      0x16c9a102
#define LW_ERROR_RPC_S_STUB_PROTOCOL_ERROR          0x16c9a103
#define LW_ERROR_RPC_S_CLASS_VERSION_MISMATCH       0x16c9a104
#define LW_ERROR_RPC_S_HELPER_NOT_RUNNING           0x16c9a105
#define LW_ERROR_RPC_S_HELPER_SHORT_READ            0x16c9a106
#define LW_ERROR_RPC_S_HELPER_CATATONIC             0x16c9a107
#define LW_ERROR_RPC_S_HELPER_ABORTED               0x16c9a108
#define LW_ERROR_RPC_S_NOT_IN_KERNEL                0x16c9a109
#define LW_ERROR_RPC_S_HELPER_WRONG_USER            0x16c9a10a
#define LW_ERROR_RPC_S_HELPER_OVERFLOW              0x16c9a10b
#define LW_ERROR_RPC_S_DG_NEED_WAY_AUTH             0x16c9a10c
#define LW_ERROR_RPC_S_UNSUPPORTED_AUTH_SUBTYPE     0x16c9a10d
#define LW_ERROR_RPC_S_WRONG_PICKLE_TYPE            0x16c9a10e
#define LW_ERROR_RPC_S_NOT_LISTENING                0x16c9a10f
#define LW_ERROR_RPC_S_SS_BAD_BUFFER                0x16c9a110
#define LW_ERROR_RPC_S_SS_BAD_ES_ACTION             0x16c9a111
#define LW_ERROR_RPC_S_SS_WRONG_ES_VERSION          0x16c9a112
#define LW_ERROR_RPC_S_FAULT_USER_DEFINED           0x16c9a113
#define LW_ERROR_RPC_S_SS_INCOMPATIBLE_CODESETS     0x16c9a114
#define LW_ERROR_RPC_S_TX_NOT_IN_TRANSACTION        0x16c9a115
#define LW_ERROR_RPC_S_TX_OPEN_FAILED               0x16c9a116
#define LW_ERROR_RPC_S_PARTIAL_CREDENTIALS          0x16c9a117
#define LW_ERROR_RPC_S_SS_INVALID_CODESET_TAG       0x16c9a118
#define LW_ERROR_RPC_S_MGMT_BAD_TYPE                0x16c9a119
#define LW_ERROR_RPC_S_SS_INVALID_CHAR_INPUT        0x16c9a11a
#define LW_ERROR_RPC_S_SS_SHORT_CONV_BUFFER         0x16c9a11b
#define LW_ERROR_RPC_S_SS_ICONV_ERROR               0x16c9a11c
#define LW_ERROR_RPC_S_SS_NO_COMPAT_CODESET         0x16c9a11d
#define LW_ERROR_RPC_S_SS_NO_COMPAT_CHARSETS        0x16c9a11e
#define LW_ERROR_DCE_CS_C_OK                        0x16c9a11f
#define LW_ERROR_DCE_CS_C_UNKNOWN                   0x16c9a120
#define LW_ERROR_DCE_CS_C_NOTFOUND                  0x16c9a121
#define LW_ERROR_DCE_CS_C_CANNOT_OPEN_FILE          0x16c9a122
#define LW_ERROR_DCE_CS_C_CANNOT_READ_FILE          0x16c9a123
#define LW_ERROR_DCE_CS_C_CANNOT_ALLOCATE_MEMORY    0x16c9a124
#define LW_ERROR_RPC_S_SS_CLEANUP_FAILED            0x16c9a125
#define LW_ERROR_RPC_SVC_DESC_GENERAL               0x16c9a126
#define LW_ERROR_RPC_SVC_DESC_MUTEX                 0x16c9a127
#define LW_ERROR_RPC_SVC_DESC_XMIT                  0x16c9a128
#define LW_ERROR_RPC_SVC_DESC_RECV                  0x16c9a129
#define LW_ERROR_RPC_SVC_DESC_DG_STATE              0x16c9a12a
#define LW_ERROR_RPC_SVC_DESC_CANCEL                0x16c9a12b
#define LW_ERROR_RPC_SVC_DESC_ORPHAN                0x16c9a12c
#define LW_ERROR_RPC_SVC_DESC_CN_STATE              0x16c9a12d
#define LW_ERROR_RPC_SVC_DESC_CN_PKT                0x16c9a12e
#define LW_ERROR_RPC_SVC_DESC_PKT_QUOTAS            0x16c9a12f
#define LW_ERROR_RPC_SVC_DESC_AUTH                  0x16c9a130
#define LW_ERROR_RPC_SVC_DESC_SOURCE                0x16c9a131
#define LW_ERROR_RPC_SVC_DESC_STATS                 0x16c9a132
#define LW_ERROR_RPC_SVC_DESC_MEM                   0x16c9a133
#define LW_ERROR_RPC_SVC_DESC_MEM_TYPE              0x16c9a134
#define LW_ERROR_RPC_SVC_DESC_DG_PKTLOG             0x16c9a135
#define LW_ERROR_RPC_SVC_DESC_THREAD_ID             0x16c9a136
#define LW_ERROR_RPC_SVC_DESC_TIMESTAMP             0x16c9a137
#define LW_ERROR_RPC_SVC_DESC_CN_ERRORS             0x16c9a138
#define LW_ERROR_RPC_SVC_DESC_CONV_THREAD           0x16c9a139
#define LW_ERROR_RPC_SVC_DESC_PID                   0x16c9a13a
#define LW_ERROR_RPC_SVC_DESC_ATFORK                0x16c9a13b
#define LW_ERROR_RPC_SVC_DESC_CMA_THREAD            0x16c9a13c
#define LW_ERROR_RPC_SVC_DESC_INHERIT               0x16c9a13d
#define LW_ERROR_RPC_SVC_DESC_DG_SOCKETS            0x16c9a13e
#define LW_ERROR_RPC_SVC_DESC_TIMER                 0x16c9a13f
#define LW_ERROR_RPC_SVC_DESC_THREADS               0x16c9a140
#define LW_ERROR_RPC_SVC_DESC_SERVER_CALL           0x16c9a141
#define LW_ERROR_RPC_SVC_DESC_NSI                   0x16c9a142
#define LW_ERROR_RPC_SVC_DESC_DG_PKT                0x16c9a143
#define LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_SA        0x16c9a144
#define LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_CA        0x16c9a145
#define LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_SG        0x16c9a146
#define LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_CG        0x16c9a147
#define LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_SR        0x16c9a148
#define LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_CR        0x16c9a149
#define LW_ERROR_RPC_M_BAD_PKT_TYPE                 0x16c9a14a
#define LW_ERROR_RPC_M_PROT_MISMATCH                0x16c9a14b
#define LW_ERROR_RPC_M_FRAG_TOOBIG                  0x16c9a14c
#define LW_ERROR_RPC_M_UNSUPP_STUB_RTL_IF           0x16c9a14d
#define LW_ERROR_RPC_M_UNHANDLED_CALLSTATE          0x16c9a14e
#define LW_ERROR_RPC_M_CALL_FAILED                  0x16c9a14f
#define LW_ERROR_RPC_M_CALL_FAILED_NO_STATUS        0x16c9a150
#define LW_ERROR_RPC_M_CALL_FAILED_ERRNO            0x16c9a151
#define LW_ERROR_RPC_M_CALL_FAILED_S                0x16c9a152
#define LW_ERROR_RPC_M_CALL_FAILED_C                0x16c9a153
#define LW_ERROR_RPC_M_ERRMSG_TOOBIG                0x16c9a154
#define LW_ERROR_RPC_M_INVALID_SRCHATTR             0x16c9a155
#define LW_ERROR_RPC_M_NTS_NOT_FOUND                0x16c9a156
#define LW_ERROR_RPC_M_INVALID_ACCBYTCNT            0x16c9a157
#define LW_ERROR_RPC_M_PRE_V2_IFSPEC                0x16c9a158
#define LW_ERROR_RPC_M_UNK_IFSPEC                   0x16c9a159
#define LW_ERROR_RPC_M_RECVBUF_TOOSMALL             0x16c9a15a
#define LW_ERROR_RPC_M_UNALIGN_AUTHTRL              0x16c9a15b
#define LW_ERROR_RPC_M_UNEXPECTED_EXC               0x16c9a15c
#define LW_ERROR_RPC_M_NO_STUB_DATA                 0x16c9a15d
#define LW_ERROR_RPC_M_EVENTLIST_FULL               0x16c9a15e
#define LW_ERROR_RPC_M_UNK_SOCK_TYPE                0x16c9a15f
#define LW_ERROR_RPC_M_UNIMP_CALL                   0x16c9a160
#define LW_ERROR_RPC_M_INVALID_SEQNUM               0x16c9a161
#define LW_ERROR_RPC_M_CANT_CREATE_UUID             0x16c9a162
#define LW_ERROR_RPC_M_PRE_V2_SS                    0x16c9a163
#define LW_ERROR_RPC_M_DGPKT_POOL_CORRUPT           0x16c9a164
#define LW_ERROR_RPC_M_DGPKT_BAD_FREE               0x16c9a165
#define LW_ERROR_RPC_M_LOOKASIDE_CORRUPT            0x16c9a166
#define LW_ERROR_RPC_M_ALLOC_FAIL                   0x16c9a167
#define LW_ERROR_RPC_M_REALLOC_FAIL                 0x16c9a168
#define LW_ERROR_RPC_M_CANT_OPEN_FILE               0x16c9a169
#define LW_ERROR_RPC_M_CANT_READ_ADDR               0x16c9a16a
#define LW_ERROR_RPC_SVC_DESC_LIBIDL                0x16c9a16b
#define LW_ERROR_RPC_M_CTXRUNDOWN_NOMEM             0x16c9a16c
#define LW_ERROR_RPC_M_CTXRUNDOWN_EXC               0x16c9a16d
#define LW_ERROR_RPC_S_FAULT_CODESET_CONV_ERROR     0x16c9a16e

LW_NTSTATUS
LwRpcStatusToNtStatus(
    LW_IN LW_DWORD status
    )
{
    switch(status)
    {
        case 0:
            return LW_STATUS_SUCCESS;
        case LW_ERROR_RPC_S_CANT_CREATE_SOCKET:
            return LW_STATUS_CONNECTION_REFUSED;
        case LW_ERROR_RPC_S_CANT_BIND_SOCKET:
            return LW_STATUS_ADDRESS_NOT_ASSOCIATED;
        case LW_ERROR_RPC_S_RPCD_COMM_FAILURE:
            return LW_STATUS_REMOTE_NOT_LISTENING;
        case LW_ERROR_RPC_S_COMM_FAILURE:
            return LW_STATUS_CONNECTION_INVALID;
        case LW_ERROR_RPC_S_CANNOT_CONNECT:
            return LW_STATUS_INVALID_CONNECTION;
        case LW_ERROR_RPC_S_CONNECTION_ABORTED:
            return LW_STATUS_CONNECTION_ABORTED;
        case LW_ERROR_RPC_S_CONNECTION_CLOSED:
            return LW_STATUS_CONNECTION_RESET;
        case LW_ERROR_RPC_S_CONNECT_TIMED_OUT:
            return LW_STATUS_IO_TIMEOUT;
        case LW_ERROR_RPC_S_CONNECT_REJECTED:
            return LW_STATUS_CONNECTION_REFUSED;
        case LW_ERROR_RPC_S_NO_MEMORY:
            return LW_STATUS_INSUFFICIENT_RESOURCES;
        case LW_ERROR_RPC_S_CALL_TIMEOUT:
            return LW_STATUS_TRANSACTION_TIMED_OUT;
        case LW_ERROR_RPC_S_ADDR_IN_USE:
            return LW_STATUS_ADDRESS_ALREADY_EXISTS;
        case LW_ERROR_RPC_S_TOO_MANY_SOCKETS:
            return LW_STATUS_TOO_MANY_ADDRESSES;
        case LW_ERROR_RPC_S_INVALID_CREDENTIALS:
            return LW_STATUS_ACCESS_DENIED;

        case LW_ERROR_RPC_S_MOD:
        case LW_ERROR_RPC_S_OP_RNG_ERROR:
        case LW_ERROR_RPC_S_NOT_IN_CALL:
        case LW_ERROR_RPC_S_NO_PORT:
        case LW_ERROR_RPC_S_WRONG_BOOT_TIME:
        case LW_ERROR_RPC_S_ILLEGAL_REGISTER:
        case LW_ERROR_RPC_S_CANT_RECV:
        case LW_ERROR_RPC_S_BAD_PKT:
        case LW_ERROR_RPC_S_UNBOUND_HANDLE:
        case LW_ERROR_RPC_S_IN_ARGS_TOO_BIG:
        case LW_ERROR_RPC_S_STRING_TOO_LONG:
        case LW_ERROR_RPC_S_TOO_MANY_OBJECTS:
        case LW_ERROR_RPC_S_BINDING_HAS_NO_AUTH:
        case LW_ERROR_RPC_S_UNKNOWN_AUTHN_SERVICE:
        case LW_ERROR_RPC_S_CANT_NMALLOC:
        case LW_ERROR_RPC_S_CALL_FAULTED:
        case LW_ERROR_RPC_S_CALL_FAILED:
        case LW_ERROR_RPC_S_ILLEGAL_FAMILY_REBIND:
        case LW_ERROR_RPC_S_INVALID_HANDLE:
        case LW_ERROR_RPC_S_CODING_ERROR:
        case LW_ERROR_RPC_S_OBJECT_NOT_FOUND:
        case LW_ERROR_RPC_S_CTHREAD_NOT_FOUND:
        case LW_ERROR_RPC_S_INVALID_BINDING:
        case LW_ERROR_RPC_S_ALREADY_REGISTERED:
        case LW_ERROR_RPC_S_ENDPOINT_NOT_FOUND:
        case LW_ERROR_RPC_S_INVALID_RPC_PROTSEQ:
        case LW_ERROR_RPC_S_DESC_NOT_REGISTERED:
        case LW_ERROR_RPC_S_ALREADY_LISTENING:
        case LW_ERROR_RPC_S_NO_PROTSEQS:
        case LW_ERROR_RPC_S_NO_PROTSEQS_REGISTERED:
        case LW_ERROR_RPC_S_NO_BINDINGS:
        case LW_ERROR_RPC_S_MAX_DESCS_EXCEEDED:
        case LW_ERROR_RPC_S_NO_INTERFACES:
        case LW_ERROR_RPC_S_INVALID_TIMEOUT:
        case LW_ERROR_RPC_S_CANT_INQ_SOCKET:
        case LW_ERROR_RPC_S_INVALID_NAF_ID:
        case LW_ERROR_RPC_S_INVAL_NET_ADDR:
        case LW_ERROR_RPC_S_UNKNOWN_IF:
        case LW_ERROR_RPC_S_UNSUPPORTED_TYPE:
        case LW_ERROR_RPC_S_INVALID_CALL_OPT:
        case LW_ERROR_RPC_S_NO_FAULT:
        case LW_ERROR_RPC_S_CANCEL_TIMEOUT:
        case LW_ERROR_RPC_S_CALL_CANCELLED:
        case LW_ERROR_RPC_S_INVALID_CALL_HANDLE:
        case LW_ERROR_RPC_S_CANNOT_ALLOC_ASSOC:
        case LW_ERROR_RPC_S_CANNOT_ACCEPT:
        case LW_ERROR_RPC_S_ASSOC_GRP_NOT_FOUND:
        case LW_ERROR_RPC_S_STUB_INTERFACE_ERROR:
        case LW_ERROR_RPC_S_INVALID_OBJECT:
        case LW_ERROR_RPC_S_INVALID_TYPE:
        case LW_ERROR_RPC_S_INVALID_IF_OPNUM:
        case LW_ERROR_RPC_S_DIFFERENT_SERVER_INSTANCE:
        case LW_ERROR_RPC_S_PROTOCOL_ERROR:
        case LW_ERROR_RPC_S_CANT_RECVMSG:
        case LW_ERROR_RPC_S_INVALID_STRING_BINDING:
        case LW_ERROR_RPC_S_NETWORK_UNREACHABLE:
        case LW_ERROR_RPC_S_CONNECT_NO_RESOURCES:
        case LW_ERROR_RPC_S_REM_NETWORK_SHUTDOWN:
        case LW_ERROR_RPC_S_TOO_MANY_REM_CONNECTS:
        case LW_ERROR_RPC_S_NO_REM_ENDPOINT:
        case LW_ERROR_RPC_S_REM_HOST_DOWN:
        case LW_ERROR_RPC_S_HOST_UNREACHABLE:
        case LW_ERROR_RPC_S_ACCESS_CONTROL_INFO_INV:
        case LW_ERROR_RPC_S_LOC_CONNECT_ABORTED:
        case LW_ERROR_RPC_S_CONNECT_CLOSED_BY_REM:
        case LW_ERROR_RPC_S_REM_HOST_CRASHED:
        case LW_ERROR_RPC_S_INVALID_ENDPOINT_FORMAT:
        case LW_ERROR_RPC_S_UNKNOWN_STATUS_CODE:
        case LW_ERROR_RPC_S_UNKNOWN_MGR_TYPE:
        case LW_ERROR_RPC_S_ASSOC_CREATION_FAILED:
        case LW_ERROR_RPC_S_ASSOC_GRP_MAX_EXCEEDED:
        case LW_ERROR_RPC_S_ASSOC_GRP_ALLOC_FAILED:
        case LW_ERROR_RPC_S_SM_INVALID_STATE:
        case LW_ERROR_RPC_S_ASSOC_REQ_REJECTED:
        case LW_ERROR_RPC_S_ASSOC_SHUTDOWN:
        case LW_ERROR_RPC_S_TSYNTAXES_UNSUPPORTED:
        case LW_ERROR_RPC_S_CONTEXT_ID_NOT_FOUND:
        case LW_ERROR_RPC_S_CANT_LISTEN_SOCKET:
        case LW_ERROR_RPC_S_NO_ADDRS:
        case LW_ERROR_RPC_S_CANT_GETPEERNAME:
        case LW_ERROR_RPC_S_CANT_GET_IF_ID:
        case LW_ERROR_RPC_S_PROTSEQ_NOT_SUPPORTED:
        case LW_ERROR_RPC_S_CALL_ORPHANED:
        case LW_ERROR_RPC_S_WHO_ARE_YOU_FAILED:
        case LW_ERROR_RPC_S_UNKNOWN_REJECT:
        case LW_ERROR_RPC_S_TYPE_ALREADY_REGISTERED:
        case LW_ERROR_RPC_S_STOP_LISTENING_DISABLED:
        case LW_ERROR_RPC_S_INVALID_ARG:
        case LW_ERROR_RPC_S_NOT_SUPPORTED:
        case LW_ERROR_RPC_S_WRONG_KIND_OF_BINDING:
        case LW_ERROR_RPC_S_AUTHN_AUTHZ_MISMATCH:
        case LW_ERROR_RPC_S_CALL_QUEUED:
        case LW_ERROR_RPC_S_CANNOT_SET_NODELAY:
        case LW_ERROR_RPC_S_NOT_RPC_TOWER:
        case LW_ERROR_RPC_S_INVALID_RPC_PROTID:
        case LW_ERROR_RPC_S_INVALID_RPC_FLOOR:
        case LW_ERROR_RPC_S_MGMT_OP_DISALLOWED:
        case LW_ERROR_RPC_S_MANAGER_NOT_ENTERED:
        case LW_ERROR_RPC_S_CALLS_TOO_LARGE_FOR_WK_EP:
        case LW_ERROR_RPC_S_SERVER_TOO_BUSY:
        case LW_ERROR_RPC_S_PROT_VERSION_MISMATCH:
        case LW_ERROR_RPC_S_RPC_PROT_VERSION_MISMATCH:
        case LW_ERROR_RPC_S_SS_NO_IMPORT_CURSOR:
        case LW_ERROR_RPC_S_FAULT_ADDR_ERROR:
        case LW_ERROR_RPC_S_FAULT_CONTEXT_MISMATCH:
        case LW_ERROR_RPC_S_FAULT_FP_DIV_BY_ZERO:
        case LW_ERROR_RPC_S_FAULT_FP_ERROR:
        case LW_ERROR_RPC_S_FAULT_FP_OVERFLOW:
        case LW_ERROR_RPC_S_FAULT_FP_UNDERFLOW:
        case LW_ERROR_RPC_S_FAULT_ILL_INST:
        case LW_ERROR_RPC_S_FAULT_INT_DIV_BY_ZERO:
        case LW_ERROR_RPC_S_FAULT_INT_OVERFLOW:
        case LW_ERROR_RPC_S_FAULT_INVALID_BOUND:
        case LW_ERROR_RPC_S_FAULT_INVALID_TAG:
        case LW_ERROR_RPC_S_FAULT_PIPE_CLOSED:
        case LW_ERROR_RPC_S_FAULT_PIPE_COMM_ERROR:
        case LW_ERROR_RPC_S_FAULT_PIPE_DISCIPLINE:
        case LW_ERROR_RPC_S_FAULT_PIPE_EMPTY:
        case LW_ERROR_RPC_S_FAULT_PIPE_MEMORY:
        case LW_ERROR_RPC_S_FAULT_PIPE_ORDER:
        case LW_ERROR_RPC_S_FAULT_REMOTE_COMM_FAILURE:
        case LW_ERROR_RPC_S_FAULT_REMOTE_NO_MEMORY:
        case LW_ERROR_RPC_S_FAULT_UNSPEC:
        case LW_ERROR_UUID_S_BAD_VERSION:
        case LW_ERROR_UUID_S_SOCKET_FAILURE:
        case LW_ERROR_UUID_S_GETCONF_FAILURE:
        case LW_ERROR_UUID_S_NO_ADDRESS:
        case LW_ERROR_UUID_S_OVERRUN:
        case LW_ERROR_UUID_S_INTERNAL_ERROR:
        case LW_ERROR_UUID_S_CODING_ERROR:
        case LW_ERROR_UUID_S_INVALID_STRING_UUID:
        case LW_ERROR_UUID_S_NO_MEMORY:
        case LW_ERROR_RPC_S_NO_MORE_ENTRIES:
        case LW_ERROR_RPC_S_UNKNOWN_NS_ERROR:
        case LW_ERROR_RPC_S_NAME_SERVICE_UNAVAILABLE:
        case LW_ERROR_RPC_S_INCOMPLETE_NAME:
        case LW_ERROR_RPC_S_GROUP_NOT_FOUND:
        case LW_ERROR_RPC_S_INVALID_NAME_SYNTAX:
        case LW_ERROR_RPC_S_NO_MORE_MEMBERS:
        case LW_ERROR_RPC_S_NO_MORE_INTERFACES:
        case LW_ERROR_RPC_S_INVALID_NAME_SERVICE:
        case LW_ERROR_RPC_S_NO_NAME_MAPPING:
        case LW_ERROR_RPC_S_PROFILE_NOT_FOUND:
        case LW_ERROR_RPC_S_NOT_FOUND:
        case LW_ERROR_RPC_S_NO_UPDATES:
        case LW_ERROR_RPC_S_UPDATE_FAILED:
        case LW_ERROR_RPC_S_NO_MATCH_EXPORTED:
        case LW_ERROR_RPC_S_ENTRY_NOT_FOUND:
        case LW_ERROR_RPC_S_INVALID_INQUIRY_CONTEXT:
        case LW_ERROR_RPC_S_INTERFACE_NOT_FOUND:
        case LW_ERROR_RPC_S_GROUP_MEMBER_NOT_FOUND:
        case LW_ERROR_RPC_S_ENTRY_ALREADY_EXISTS:
        case LW_ERROR_RPC_S_NSINIT_FAILURE:
        case LW_ERROR_RPC_S_UNSUPPORTED_NAME_SYNTAX:
        case LW_ERROR_RPC_S_NO_MORE_ELEMENTS:
        case LW_ERROR_RPC_S_NO_NS_PERMISSION:
        case LW_ERROR_RPC_S_INVALID_INQUIRY_TYPE:
        case LW_ERROR_RPC_S_PROFILE_ELEMENT_NOT_FOUND:
        case LW_ERROR_RPC_S_PROFILE_ELEMENT_REPLACED:
        case LW_ERROR_RPC_S_IMPORT_ALREADY_DONE:
        case LW_ERROR_RPC_S_DATABASE_BUSY:
        case LW_ERROR_RPC_S_INVALID_IMPORT_CONTEXT:
        case LW_ERROR_RPC_S_UUID_SET_NOT_FOUND:
        case LW_ERROR_RPC_S_UUID_MEMBER_NOT_FOUND:
        case LW_ERROR_RPC_S_NO_INTERFACES_EXPORTED:
        case LW_ERROR_RPC_S_TOWER_SET_NOT_FOUND:
        case LW_ERROR_RPC_S_TOWER_MEMBER_NOT_FOUND:
        case LW_ERROR_RPC_S_OBJ_UUID_NOT_FOUND:
        case LW_ERROR_RPC_S_NO_MORE_BINDINGS:
        case LW_ERROR_RPC_S_INVALID_PRIORITY:
        case LW_ERROR_RPC_S_NOT_RPC_ENTRY:
        case LW_ERROR_RPC_S_INVALID_LOOKUP_CONTEXT:
        case LW_ERROR_RPC_S_BINDING_VECTOR_FULL:
        case LW_ERROR_RPC_S_CYCLE_DETECTED:
        case LW_ERROR_RPC_S_NOTHING_TO_EXPORT:
        case LW_ERROR_RPC_S_NOTHING_TO_UNEXPORT:
        case LW_ERROR_RPC_S_INVALID_VERS_OPTION:
        case LW_ERROR_RPC_S_NO_RPC_DATA:
        case LW_ERROR_RPC_S_MBR_PICKED:
        case LW_ERROR_RPC_S_NOT_ALL_OBJS_UNEXPORTED:
        case LW_ERROR_RPC_S_NO_ENTRY_NAME:
        case LW_ERROR_RPC_S_PRIORITY_GROUP_DONE:
        case LW_ERROR_RPC_S_PARTIAL_RESULTS:
        case LW_ERROR_RPC_S_NO_ENV_SETUP:
        case LW_ERROR_TWR_S_UNKNOWN_SA:
        case LW_ERROR_TWR_S_UNKNOWN_TOWER:
        case LW_ERROR_TWR_S_NOT_IMPLEMENTED:
        case LW_ERROR_RPC_S_MAX_CALLS_TOO_SMALL:
        case LW_ERROR_RPC_S_CTHREAD_CREATE_FAILED:
        case LW_ERROR_RPC_S_CTHREAD_POOL_EXISTS:
        case LW_ERROR_RPC_S_CTHREAD_NO_SUCH_POOL:
        case LW_ERROR_RPC_S_CTHREAD_INVOKE_DISABLED:
        case LW_ERROR_EPT_S_CANT_PERFORM_OP:
        case LW_ERROR_EPT_S_NO_MEMORY:
        case LW_ERROR_EPT_S_DATABASE_INVALID:
        case LW_ERROR_EPT_S_CANT_CREATE:
        case LW_ERROR_EPT_S_CANT_ACCESS:
        case LW_ERROR_EPT_S_DATABASE_ALREADY_OPEN:
        case LW_ERROR_EPT_S_INVALID_ENTRY:
        case LW_ERROR_EPT_S_UPDATE_FAILED:
        case LW_ERROR_EPT_S_INVALID_CONTEXT:
        case LW_ERROR_EPT_S_NOT_REGISTERED:
        case LW_ERROR_EPT_S_SERVER_UNAVAILABLE:
        case LW_ERROR_RPC_S_UNDERSPECIFIED_NAME:
        case LW_ERROR_RPC_S_INVALID_NS_HANDLE:
        case LW_ERROR_RPC_S_UNKNOWN_ERROR:
        case LW_ERROR_RPC_S_SS_CHAR_TRANS_OPEN_FAIL:
        case LW_ERROR_RPC_S_SS_CHAR_TRANS_SHORT_FILE:
        case LW_ERROR_RPC_S_SS_CONTEXT_DAMAGED:
        case LW_ERROR_RPC_S_SS_IN_NULL_CONTEXT:
        case LW_ERROR_RPC_S_SOCKET_FAILURE:
        case LW_ERROR_RPC_S_UNSUPPORTED_PROTECT_LEVEL:
        case LW_ERROR_RPC_S_INVALID_CHECKSUM:
        case LW_ERROR_RPC_S_CREDENTIALS_TOO_LARGE:
        case LW_ERROR_RPC_S_CALL_ID_NOT_FOUND:
        case LW_ERROR_RPC_S_KEY_ID_NOT_FOUND:
        case LW_ERROR_RPC_S_AUTH_BAD_INTEGRITY:
        case LW_ERROR_RPC_S_AUTH_TKT_EXPIRED:
        case LW_ERROR_RPC_S_AUTH_TKT_NYV:
        case LW_ERROR_RPC_S_AUTH_REPEAT:
        case LW_ERROR_RPC_S_AUTH_NOT_US:
        case LW_ERROR_RPC_S_AUTH_BADMATCH:
        case LW_ERROR_RPC_S_AUTH_SKEW:
        case LW_ERROR_RPC_S_AUTH_BADADDR:
        case LW_ERROR_RPC_S_AUTH_BADVERSION:
        case LW_ERROR_RPC_S_AUTH_MSG_TYPE:
        case LW_ERROR_RPC_S_AUTH_MODIFIED:
        case LW_ERROR_RPC_S_AUTH_BADORDER:
        case LW_ERROR_RPC_S_AUTH_BADKEYVER:
        case LW_ERROR_RPC_S_AUTH_NOKEY:
        case LW_ERROR_RPC_S_AUTH_MUT_FAIL:
        case LW_ERROR_RPC_S_AUTH_BADDIRECTION:
        case LW_ERROR_RPC_S_AUTH_METHOD:
        case LW_ERROR_RPC_S_AUTH_BADSEQ:
        case LW_ERROR_RPC_S_AUTH_INAPP_CKSUM:
        case LW_ERROR_RPC_S_AUTH_FIELD_TOOLONG:
        case LW_ERROR_RPC_S_INVALID_CRC:
        case LW_ERROR_RPC_S_BINDING_INCOMPLETE:
        case LW_ERROR_RPC_S_KEY_FUNC_NOT_ALLOWED:
        case LW_ERROR_RPC_S_UNKNOWN_STUB_RTL_IF_VERS:
        case LW_ERROR_RPC_S_UNKNOWN_IFSPEC_VERS:
        case LW_ERROR_RPC_S_PROTO_UNSUPP_BY_AUTH:
        case LW_ERROR_RPC_S_AUTHN_CHALLENGE_MALFORMED:
        case LW_ERROR_RPC_S_PROTECT_LEVEL_MISMATCH:
        case LW_ERROR_RPC_S_NO_MEPV:
        case LW_ERROR_RPC_S_STUB_PROTOCOL_ERROR:
        case LW_ERROR_RPC_S_CLASS_VERSION_MISMATCH:
        case LW_ERROR_RPC_S_HELPER_NOT_RUNNING:
        case LW_ERROR_RPC_S_HELPER_SHORT_READ:
        case LW_ERROR_RPC_S_HELPER_CATATONIC:
        case LW_ERROR_RPC_S_HELPER_ABORTED:
        case LW_ERROR_RPC_S_NOT_IN_KERNEL:
        case LW_ERROR_RPC_S_HELPER_WRONG_USER:
        case LW_ERROR_RPC_S_HELPER_OVERFLOW:
        case LW_ERROR_RPC_S_DG_NEED_WAY_AUTH:
        case LW_ERROR_RPC_S_UNSUPPORTED_AUTH_SUBTYPE:
        case LW_ERROR_RPC_S_WRONG_PICKLE_TYPE:
        case LW_ERROR_RPC_S_NOT_LISTENING:
        case LW_ERROR_RPC_S_SS_BAD_BUFFER:
        case LW_ERROR_RPC_S_SS_BAD_ES_ACTION:
        case LW_ERROR_RPC_S_SS_WRONG_ES_VERSION:
        case LW_ERROR_RPC_S_FAULT_USER_DEFINED:
        case LW_ERROR_RPC_S_SS_INCOMPATIBLE_CODESETS:
        case LW_ERROR_RPC_S_TX_NOT_IN_TRANSACTION:
        case LW_ERROR_RPC_S_TX_OPEN_FAILED:
        case LW_ERROR_RPC_S_PARTIAL_CREDENTIALS:
        case LW_ERROR_RPC_S_SS_INVALID_CODESET_TAG:
        case LW_ERROR_RPC_S_MGMT_BAD_TYPE:
        case LW_ERROR_RPC_S_SS_INVALID_CHAR_INPUT:
        case LW_ERROR_RPC_S_SS_SHORT_CONV_BUFFER:
        case LW_ERROR_RPC_S_SS_ICONV_ERROR:
        case LW_ERROR_RPC_S_SS_NO_COMPAT_CODESET:
        case LW_ERROR_RPC_S_SS_NO_COMPAT_CHARSETS:
        case LW_ERROR_DCE_CS_C_OK:
        case LW_ERROR_DCE_CS_C_UNKNOWN:
        case LW_ERROR_DCE_CS_C_NOTFOUND:
        case LW_ERROR_DCE_CS_C_CANNOT_OPEN_FILE:
        case LW_ERROR_DCE_CS_C_CANNOT_READ_FILE:
        case LW_ERROR_DCE_CS_C_CANNOT_ALLOCATE_MEMORY:
        case LW_ERROR_RPC_S_SS_CLEANUP_FAILED:
        case LW_ERROR_RPC_SVC_DESC_GENERAL:
        case LW_ERROR_RPC_SVC_DESC_MUTEX:
        case LW_ERROR_RPC_SVC_DESC_XMIT:
        case LW_ERROR_RPC_SVC_DESC_RECV:
        case LW_ERROR_RPC_SVC_DESC_DG_STATE:
        case LW_ERROR_RPC_SVC_DESC_CANCEL:
        case LW_ERROR_RPC_SVC_DESC_ORPHAN:
        case LW_ERROR_RPC_SVC_DESC_CN_STATE:
        case LW_ERROR_RPC_SVC_DESC_CN_PKT:
        case LW_ERROR_RPC_SVC_DESC_PKT_QUOTAS:
        case LW_ERROR_RPC_SVC_DESC_AUTH:
        case LW_ERROR_RPC_SVC_DESC_SOURCE:
        case LW_ERROR_RPC_SVC_DESC_STATS:
        case LW_ERROR_RPC_SVC_DESC_MEM:
        case LW_ERROR_RPC_SVC_DESC_MEM_TYPE:
        case LW_ERROR_RPC_SVC_DESC_DG_PKTLOG:
        case LW_ERROR_RPC_SVC_DESC_THREAD_ID:
        case LW_ERROR_RPC_SVC_DESC_TIMESTAMP:
        case LW_ERROR_RPC_SVC_DESC_CN_ERRORS:
        case LW_ERROR_RPC_SVC_DESC_CONV_THREAD:
        case LW_ERROR_RPC_SVC_DESC_PID:
        case LW_ERROR_RPC_SVC_DESC_ATFORK:
        case LW_ERROR_RPC_SVC_DESC_CMA_THREAD:
        case LW_ERROR_RPC_SVC_DESC_INHERIT:
        case LW_ERROR_RPC_SVC_DESC_DG_SOCKETS:
        case LW_ERROR_RPC_SVC_DESC_TIMER:
        case LW_ERROR_RPC_SVC_DESC_THREADS:
        case LW_ERROR_RPC_SVC_DESC_SERVER_CALL:
        case LW_ERROR_RPC_SVC_DESC_NSI:
        case LW_ERROR_RPC_SVC_DESC_DG_PKT:
        case LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_SA:
        case LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_CA:
        case LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_SG:
        case LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_CG:
        case LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_SR:
        case LW_ERROR_RPC_M_CN_ILL_STATE_TRANS_CR:
        case LW_ERROR_RPC_M_BAD_PKT_TYPE:
        case LW_ERROR_RPC_M_PROT_MISMATCH:
        case LW_ERROR_RPC_M_FRAG_TOOBIG:
        case LW_ERROR_RPC_M_UNSUPP_STUB_RTL_IF:
        case LW_ERROR_RPC_M_UNHANDLED_CALLSTATE:
        case LW_ERROR_RPC_M_CALL_FAILED:
        case LW_ERROR_RPC_M_CALL_FAILED_NO_STATUS:
        case LW_ERROR_RPC_M_CALL_FAILED_ERRNO:
        case LW_ERROR_RPC_M_CALL_FAILED_S:
        case LW_ERROR_RPC_M_CALL_FAILED_C:
        case LW_ERROR_RPC_M_ERRMSG_TOOBIG:
        case LW_ERROR_RPC_M_INVALID_SRCHATTR:
        case LW_ERROR_RPC_M_NTS_NOT_FOUND:
        case LW_ERROR_RPC_M_INVALID_ACCBYTCNT:
        case LW_ERROR_RPC_M_PRE_V2_IFSPEC:
        case LW_ERROR_RPC_M_UNK_IFSPEC:
        case LW_ERROR_RPC_M_RECVBUF_TOOSMALL:
        case LW_ERROR_RPC_M_UNALIGN_AUTHTRL:
        case LW_ERROR_RPC_M_UNEXPECTED_EXC:
        case LW_ERROR_RPC_M_NO_STUB_DATA:
        case LW_ERROR_RPC_M_EVENTLIST_FULL:
        case LW_ERROR_RPC_M_UNK_SOCK_TYPE:
        case LW_ERROR_RPC_M_UNIMP_CALL:
        case LW_ERROR_RPC_M_INVALID_SEQNUM:
        case LW_ERROR_RPC_M_CANT_CREATE_UUID:
        case LW_ERROR_RPC_M_PRE_V2_SS:
        case LW_ERROR_RPC_M_DGPKT_POOL_CORRUPT:
        case LW_ERROR_RPC_M_DGPKT_BAD_FREE:
        case LW_ERROR_RPC_M_LOOKASIDE_CORRUPT:
        case LW_ERROR_RPC_M_ALLOC_FAIL:
        case LW_ERROR_RPC_M_REALLOC_FAIL:
        case LW_ERROR_RPC_M_CANT_OPEN_FILE:
        case LW_ERROR_RPC_M_CANT_READ_ADDR:
        case LW_ERROR_RPC_SVC_DESC_LIBIDL:
        case LW_ERROR_RPC_M_CTXRUNDOWN_NOMEM:
        case LW_ERROR_RPC_M_CTXRUNDOWN_EXC:
        case LW_ERROR_RPC_S_FAULT_CODESET_CONV_ERROR:
        default:
            return LW_STATUS_UNSUCCESSFUL;
    }
}
