//-*- C++ -*-
/*
 * lingot, a musical instrument tuner.
 *
 * Copyright (C) 2004-2007  Ibán Cereijo Graña, Jairo Chapela Martínez.
 *
 * This file is part of lingot.
 *
 * lingot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * lingot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with lingot; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FILTERS_H__
#define __FILTERS_H__

/*
 * 8 order Chebyshev filters, with wc=0.9/i (normalized respect to
 * Pi). We take 0.9 instead of 1 to leave a 10% of safety margin,
 * in order to avoid aliased frequencies near to w=Pi, due to non
 * ideality of the filter.
 *
 * The cut frequencies wc=Pi/i, with i=1..20, correspond with the
 * oversampling factor, avoiding aliasing at decimation.
 * 
 * Why Chebyshev filters?, for a given order, those filters yield
 * abrupt falls than other ones as Butterworth, making the most of
 * the order. Although Chebyshev filters affects more to the phase,
 * it doesn't matter due to the analysis is made on the signal
 * power distribution (only module).
 */

/*
 * Undefined number of filters, each of one consisting of 2 vectors of 9
 * coefs (order 8).
 */
FLT filtros[][2][9] = {

{ { 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, }, // a
		{	1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,} // b
	},
	{
		{	1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,},
		{	1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,}
	},
	{
		{	1.000000000000000000000000000000, -3.048747378072409919269603051362, 5.938041170694262405049812514335, -7.875101223756617585536332626361, 7.733746866089088456419631256722, -5.632984001373067428630747599527, 2.976789578734021279871058140998, -1.053224419147983148548064491479, 0.199317892114461853170226390830, },
    { 0.000877085971990654300611822691, 0.007016687775925234404894581530, 0.024558407215744537666068936232, 0.049116814431466870871645369334, 0.061396018039364896878851141082, 0.049116814431463318157966568833, 0.024558407215748978558167436859, 0.007016687775921903735820706061, 0.000877085971991486967880291559, }
  },
  {
    { 1.000000000000000000000000000000, -5.334705493439848567049921257421, 13.700373890574939039765922643710, -21.755886964842758857230364810675, 23.182023275094618242064825608395, -16.903296590408405819516701740213, 8.223924772470939004165302321780, -2.442774113529026625002416039933, 0.340337588036542348923774170544, },
    { 0.000036863969206657465349508129, 0.000294911753657700614894565661, 0.001032191137765536836923274677, 0.002064382275619891515816561878, 0.002580477844407624843370285816, 0.002064382275630549656852963381, 0.001032191137760207766405073926, 0.000294911753663029685412766412, 0.000036863969205269686568726684, }
  },
  {
    { 1.000000000000000000000000000000, -6.269468796121654641240183991613, 18.010562756914342941172435530461, -30.828723620346014655524413683452, 34.297447347898433633872627979144, -25.353541377528586053813342005014, 12.151454969092625901794235687703, -3.451915847984420970817609486403, 0.445256020613279512865290143964, },
    { 0.000003951236023147508547026518, 0.000031609888188732782055012649, 0.000110634608631698938552290201, 0.000221269217345110291716991924, 0.000276586521543720209592720494, 0.000221269217362873860110994428, 0.000110634608606829942800686695, 0.000031609888198502744671714026, 0.000003951236021204618253932495, }
  },
  {
    { 1.000000000000000000000000000000, -6.752065911721229163333646283718, 20.505700433157247886128971003927, -36.520456184128128995780571131036, 41.669620235572544686419860227033, -31.165904432513571009621955454350, 14.914644430978633238282782258466, -4.174665517946735349141818005592, 0.523316003683187092043738175562, },
    { 0.000000697192947041180843825714, 0.000005577543579882160429406213, 0.000019521402496280870764167048, 0.000039042805092037724534748122, 0.000048803506217609537998214364, 0.000039042805109801292928750627, 0.000019521402476740945530764293, 0.000005577543591428479885507841, 0.000000697192945153801701962948, }
  },
  {
    { 1.000000000000000000000000000000, -7.038481574626036518793625873514, 22.079147824627106899697537301108, -40.282790893826032174729334656149, 46.723597002533828970172180561349, -35.264674407524253751944343093783, 16.908501444257879597898863721639, -4.708134390753435205567711818730, 0.582880643345142668287905962643, },
    { 0.000000168337981110155965325248, 0.000001346703846216712463501608, 0.000004713463486183400164009072, 0.000009426926901312526752008125, 0.000011783658734998425643425435, 0.000009426926894207099394407123, 0.000004713463496841541200410575, 0.000001346703840887641945300857, 0.000000168337981998334385025373, }
  },
  {
    { 1.000000000000000000000000000000, -7.224926506184424113143904833123, 23.143084134203469659496477106586, -42.907895444454588584903831360862, 50.343080246886387385529815219343, -38.265805061617612636837293393910, 18.397907749965341395181894768029, -5.114993391948030598825880588265, 0.629561959531540704659846596769, },
    { 0.000000050471788526351701875683, 0.000000403774301993564677104587, 0.000001413210117817698119324632, 0.000002826420043788857583422214, 0.000003533025363822162034921348, 0.000002826419986945438722614199, 0.000001413210178213830658933148, 0.000000403774275348212086100830, 0.000000050471793078266102838825, }
  },
  {
    { 1.000000000000000000000000000000, -7.354525178489394576786253310274, 23.902363699344924441447801655158, -44.824291545148497561967815272510, 53.038254218017272023644181899726, -40.540648088789147607258200878277, 19.546157715920738695558611652814, -5.434330305574429864634566911263, 0.667024294498514636053698723117, },
    { 0.000000017737207369528107392398, 0.000000141897658956224859139184, 0.000000496641803238162538036704, 0.000000993283620687179791275412, 0.000001241604493884551629889756, 0.000000993283627792607148876414, 0.000000496641803238162538036704, 0.000000141897660732581698539434, 0.000000017737207036461200004851, }
  },
  {
    { 1.000000000000000000000000000000, -7.449122589341579114829983154777, 24.467490677621050565448967972770, -46.275602004661337218749395105988, 55.111601879999170705559663474560, -42.316400101610277317831787513569, 20.455433004841399480255859089084, -5.691102705614421886082254786743, 0.697703747590213141371862093365, },
    { 0.000000007039243299367115014320, 0.000000056313944618580080714310, 0.000000197098817267260528751649, 0.000000394197627429093699902296, 0.000000492747041391794482478872, 0.000000394197606112811627099290, 0.000000197098813714546849951148, 0.000000056313946394936920114560, 0.000000007039243299367115014320, }
  },
  {
    { 1.000000000000000000000000000000, -7.520828283194780361498033016687, 24.902389287693104336085525574163, -47.407976767260564088246610481292, 56.750150552512593549181474372745, -43.737024604810841310609248466790, 21.191813880121397772882119170390, -5.901787861487504116553282074165, 0.723264630411560971445794621104, },
    { 0.000000003075517840400721070182, 0.000000024604136505956830660580, 0.000000086114543051962755271234, 0.000000172228880046532140113413, 0.000000215286441118678339989856, 0.000000172228816097685921704397, 0.000000086114607000808973680250, 0.000000024604108084247400256572, 0.000000003075522725382029420871, }
  },
  {
    { 1.000000000000000000000000000000, -7.576836455254832181083202158334, 25.246232447634564977079207892530, -48.313428415409703120531048625708, 58.074413856595128891058266162872, -44.897155642924900575962965376675, 21.799526653310852708500533481129, -6.077627837066981619784655777039, 0.744875787031880953747986495728, },
    { 0.000000001452658993095212736080, 0.000000011621273721118541288888, 0.000000040674443368970969459042, 0.000000081348929370506084524095, 0.000000101686090658859029645100, 0.000000081348943581360799726099, 0.000000040674429158116254257038, 0.000000011621278162010639789514, 0.000000001452657882872188110923, }
  },
  {
    { 1.000000000000000000000000000000, -7.621662361970952481726726546185, 25.524195985245590634349355241284, -49.052349829754739118925499496982, 59.164978301326016207895008847117, -45.861139601100148865953087806702, 22.309123143051294846372911706567, -6.226524724977961611216414894443, 0.763379286634151665857928037440, },
    { 0.000000000731843585732860901771, 0.000000005854746021327628113795, 0.000000020491633279107190901414, 0.000000040983202609368163393810, 0.000000051229108066763728857040, 0.000000040983195503940805792809, 0.000000020491643937248227302916, 0.000000005854739804078690212918, 0.000000000731844362888978139381, }
  },
  {
    { 1.000000000000000000000000000000, -7.658269156827948620502866106108, 25.753115497341003248266133596189, -49.665819167577858195272710872814, 60.077508263323672110800544032827, -46.674061415285763132487772963941, 22.742311405656820966214581858367, -6.354181132260669606637293327367, 0.779395811184788733783079806017, },
    { 0.000000000389255627730733522185, 0.000000003114045021845868177479, 0.000000010899164237798686372116, 0.000000021798307159315299941227, 0.000000027247914147210394730791, 0.000000021798307159315299941227, 0.000000010899164237798686372116, 0.000000003114041469132189376978, 0.000000000389255960797640909732, }
  },
  {
    { 1.000000000000000000000000000000, -7.688674621088168237292848061770, 25.944632889682722520774404983968, -50.182645407828573524966486729681, 60.851554622958310858393815578893, -47.368353683451644542401481885463, 23.114902705458650444825252634473, -6.464808700145178832485726161394, 0.793392253215603249216769654595, },
    { 0.000000000216845319478409237490, 0.000000001734762555827273899922, 0.000000006071665836770989699289, 0.000000012143352989824052201584, 0.000000015179161039213795447722, 0.000000012143352989824052201584, 0.000000006071662284057310898788, 0.000000001734764332184113300173, 0.000000000216845097433804312459, }
  },
  {
    { 1.000000000000000000000000000000, -7.714296195787382792730113578727, 26.107032026848528971640917006880, -50.623573939991274528438225388527, 61.515919711463538988027721643448, -47.967892908986968336648715194315, 23.438666962263749127259870874695, -6.561581836541133583295959397219, 0.805726214822989783570506006072, },
    { 0.000000000125722543486972426763, 0.000000001005779459717359713977, 0.000000003520241875776264350861, 0.000000007040426908133667893708, 0.000000008800633111150091281161, 0.000000007040412697278952691704, 0.000000003520266744772015954368, 0.000000001005769689754743012600, 0.000000000125723986776904439466, }
  },
  {
    { 1.000000000000000000000000000000, -7.736156385805464275051690492546, 26.246354353407966186750854831189, -51.003890820329544908418029081076, 62.092035570216538076238066423684, -48.490617831487256239597627427429, 23.722535608489558001110708573833, -6.646936495877659112352375814226, 0.816676021852326905481334051728, },
    { 0.000000000075474959615462466900, 0.000000000603799676923699735198, 0.000000002113296204697689972818, 0.000000004226613725677452748641, 0.000000005283219195462152129039, 0.000000004226613725677452748641, 0.000000002113289099270332371816, 0.000000000603802341458958835574, 0.000000000075474515526252616837, }
  },
  {
    { 1.000000000000000000000000000000, -7.755009897471405011515344085637, 26.367101352145461135023651877418, -51.335088439366103330030455254018, 62.596155651190073854195361491293, -48.950250490841369810368632897735, 23.973402362083330530140301561914, -6.722771950127921058992797043175, 0.826461425056844944947442854755, },
    { 0.000000000046719628166158599925, 0.000000000373757913507688499521, 0.000000001308144703671132447198, 0.000000002616310723624337697402, 0.000000003270343995609437115490, 0.000000002616324934479052899405, 0.000000001308134045530096045695, 0.000000000373763242578206700273, 0.000000000046718628965436437284, }
  },
  {
    { 1.000000000000000000000000000000, -7.771425016560233878237795579480, 26.472690724958908958797110244632, -51.625961757531854345870669931173, 63.040815141316521419412310933694, -49.357456320504255131709214765579, 24.196669246663347507819707971066, -6.790590181381364054402638430474, 0.835258171097046364650395844365, },
    { 0.000000000029716229477116939961, 0.000000000237729835816935519688, 0.000000000832052649002434918657, 0.000000001664112403432227438316, 0.000000002080128069792408496141, 0.000000001664119508859585039318, 0.000000000832045543575077317655, 0.000000000237731612173774919938, 0.000000000029716007432512014930, }
  },
  {
    { 1.000000000000000000000000000000, -7.785837239776224549814287456684, 26.565760791628530768093696678989, -51.883348305888247864459117408842, 63.435827460048471948539372533560, -49.720644006537028758430096786469, 24.396627029380873352693015476689, -6.851594173439702117889282817487, 0.843208449834519924159792481078, },
    { 0.000000000019365065107024292956, 0.000000000154917856320935243275, 0.000000000542232925226926454343, 0.000000001084416112462349701673, 0.000000001355594747565191937611, 0.000000001084401901607634499669, 0.000000000542250688795320456848, 0.000000000154910750893577642273, 0.000000000019366397374653843144, }
  },
  {
    { 1.000000000000000000000000000000, -7.798585538297180264066810195800, 26.648378547696491835949927917682, -52.112639137669646061112871393561, 63.788978957435162442379805725068, -50.046528326468532554827106650919, 24.576725503879991663325199624524, -6.906758514827502359878508286783, 0.850428511748594906372034074593, },
    { 0.000000000012897460877070443530, 0.000000000103177022481304447865, 0.000000000361129792736392118968, 0.000000000722245374618069035932, 0.000000000902822705484140897170, 0.000000000722252480045426636934, 0.000000000361119134595355717465, 0.000000000103180575194983248366, 0.000000000012897016787860593467, }
  },

};

#endif
